/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.local;

import com.google.flatbuffers.FlatBufferBuilder;
import io.ipfs.api.IPFS;
import io.ipfs.api.MerkleNode;
import io.ipfs.api.NamedStreamable;
import io.ipfs.multihash.Multihash;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.PublishResult;
import io.proximax.xpx.service.intf.UploadApi;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import io.proximax.xpx.utils.ContentTypeUtils;
import io.proximax.xpx.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.pmw.tinylog.Logger;

public class LocalUploadApi
implements UploadApi {
    private final IPFS proximaxIfpsConnection;

    public LocalUploadApi(IPFS proximaxIfpsConnection) {
        this.proximaxIfpsConnection = proximaxIfpsConnection;
    }

    @Override
    public String deletePinnedContent(String multihash) throws ApiException, IOException {
        return this.proximaxIfpsConnection.pin.rm(Multihash.fromBase58((String)multihash)).toString();
    }

    @Override
    public byte[] uploadBytesBinary(byte[] binaryData, String name, String contentType, String keywords, String metadata) throws IOException, NoSuchAlgorithmException {
        String nameOrDefault = StringUtils.isEmpty(name) ? String.valueOf(Math.abs(System.currentTimeMillis())) : name;
        String contentTypeOrDetected = ContentTypeUtils.contentTypeLookup(contentType, binaryData);
        String keywordsOrDefault = keywords == null ? "" : keywords;
        String metadataOrDefault = metadata == null ? "" : metadata;
        PublishResult spfsBlockResult = this.exposeAndPinBinary(nameOrDefault, binaryData);
        String multiHashString = spfsBlockResult.getMerkleNode().get((int)0).hash.toBase58();
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        int digest = builder.createString((CharSequence)new String(Hex.encode((byte[])messageDigest.digest(binaryData))));
        int hash = builder.createString((CharSequence)multiHashString);
        int keywordsRes = builder.createString((CharSequence)keywordsOrDefault);
        int metadataRes = builder.createString((CharSequence)metadataOrDefault);
        int nameint = builder.createString((CharSequence)nameOrDefault);
        int type = builder.createString((CharSequence)contentTypeOrDetected);
        ResourceHashMessage.startResourceHashMessage(builder);
        ResourceHashMessage.addDigest(builder, digest);
        ResourceHashMessage.addHash(builder, hash);
        ResourceHashMessage.addKeywords(builder, keywordsRes);
        ResourceHashMessage.addMetaData(builder, metadataRes);
        ResourceHashMessage.addName(builder, nameint);
        ResourceHashMessage.addTimestamp(builder, System.currentTimeMillis());
        ResourceHashMessage.addType(builder, type);
        builder.finish(ResourceHashMessage.endResourceHashMessage(builder));
        return Base64.encodeBase64((byte[])builder.sizedByteArray());
    }

    @Override
    public byte[] uploadText(byte[] textInBytes, String name, String contentType, String encoding, String keywords, String metadata) throws IOException, NoSuchAlgorithmException {
        String nameOrDefault = StringUtils.isEmpty(name) ? String.valueOf(Math.abs(System.currentTimeMillis())) : name;
        String contentTypeOrDefault = StringUtils.isEmpty(contentType) ? "text/plain" : contentType;
        String encodingOrDefault = StringUtils.isEmpty(encoding) ? "UTF-8" : encoding;
        String keywordsOrDefault = keywords == null ? "" : keywords;
        String metadataOrDefault = metadata == null ? "" : metadata;
        PublishResult spfsBlockResult = this.exposeAndPinBinary(nameOrDefault, textInBytes);
        String multiHashString = spfsBlockResult.getMerkleNode().get((int)0).hash.toBase58();
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        int digest = builder.createString((CharSequence)new String(Hex.encode((byte[])messageDigest.digest(textInBytes))));
        int hash = builder.createString((CharSequence)multiHashString);
        int keywordsRes = builder.createString((CharSequence)keywordsOrDefault);
        int metadataRes = builder.createString((CharSequence)metadataOrDefault);
        int nameint = builder.createString((CharSequence)nameOrDefault);
        int type = builder.createString((CharSequence)contentTypeOrDefault);
        ResourceHashMessage.startResourceHashMessage(builder);
        ResourceHashMessage.addDigest(builder, digest);
        ResourceHashMessage.addHash(builder, hash);
        ResourceHashMessage.addKeywords(builder, keywordsRes);
        ResourceHashMessage.addMetaData(builder, metadataRes);
        ResourceHashMessage.addName(builder, nameint);
        ResourceHashMessage.addTimestamp(builder, System.currentTimeMillis());
        ResourceHashMessage.addType(builder, type);
        builder.finish(ResourceHashMessage.endResourceHashMessage(builder));
        return Base64.encodeBase64((byte[])builder.sizedByteArray());
    }

    @Override
    public byte[] uploadPath(String path, String name, String keywords, String metadata) throws NoSuchAlgorithmException {
        String nameOrDefault = StringUtils.isEmpty(name) ? String.valueOf(Math.abs(System.currentTimeMillis())) : name;
        String keywordsOrDefault = keywords == null ? "" : keywords;
        String metadataOrDefault = metadata == null ? "" : metadata;
        String contentType = "Directory";
        PublishResult spfsBlockResult = this.exposeAndPinPath(path);
        String multiHashString = "";
        Iterator<MerkleNode> merkleNodeIter = spfsBlockResult.getMerkleNode().iterator();
        spfsBlockResult.getMerkleNode().stream().forEach(n -> Logger.error((Object)n));
        while (merkleNodeIter.hasNext()) {
            MerkleNode merkleNode = merkleNodeIter.next();
            String namePath = "/" + (String)merkleNode.name.get();
            if (!namePath.equals(path)) continue;
            multiHashString = merkleNode.hash.toBase58();
            break;
        }
        if (multiHashString == null || multiHashString.equals("")) {
            multiHashString = spfsBlockResult.getMerkleNode().get((int)(spfsBlockResult.getMerkleNode().size() - 1)).hash.toBase58();
        }
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        int digest = builder.createString((CharSequence)new String(Hex.encode((byte[])messageDigest.digest(path.getBytes()))));
        int hash = builder.createString((CharSequence)multiHashString);
        int keywordsRes = builder.createString((CharSequence)keywordsOrDefault);
        int metadataRes = builder.createString((CharSequence)metadataOrDefault);
        int nameint = builder.createString((CharSequence)nameOrDefault);
        int type = builder.createString((CharSequence)"Directory");
        ResourceHashMessage.startResourceHashMessage(builder);
        ResourceHashMessage.addDigest(builder, digest);
        ResourceHashMessage.addHash(builder, hash);
        ResourceHashMessage.addKeywords(builder, keywordsRes);
        ResourceHashMessage.addMetaData(builder, metadataRes);
        ResourceHashMessage.addName(builder, nameint);
        ResourceHashMessage.addTimestamp(builder, System.currentTimeMillis());
        ResourceHashMessage.addType(builder, type);
        builder.finish(ResourceHashMessage.endResourceHashMessage(builder));
        return Base64.encodeBase64((byte[])builder.sizedByteArray());
    }

    private PublishResult exposeAndPinBinary(String name, byte[] binary) throws IOException {
        PublishResult result = new PublishResult();
        NamedStreamable.ByteArrayWrapper byteArrayWrapper = new NamedStreamable.ByteArrayWrapper(name, binary);
        List node = this.proximaxIfpsConnection.add((NamedStreamable)byteArrayWrapper);
        List pinned = this.proximaxIfpsConnection.pin.add(((MerkleNode)node.get((int)0)).hash);
        result.setMerkleNode(node);
        result.setMultiHash(pinned);
        return result;
    }

    public PublishResult exposeAndPinPath(String path) {
        PublishResult result = new PublishResult();
        try {
            ArrayList<NamedStreamable.DirWrapper> streamables = new ArrayList<NamedStreamable.DirWrapper>();
            NamedStreamable.FileWrapper fileWrapper = new NamedStreamable.FileWrapper(new File(path));
            streamables.add(new NamedStreamable.DirWrapper(new File(path).getAbsolutePath(), fileWrapper.getChildren()));
            List merkleNode = this.proximaxIfpsConnection.add(streamables, true, false);
            result.setMerkleNode(merkleNode);
        }
        catch (Exception e) {
            Logger.error((String)("Error on decoding NEM Transaction Message." + e.getMessage()));
        }
        return result;
    }

    private void recursePathToBeAdded(List<NamedStreamable> streamables, String path) {
        File[] listOfFiles;
        File folder = new File(path);
        for (File file : listOfFiles = folder.listFiles()) {
            if (file.isDirectory()) {
                NamedStreamable.FileWrapper fileWrapper = new NamedStreamable.FileWrapper(file);
                streamables.add((NamedStreamable)new NamedStreamable.DirWrapper(file.getAbsolutePath(), fileWrapper.getChildren()));
                this.recursePathToBeAdded(streamables, file.getAbsolutePath());
                continue;
            }
            streamables.add((NamedStreamable)new NamedStreamable.FileWrapper(file));
        }
    }

    private PublishResult exposeBinary(String name, byte[] binary) throws IOException {
        PublishResult result = new PublishResult();
        NamedStreamable.ByteArrayWrapper byteArrayWrapper = new NamedStreamable.ByteArrayWrapper(name, binary);
        List node = this.proximaxIfpsConnection.add((NamedStreamable)byteArrayWrapper);
        result.setMerkleNode(node);
        return result;
    }

    private PublishResult getBinaryHashOnly(String name, byte[] binary) throws IOException {
        PublishResult result = null;
        result = new PublishResult();
        NamedStreamable.ByteArrayWrapper byteArrayWrapper = new NamedStreamable.ByteArrayWrapper(name, binary);
        List node = this.proximaxIfpsConnection.add((NamedStreamable)byteArrayWrapper, false, true);
        result.setMerkleNode(node);
        return result;
    }

    private void grabDirs(String path, List<MerkleNode> node) throws IOException {
        File[] directories;
        for (File f : directories = new File(path).listFiles(File::isDirectory)) {
            NamedStreamable.FileWrapper fileWrapper = new NamedStreamable.FileWrapper(f);
            NamedStreamable.DirWrapper dirWrapper = new NamedStreamable.DirWrapper(f.getName().toString(), fileWrapper.getChildren());
            node.addAll(this.proximaxIfpsConnection.add((NamedStreamable)dirWrapper, true, false));
            this.grabDirs(f.getAbsolutePath(), node);
        }
    }
}

