/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.remote;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.proximax.ApiCallback;
import io.proximax.ApiClient;
import io.proximax.ApiResponse;
import io.proximax.Pair;
import io.proximax.ProgressRequestBody;
import io.proximax.ProgressResponseBody;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.AccountMetaDataPair;
import io.proximax.xpx.service.intf.AccountApi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RemoteAccountApi
implements AccountApi {
    private final ApiClient apiClient;

    public RemoteAccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public Call getAllIncomingNemAddressTransactionsUsingGETCall(String publicKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/get/incoming/transactions/{publicKey}".replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllIncomingNemAddressTransactionsUsingGETValidateBeforeCall(String publicKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAllIncomingNemAddressTransactionsUsingGET(Async)");
        }
        Call call = this.getAllIncomingNemAddressTransactionsUsingGETCall(publicKey, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public String getAllIncomingNemAddressTransactionsUsingGET(String publicKey) throws ApiException {
        ApiResponse<String> resp = this.getAllIncomingNemAddressTransactionsUsingGETWithHttpInfo(publicKey);
        return resp.getData();
    }

    public ApiResponse<String> getAllIncomingNemAddressTransactionsUsingGETWithHttpInfo(String publicKey) throws ApiException {
        Call call = this.getAllIncomingNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllIncomingNemAddressTransactionsUsingGETAsync(String publicKey, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllIncomingNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllNemAddressTransactionsUsingGETCall(String publicKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/get/transactions/{publicKey}".replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllNemAddressTransactionsUsingGETValidateBeforeCall(String publicKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAllNemAddressTransactionsUsingGET(Async)");
        }
        Call call = this.getAllNemAddressTransactionsUsingGETCall(publicKey, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public String getAllNemAddressTransactionsUsingGET(String publicKey) throws ApiException {
        ApiResponse<String> resp = this.getAllNemAddressTransactionsUsingGETWithHttpInfo(publicKey);
        return resp.getData();
    }

    public ApiResponse<String> getAllNemAddressTransactionsUsingGETWithHttpInfo(String publicKey) throws ApiException {
        Call call = this.getAllNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllNemAddressTransactionsUsingGETAsync(String publicKey, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllNemAddressTransactionsWithPageSizeUsingGETCall(String publicKey, String pageSize, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/get/transactions/{publicKey}/{pageSize}".replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString())).replaceAll("\\{pageSize\\}", this.apiClient.escapeString(pageSize.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllNemAddressTransactionsWithPageSizeUsingGETValidateBeforeCall(String publicKey, String pageSize, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAllNemAddressTransactionsWithPageSizeUsingGET(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling getAllNemAddressTransactionsWithPageSizeUsingGET(Async)");
        }
        Call call = this.getAllNemAddressTransactionsWithPageSizeUsingGETCall(publicKey, pageSize, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public String getAllNemAddressTransactionsWithPageSizeUsingGET(String publicKey, String pageSize) throws ApiException {
        ApiResponse<String> resp = this.getAllNemAddressTransactionsWithPageSizeUsingGETWithHttpInfo(publicKey, pageSize);
        return resp.getData();
    }

    public ApiResponse<String> getAllNemAddressTransactionsWithPageSizeUsingGETWithHttpInfo(String publicKey, String pageSize) throws ApiException {
        Call call = this.getAllNemAddressTransactionsWithPageSizeUsingGETValidateBeforeCall(publicKey, pageSize, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllNemAddressTransactionsWithPageSizeUsingGETAsync(String publicKey, String pageSize, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllNemAddressTransactionsWithPageSizeUsingGETValidateBeforeCall(publicKey, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllOutgoingNemAddressTransactionsUsingGETCall(String publicKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/get/outgoing/transactions/{publicKey}".replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllOutgoingNemAddressTransactionsUsingGETValidateBeforeCall(String publicKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAllOutgoingNemAddressTransactionsUsingGET(Async)");
        }
        Call call = this.getAllOutgoingNemAddressTransactionsUsingGETCall(publicKey, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public String getAllOutgoingNemAddressTransactionsUsingGET(String publicKey) throws ApiException {
        ApiResponse<String> resp = this.getAllOutgoingNemAddressTransactionsUsingGETWithHttpInfo(publicKey);
        return resp.getData();
    }

    public ApiResponse<String> getAllOutgoingNemAddressTransactionsUsingGETWithHttpInfo(String publicKey) throws ApiException {
        Call call = this.getAllOutgoingNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllOutgoingNemAddressTransactionsUsingGETAsync(String publicKey, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllOutgoingNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllUnconfirmedNemAddressTransactionsUsingGETCall(String publicKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/get/unconfirmed/transactions/{publicKey}".replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllUnconfirmedNemAddressTransactionsUsingGETValidateBeforeCall(String publicKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getAllUnconfirmedNemAddressTransactionsUsingGET(Async)");
        }
        Call call = this.getAllUnconfirmedNemAddressTransactionsUsingGETCall(publicKey, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public String getAllUnconfirmedNemAddressTransactionsUsingGET(String publicKey) throws ApiException {
        ApiResponse<String> resp = this.getAllUnconfirmedNemAddressTransactionsUsingGETWithHttpInfo(publicKey);
        return resp.getData();
    }

    public ApiResponse<String> getAllUnconfirmedNemAddressTransactionsUsingGETWithHttpInfo(String publicKey) throws ApiException {
        Call call = this.getAllUnconfirmedNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllUnconfirmedNemAddressTransactionsUsingGETAsync(String publicKey, final ApiCallback<String> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllUnconfirmedNemAddressTransactionsUsingGETValidateBeforeCall(publicKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getNemAddressDetailsUsingGETCall(String publicKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/account/get/info/{publicKey}".replaceAll("\\{publicKey\\}", this.apiClient.escapeString(publicKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNemAddressDetailsUsingGETValidateBeforeCall(String publicKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (publicKey == null) {
            throw new ApiException("Missing the required parameter 'publicKey' when calling getNemAddressDetailsUsingGET(Async)");
        }
        Call call = this.getNemAddressDetailsUsingGETCall(publicKey, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public AccountMetaDataPair getNemAddressDetailsUsingGET(String publicKey) throws ApiException {
        ApiResponse<AccountMetaDataPair> resp = this.getNemAddressDetailsUsingGETWithHttpInfo(publicKey);
        return resp.getData();
    }

    public ApiResponse<AccountMetaDataPair> getNemAddressDetailsUsingGETWithHttpInfo(String publicKey) throws ApiException {
        Call call = this.getNemAddressDetailsUsingGETValidateBeforeCall(publicKey, null, null);
        Type localVarReturnType = new TypeToken<AccountMetaDataPair>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNemAddressDetailsUsingGETAsync(String publicKey, final ApiCallback<AccountMetaDataPair> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNemAddressDetailsUsingGETValidateBeforeCall(publicKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AccountMetaDataPair>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

