/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.remote;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.proximax.ApiCallback;
import io.proximax.ApiClient;
import io.proximax.ApiResponse;
import io.proximax.Pair;
import io.proximax.ProgressRequestBody;
import io.proximax.ProgressResponseBody;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.service.intf.DownloadApi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RemoteDownloadApi
implements DownloadApi {
    private final ApiClient apiClient;

    public RemoteDownloadApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public Call downloadBinaryUsingGETCall(String nemHash, String transferMode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/download/binary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (nemHash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "nemHash", nemHash));
        }
        if (transferMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "transferMode", transferMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadBinaryUsingGETValidateBeforeCall(String nemHash, String transferMode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling downloadBinaryUsingGET(Async)");
        }
        if (transferMode == null) {
            throw new ApiException("Missing the required parameter 'transferMode' when calling downloadBinaryUsingGET(Async)");
        }
        Call call = this.downloadBinaryUsingGETCall(nemHash, transferMode, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public byte[] downloadBinaryUsingGET(String nemHash, String transferMode) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadBinaryUsingGETWithHttpInfo(nemHash, transferMode);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadBinaryUsingGETWithHttpInfo(String nemHash, String transferMode) throws ApiException {
        Call call = this.downloadBinaryUsingGETValidateBeforeCall(nemHash, transferMode, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadBinaryUsingGETAsync(String nemHash, String transferMode, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadBinaryUsingGETValidateBeforeCall(nemHash, transferMode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call downloadFileUsingGETCall(String nemHash, String transferMode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/download/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (nemHash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "nemHash", nemHash));
        }
        if (transferMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "transferMode", transferMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadFileUsingGETValidateBeforeCall(String nemHash, String transferMode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling downloadFileUsingGET(Async)");
        }
        if (transferMode == null) {
            throw new ApiException("Missing the required parameter 'transferMode' when calling downloadFileUsingGET(Async)");
        }
        Call call = this.downloadFileUsingGETCall(nemHash, transferMode, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public byte[] downloadFileUsingGET(String nemHash, String transferMode) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadFileUsingGETWithHttpInfo(nemHash, transferMode);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadFileUsingGETWithHttpInfo(String nemHash, String transferMode) throws ApiException {
        Call call = this.downloadFileUsingGETValidateBeforeCall(nemHash, transferMode, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadFileUsingGETAsync(String nemHash, String transferMode, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadFileUsingGETValidateBeforeCall(nemHash, transferMode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call downloadSecureBinaryUsingGETCall(String xPvkey, String nemHash, String transferType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/download/secure/binary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (nemHash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "nemHash", nemHash));
        }
        if (transferType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "transferType", transferType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xPvkey != null) {
            localVarHeaderParams.put("x-pvkey", this.apiClient.parameterToString(xPvkey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadSecureBinaryUsingGETValidateBeforeCall(String xPvkey, String nemHash, String transferType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xPvkey == null) {
            throw new ApiException("Missing the required parameter 'xPvkey' when calling downloadSecureBinaryUsingGET(Async)");
        }
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling downloadSecureBinaryUsingGET(Async)");
        }
        if (transferType == null) {
            throw new ApiException("Missing the required parameter 'transferType' when calling downloadSecureBinaryUsingGET(Async)");
        }
        Call call = this.downloadSecureBinaryUsingGETCall(xPvkey, nemHash, transferType, progressListener, progressRequestListener);
        return call;
    }

    public byte[] downloadSecureBinaryUsingGET(String xPvkey, String nemHash, String transferType) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadSecureBinaryUsingGETWithHttpInfo(xPvkey, nemHash, transferType);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadSecureBinaryUsingGETWithHttpInfo(String xPvkey, String nemHash, String transferType) throws ApiException {
        Call call = this.downloadSecureBinaryUsingGETValidateBeforeCall(xPvkey, nemHash, transferType, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadSecureBinaryUsingGETAsync(String xPvkey, String nemHash, String transferType, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadSecureBinaryUsingGETValidateBeforeCall(xPvkey, nemHash, transferType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call downloadSecureFileUsingGETCall(String xPvkey, String nemHash, String transferType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/download/secure/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (nemHash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "nemHash", nemHash));
        }
        if (transferType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "transferType", transferType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xPvkey != null) {
            localVarHeaderParams.put("x-pvkey", this.apiClient.parameterToString(xPvkey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadSecureFileUsingGETValidateBeforeCall(String xPvkey, String nemHash, String transferType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xPvkey == null) {
            throw new ApiException("Missing the required parameter 'xPvkey' when calling downloadSecureFileUsingGET(Async)");
        }
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling downloadSecureFileUsingGET(Async)");
        }
        if (transferType == null) {
            throw new ApiException("Missing the required parameter 'transferType' when calling downloadSecureFileUsingGET(Async)");
        }
        Call call = this.downloadSecureFileUsingGETCall(xPvkey, nemHash, transferType, progressListener, progressRequestListener);
        return call;
    }

    public byte[] downloadSecureFileUsingGET(String xPvkey, String nemHash, String transferType) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadSecureFileUsingGETWithHttpInfo(xPvkey, nemHash, transferType);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadSecureFileUsingGETWithHttpInfo(String xPvkey, String nemHash, String transferType) throws ApiException {
        Call call = this.downloadSecureFileUsingGETValidateBeforeCall(xPvkey, nemHash, transferType, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadSecureFileUsingGETAsync(String xPvkey, String nemHash, String transferType, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadSecureFileUsingGETValidateBeforeCall(xPvkey, nemHash, transferType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call downloadTextUsingGETCall(String nemHash, String transferMode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/download/text";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (nemHash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "nemHash", nemHash));
        }
        if (transferMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "transferMode", transferMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadTextUsingGETValidateBeforeCall(String nemHash, String transferMode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (nemHash == null) {
            throw new ApiException("Missing the required parameter 'nemHash' when calling downloadTextUsingGET(Async)");
        }
        if (transferMode == null) {
            throw new ApiException("Missing the required parameter 'transferMode' when calling downloadTextUsingGET(Async)");
        }
        Call call = this.downloadTextUsingGETCall(nemHash, transferMode, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public byte[] downloadTextUsingGET(String nemHash, String transferMode) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadTextUsingGETWithHttpInfo(nemHash, transferMode);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadTextUsingGETWithHttpInfo(String nemHash, String transferMode) throws ApiException {
        Call call = this.downloadTextUsingGETValidateBeforeCall(nemHash, transferMode, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadTextUsingGETAsync(String nemHash, String transferMode, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadTextUsingGETValidateBeforeCall(nemHash, transferMode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call downloadUsingDataHashUsingGETCall(String dataHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/download/direct/datahash";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (dataHash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "dataHash", dataHash));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call downloadUsingDataHashUsingGETValidateBeforeCall(String dataHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataHash == null) {
            throw new ApiException("Missing the required parameter 'dataHash' when calling downloadUsingDataHashUsingGET(Async)");
        }
        Call call = this.downloadUsingDataHashUsingGETCall(dataHash, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public byte[] downloadUsingDataHashUsingGET(String dataHash) throws ApiException {
        ApiResponse<byte[]> resp = this.downloadUsingDataHashUsingGETWithHttpInfo(dataHash);
        return resp.getData();
    }

    public ApiResponse<byte[]> downloadUsingDataHashUsingGETWithHttpInfo(String dataHash) throws ApiException {
        Call call = this.downloadUsingDataHashUsingGETValidateBeforeCall(dataHash, null, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call downloadUsingDataHashUsingGETAsync(String dataHash, final ApiCallback<byte[]> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.downloadUsingDataHashUsingGETValidateBeforeCall(dataHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

