/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.remote;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.proximax.ApiCallback;
import io.proximax.ApiClient;
import io.proximax.ApiResponse;
import io.proximax.Pair;
import io.proximax.ProgressRequestBody;
import io.proximax.ProgressResponseBody;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.model.ResourceHashMessageJsonEntity;
import io.proximax.xpx.service.NemTransactionApi;
import io.proximax.xpx.service.common.PrivateSearchApi;
import io.proximax.xpx.service.intf.SearchApi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class RemoteSearchApi
extends PrivateSearchApi
implements SearchApi {
    private final ApiClient apiClient;

    public RemoteSearchApi(ApiClient apiClient, NemTransactionApi nemTransactionApi) {
        super(nemTransactionApi);
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public Call searchTransactionWithKeywordUsingGETCall(String xPubkey, String keywords, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/search/by/keywords/{keywords}".replaceAll("\\{keywords\\}", this.apiClient.escapeString(keywords.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xPubkey != null) {
            localVarHeaderParams.put("x-pubkey", this.apiClient.parameterToString(xPubkey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchTransactionWithKeywordUsingGETValidateBeforeCall(String xPubkey, String keywords, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xPubkey == null) {
            throw new ApiException("Missing the required parameter 'xPubkey' when calling searchTransactionWithKeywordUsingGET(Async)");
        }
        if (keywords == null) {
            throw new ApiException("Missing the required parameter 'keywords' when calling searchTransactionWithKeywordUsingGET(Async)");
        }
        Call call = this.searchTransactionWithKeywordUsingGETCall(xPubkey, keywords, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithKeywordUsingGET(String xPubkey, String keywords) throws ApiException {
        ApiResponse<List<ResourceHashMessageJsonEntity>> resp = this.searchTransactionWithKeywordUsingGETWithHttpInfo(xPubkey, keywords);
        return resp.getData();
    }

    public ApiResponse<List<ResourceHashMessageJsonEntity>> searchTransactionWithKeywordUsingGETWithHttpInfo(String xPubkey, String keywords) throws ApiException {
        Call call = this.searchTransactionWithKeywordUsingGETValidateBeforeCall(xPubkey, keywords, null, null);
        Type localVarReturnType = new TypeToken<List<ResourceHashMessageJsonEntity>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchTransactionWithKeywordUsingGETAsync(String xPubkey, String keywords, final ApiCallback<List<ResourceHashMessageJsonEntity>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchTransactionWithKeywordUsingGETValidateBeforeCall(xPubkey, keywords, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ResourceHashMessageJsonEntity>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchTransactionWithMetadataUsingGETCall(String xPubkey, String key, String value, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/search/by/metadata";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (key != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "key", key));
        }
        if (value != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "value", value));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xPubkey != null) {
            localVarHeaderParams.put("x-pubkey", this.apiClient.parameterToString(xPubkey));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchTransactionWithMetadataUsingGETValidateBeforeCall(String xPubkey, String key, String value, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xPubkey == null) {
            throw new ApiException("Missing the required parameter 'xPubkey' when calling searchTransactionWithMetadataUsingGET(Async)");
        }
        Call call = this.searchTransactionWithMetadataUsingGETCall(xPubkey, key, value, progressListener, progressRequestListener);
        return call;
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithMetadataUsingGET(String xPubkey, String key, String value) throws ApiException {
        ApiResponse<List<ResourceHashMessageJsonEntity>> resp = this.searchTransactionWithMetadataUsingGETWithHttpInfo(xPubkey, key, value);
        return resp.getData();
    }

    public ApiResponse<List<ResourceHashMessageJsonEntity>> searchTransactionWithMetadataUsingGETWithHttpInfo(String xPubkey, String key, String value) throws ApiException {
        Call call = this.searchTransactionWithMetadataUsingGETValidateBeforeCall(xPubkey, key, value, null, null);
        Type localVarReturnType = new TypeToken<List<ResourceHashMessageJsonEntity>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchTransactionWithMetadataUsingGETAsync(String xPubkey, String key, String value, final ApiCallback<List<ResourceHashMessageJsonEntity>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchTransactionWithMetadataUsingGETValidateBeforeCall(xPubkey, key, value, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ResourceHashMessageJsonEntity>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithKeywordUsingGET(String xPvKey, String xPubkey, String keywords) throws ApiException, InterruptedException, ExecutionException {
        return super.searchTransactionWithKeyword(xPvKey, xPubkey, keywords);
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithMetadataKeyValuePair(String xPvKey, String xPubkey, String key, String value) throws ApiException, InterruptedException, ExecutionException {
        return super.searchTransactionWithMetadataKeyValuePair(xPvKey, xPubkey, key, value);
    }

    @Override
    public List<ResourceHashMessageJsonEntity> searchTransactionWithNameUsingGET(String xPvKey, String xPubkey, String name) throws ApiException, InterruptedException, ExecutionException {
        return super.searchTransactionWithName(xPvKey, xPubkey, name);
    }
}

