/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.service.remote;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import io.proximax.ApiClient;
import io.proximax.ApiResponse;
import io.proximax.Pair;
import io.proximax.xpx.exceptions.ApiException;
import io.proximax.xpx.exceptions.PathUploadNotSupportedException;
import io.proximax.xpx.model.UploadBytesBinaryRequestParameter;
import io.proximax.xpx.model.UploadTextRequestParameter;
import io.proximax.xpx.service.intf.UploadApi;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public class RemoteUploadApi
implements UploadApi {
    private final ApiClient apiClient;

    public RemoteUploadApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    @Override
    public String deletePinnedContent(String multihash) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/upload/cleanup";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (multihash != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "multihash", multihash));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        Call call = this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        ApiResponse resp = this.apiClient.execute(call, localVarReturnType);
        return (String)resp.getData();
    }

    @Override
    public byte[] uploadBytesBinary(byte[] binaryData, String name, String contentType, String keywords, String metadata) throws ApiException {
        UploadBytesBinaryRequestParameter localVarPostBody = new UploadBytesBinaryRequestParameter().contentType(contentType).keywords(keywords).metadata(metadata).name(name).data(binaryData);
        String localVarPath = "/upload/bytes/binary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        Call call = this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, Collections.emptyMap(), localVarAuthNames, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        ApiResponse response = this.apiClient.execute(call, localVarReturnType);
        return (byte[])response.getData();
    }

    @Override
    public byte[] uploadText(byte[] textInBytes, String name, String contentType, String encoding, String keywords, String metadata) throws ApiException {
        UploadTextRequestParameter localVarPostBody = new UploadTextRequestParameter().contentType(contentType).encoding(encoding).keywords(keywords).metadata(metadata).name(name).text(Base64.encodeBase64String((byte[])textInBytes));
        String localVarPath = "/upload/text";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        Call call = this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, Collections.emptyMap(), localVarAuthNames, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        ApiResponse response = this.apiClient.execute(call, localVarReturnType);
        return (byte[])response.getData();
    }

    @Override
    public byte[] uploadPath(String path, String name, String keywords, String metadata) {
        throw new PathUploadNotSupportedException("Path upload is not supported for remote upload");
    }
}

