/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.strategy.privacy;

import io.proximax.xpx.exceptions.DecodeNemMessageFailureException;
import io.proximax.xpx.model.NemMessageType;
import io.proximax.xpx.strategy.privacy.PrivacyStrategy;
import io.proximax.xpx.utils.ParameterValidationUtils;
import org.nem.core.crypto.KeyPair;
import org.nem.core.crypto.PrivateKey;
import org.nem.core.crypto.PublicKey;
import org.nem.core.messages.SecureMessage;
import org.nem.core.model.Account;
import org.nem.core.model.Message;
import org.nem.core.model.TransferTransaction;

public abstract class AbstractSecureMessagePrivacyStrategy
extends PrivacyStrategy {
    public final KeyPair keyPairOfPrivateKey;
    public final KeyPair keyPairOfPublicKey;
    public final Account accountWithPrivateKey;
    public final Account accountWithPublicKey;

    public AbstractSecureMessagePrivacyStrategy(String privateKey, String publicKey) {
        ParameterValidationUtils.checkParameter(privateKey != null, "private key is required");
        ParameterValidationUtils.checkParameter(publicKey != null, "public key is required");
        this.keyPairOfPrivateKey = new KeyPair(PrivateKey.fromHexString((String)privateKey));
        this.keyPairOfPublicKey = new KeyPair(PublicKey.fromHexString((String)publicKey));
        this.accountWithPrivateKey = new Account(this.keyPairOfPrivateKey);
        this.accountWithPublicKey = new Account(this.keyPairOfPublicKey);
    }

    @Override
    public NemMessageType getNemMessageType() {
        return NemMessageType.SECURE;
    }

    @Override
    public Message encodeToMessage(byte[] data) {
        return SecureMessage.fromDecodedPayload((Account)this.accountWithPrivateKey, (Account)this.accountWithPublicKey, (byte[])data);
    }

    @Override
    public byte[] decodeTransaction(TransferTransaction transaction) {
        if (transaction.getMessage().getType() == 1) {
            return transaction.getMessage().getDecodedPayload();
        }
        if (transaction.getSigner().getAddress().getEncoded().equals(this.accountWithPrivateKey.getAddress().getEncoded())) {
            return SecureMessage.fromEncodedPayload((Account)this.accountWithPrivateKey, (Account)this.accountWithPublicKey, (byte[])transaction.getMessage().getEncodedPayload()).getDecodedPayload();
        }
        if (transaction.getRecipient().getAddress().getEncoded().equals(this.accountWithPrivateKey.getAddress().getEncoded())) {
            return SecureMessage.fromEncodedPayload((Account)this.accountWithPublicKey, (Account)this.accountWithPrivateKey, (byte[])transaction.getMessage().getEncodedPayload()).getDecodedPayload();
        }
        throw new DecodeNemMessageFailureException("Private key cannot be used to decode the Nem secured message.");
    }
}

