/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.strategy.privacy;

import io.proximax.xpx.adapters.cipher.BinaryPBKDF2CipherEncryption;
import io.proximax.xpx.strategy.privacy.PlainPrivacyStrategy;
import io.proximax.xpx.strategy.privacy.PrivacyStrategy;
import io.proximax.xpx.strategy.privacy.SecuredWithNemKeysPrivacyStrategy;
import io.proximax.xpx.strategy.privacy.SecuredWithPasswordPrivacyStrategy;
import io.proximax.xpx.strategy.privacy.SecuredWithShamirSecretSharingPrivacyStrategy;
import java.util.Map;

public class PrivacyStrategyFactory {
    public static PrivacyStrategy plainPrivacyStrategy;

    private PrivacyStrategyFactory() {
    }

    public static PrivacyStrategy plainPrivacy() {
        if (plainPrivacyStrategy == null) {
            plainPrivacyStrategy = new PlainPrivacyStrategy();
        }
        return plainPrivacyStrategy;
    }

    public static PrivacyStrategy securedWithNemKeysPrivacyStrategy(String senderOrReceiverPrivateKey, String receiverOrSenderPublicKey) {
        return new SecuredWithNemKeysPrivacyStrategy(senderOrReceiverPrivateKey, receiverOrSenderPublicKey);
    }

    public static PrivacyStrategy securedWithPasswordPrivacyStrategy(String password) {
        return new SecuredWithPasswordPrivacyStrategy(new BinaryPBKDF2CipherEncryption(), password);
    }

    public static PrivacyStrategy securedWithShamirSecretSharingPrivacyStrategy(int secretTotalPartCount, int secretMinimumPartCountToBuild, Map<Integer, byte[]> secretParts) {
        return new SecuredWithShamirSecretSharingPrivacyStrategy(new BinaryPBKDF2CipherEncryption(), secretTotalPartCount, secretMinimumPartCountToBuild, secretParts);
    }
}

