/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.strategy.privacy;

import io.proximax.xpx.exceptions.DecryptionFailureException;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import io.proximax.xpx.strategy.privacy.AbstractSecureMessagePrivacyStrategy;
import org.nem.core.crypto.CryptoEngines;
import org.nem.core.model.TransferTransaction;

public final class SecuredWithNemKeysPrivacyStrategy
extends AbstractSecureMessagePrivacyStrategy {
    public SecuredWithNemKeysPrivacyStrategy(String privateKey, String publicKey) {
        super(privateKey, publicKey);
    }

    @Override
    public byte[] encrypt(byte[] data) {
        return CryptoEngines.defaultEngine().createBlockCipher(this.keyPairOfPrivateKey, this.keyPairOfPublicKey).encrypt(data);
    }

    @Override
    public byte[] decrypt(byte[] data, TransferTransaction transaction, ResourceHashMessage hashMessage) {
        if (transaction != null && !transaction.getSigner().getAddress().getEncoded().equals(this.accountWithPrivateKey.getAddress().getEncoded()) && !transaction.getRecipient().getAddress().getEncoded().equals(this.accountWithPrivateKey.getAddress().getEncoded())) {
            throw new DecryptionFailureException("Decrypt of data is unsuccessful");
        }
        return CryptoEngines.defaultEngine().createBlockCipher(this.keyPairOfPublicKey, this.keyPairOfPrivateKey).decrypt(data);
    }
}

