/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.strategy.privacy;

import io.proximax.xpx.adapters.cipher.BinaryPBKDF2CipherEncryption;
import io.proximax.xpx.exceptions.EncryptionFailureException;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import io.proximax.xpx.strategy.privacy.AbstractPlainMessagePrivacyStrategy;
import io.proximax.xpx.utils.ParameterValidationUtils;
import org.nem.core.model.TransferTransaction;

public final class SecuredWithPasswordPrivacyStrategy
extends AbstractPlainMessagePrivacyStrategy {
    private static final int MINIMUM_PASSWORD_LENGTH = 50;
    private final BinaryPBKDF2CipherEncryption encryptor;
    private final char[] password;

    public SecuredWithPasswordPrivacyStrategy(BinaryPBKDF2CipherEncryption encryptor, String password) {
        ParameterValidationUtils.checkParameter(password != null, "password is required");
        ParameterValidationUtils.checkParameter(password.length() >= 50, "minimum length for password is 50");
        this.encryptor = encryptor;
        this.password = password.toCharArray();
    }

    @Override
    public byte[] encrypt(byte[] data) {
        try {
            return this.encryptor.encrypt(data, this.password);
        }
        catch (Exception e) {
            throw new EncryptionFailureException("Exception encountered encrypting data", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data, TransferTransaction transaction, ResourceHashMessage hashMessage) {
        try {
            return this.encryptor.decrypt(data, this.password);
        }
        catch (Exception e) {
            throw new EncryptionFailureException("Exception encountered decrypting data", e);
        }
    }
}

