/*
 * Decompiled with CFR 0.152.
 */
package io.proximax.xpx.strategy.privacy;

import com.codahale.shamir.Scheme;
import io.proximax.xpx.adapters.cipher.BinaryPBKDF2CipherEncryption;
import io.proximax.xpx.exceptions.EncryptionFailureException;
import io.proximax.xpx.service.model.buffers.ResourceHashMessage;
import io.proximax.xpx.strategy.privacy.AbstractPlainMessagePrivacyStrategy;
import io.proximax.xpx.utils.ParameterValidationUtils;
import java.util.Map;
import org.nem.core.model.TransferTransaction;

public final class SecuredWithShamirSecretSharingPrivacyStrategy
extends AbstractPlainMessagePrivacyStrategy {
    private final char[] secret;
    private final BinaryPBKDF2CipherEncryption encryptor;

    public SecuredWithShamirSecretSharingPrivacyStrategy(BinaryPBKDF2CipherEncryption encryptor, int secretTotalPartCount, int secretMinimumPartCountToBuild, Map<Integer, byte[]> secretParts) {
        ParameterValidationUtils.checkParameter(secretTotalPartCount > 0, "secretTotalPartCount should be a positive number");
        ParameterValidationUtils.checkParameter(secretMinimumPartCountToBuild > 0 && secretMinimumPartCountToBuild <= secretTotalPartCount, "secretMinimumPartCountToBuild should be a positive number less than or equal to secretTotalPartCount");
        ParameterValidationUtils.checkParameter(secretParts != null, "secretParts is required");
        ParameterValidationUtils.checkParameter(secretParts.size() >= secretMinimumPartCountToBuild, "secretParts should meet minimum part count as defined by secretMinimumPartCountToBuild");
        this.secret = new String(Scheme.of((int)secretTotalPartCount, (int)secretMinimumPartCountToBuild).join(secretParts)).toCharArray();
        this.encryptor = encryptor;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        try {
            return this.encryptor.encrypt(data, this.secret);
        }
        catch (Exception e) {
            throw new EncryptionFailureException("Exception encountered encrypting data", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data, TransferTransaction transaction, ResourceHashMessage hashMessage) {
        try {
            return this.encryptor.decrypt(data, this.secret);
        }
        catch (Exception e) {
            throw new EncryptionFailureException("Exception encountered decrypting data", e);
        }
    }

    public static class SecretPart {
        public final int index;
        public final byte[] secretPart;

        public SecretPart(int index, byte[] secretPart) {
            this.index = index;
            this.secretPart = secretPart;
        }

        public static SecretPart secretPart(int index, byte[] secretPart) {
            return new SecretPart(index, secretPart);
        }
    }
}

