/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.AttachmentListResponse;
import io.qase.client.model.AttachmentResponse;
import io.qase.client.model.AttachmentUploadsResponse;
import io.qase.client.model.HashResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AttachmentsApi {
    private ApiClient localVarApiClient;

    public AttachmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttachmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteAttachmentCall(String hash, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/attachment/{hash}".replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAttachmentValidateBeforeCall(String hash, ApiCallback _callback) throws QaseException {
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling deleteAttachment(Async)");
        }
        Call localVarCall = this.deleteAttachmentCall(hash, _callback);
        return localVarCall;
    }

    public HashResponse deleteAttachment(String hash) throws QaseException {
        ApiResponse<HashResponse> localVarResp = this.deleteAttachmentWithHttpInfo(hash);
        return localVarResp.getData();
    }

    public ApiResponse<HashResponse> deleteAttachmentWithHttpInfo(String hash) throws QaseException {
        Call localVarCall = this.deleteAttachmentValidateBeforeCall(hash, null);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAttachmentAsync(String hash, ApiCallback<HashResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteAttachmentValidateBeforeCall(hash, _callback);
        Type localVarReturnType = new TypeToken<HashResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentCall(String hash, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/attachment/{hash}".replaceAll("\\{hash\\}", this.localVarApiClient.escapeString(hash));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentValidateBeforeCall(String hash, ApiCallback _callback) throws QaseException {
        if (hash == null) {
            throw new QaseException("Missing the required parameter 'hash' when calling getAttachment(Async)");
        }
        Call localVarCall = this.getAttachmentCall(hash, _callback);
        return localVarCall;
    }

    public AttachmentResponse getAttachment(String hash) throws QaseException {
        ApiResponse<AttachmentResponse> localVarResp = this.getAttachmentWithHttpInfo(hash);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentResponse> getAttachmentWithHttpInfo(String hash) throws QaseException {
        Call localVarCall = this.getAttachmentValidateBeforeCall(hash, null);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentAsync(String hash, ApiCallback<AttachmentResponse> _callback) throws QaseException {
        Call localVarCall = this.getAttachmentValidateBeforeCall(hash, _callback);
        Type localVarReturnType = new TypeToken<AttachmentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentsCall(Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/attachment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentsValidateBeforeCall(Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        Call localVarCall = this.getAttachmentsCall(limit, offset, _callback);
        return localVarCall;
    }

    public AttachmentListResponse getAttachments(Integer limit, Integer offset) throws QaseException {
        ApiResponse<AttachmentListResponse> localVarResp = this.getAttachmentsWithHttpInfo(limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentListResponse> getAttachmentsWithHttpInfo(Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(limit, offset, null);
        Type localVarReturnType = new TypeToken<AttachmentListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentsAsync(Integer limit, Integer offset, ApiCallback<AttachmentListResponse> _callback) throws QaseException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(limit, offset, _callback);
        Type localVarReturnType = new TypeToken<AttachmentListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call uploadAttachmentCall(String code, List<File> file, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/attachment/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadAttachmentValidateBeforeCall(String code, List<File> file, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling uploadAttachment(Async)");
        }
        Call localVarCall = this.uploadAttachmentCall(code, file, _callback);
        return localVarCall;
    }

    public AttachmentUploadsResponse uploadAttachment(String code, List<File> file) throws QaseException {
        ApiResponse<AttachmentUploadsResponse> localVarResp = this.uploadAttachmentWithHttpInfo(code, file);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentUploadsResponse> uploadAttachmentWithHttpInfo(String code, List<File> file) throws QaseException {
        Call localVarCall = this.uploadAttachmentValidateBeforeCall(code, file, null);
        Type localVarReturnType = new TypeToken<AttachmentUploadsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call uploadAttachmentAsync(String code, List<File> file, ApiCallback<AttachmentUploadsResponse> _callback) throws QaseException {
        Call localVarCall = this.uploadAttachmentValidateBeforeCall(code, file, _callback);
        Type localVarReturnType = new TypeToken<AttachmentUploadsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

