/*
 * Decompiled with CFR 0.152.
 */
package io.qase.client.api;

import com.google.gson.reflect.TypeToken;
import io.qase.api.exceptions.QaseException;
import io.qase.client.ApiCallback;
import io.qase.client.ApiClient;
import io.qase.client.ApiResponse;
import io.qase.client.Configuration;
import io.qase.client.Pair;
import io.qase.client.model.Filters7;
import io.qase.client.model.IdResponse;
import io.qase.client.model.SuiteCreate;
import io.qase.client.model.SuiteDelete;
import io.qase.client.model.SuiteListResponse;
import io.qase.client.model.SuiteResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SuitesApi {
    private ApiClient localVarApiClient;

    public SuitesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SuitesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createSuiteCall(String code, SuiteCreate suiteCreate, ApiCallback _callback) throws QaseException {
        SuiteCreate localVarPostBody = suiteCreate;
        String localVarPath = "/suite/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSuiteValidateBeforeCall(String code, SuiteCreate suiteCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling createSuite(Async)");
        }
        if (suiteCreate == null) {
            throw new QaseException("Missing the required parameter 'suiteCreate' when calling createSuite(Async)");
        }
        Call localVarCall = this.createSuiteCall(code, suiteCreate, _callback);
        return localVarCall;
    }

    public IdResponse createSuite(String code, SuiteCreate suiteCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.createSuiteWithHttpInfo(code, suiteCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> createSuiteWithHttpInfo(String code, SuiteCreate suiteCreate) throws QaseException {
        Call localVarCall = this.createSuiteValidateBeforeCall(code, suiteCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSuiteAsync(String code, SuiteCreate suiteCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.createSuiteValidateBeforeCall(code, suiteCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteSuiteCall(String code, Integer id, SuiteDelete suiteDelete, ApiCallback _callback) throws QaseException {
        SuiteDelete localVarPostBody = suiteDelete;
        String localVarPath = "/suite/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSuiteValidateBeforeCall(String code, Integer id, SuiteDelete suiteDelete, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling deleteSuite(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling deleteSuite(Async)");
        }
        Call localVarCall = this.deleteSuiteCall(code, id, suiteDelete, _callback);
        return localVarCall;
    }

    public IdResponse deleteSuite(String code, Integer id, SuiteDelete suiteDelete) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.deleteSuiteWithHttpInfo(code, id, suiteDelete);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> deleteSuiteWithHttpInfo(String code, Integer id, SuiteDelete suiteDelete) throws QaseException {
        Call localVarCall = this.deleteSuiteValidateBeforeCall(code, id, suiteDelete, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteSuiteAsync(String code, Integer id, SuiteDelete suiteDelete, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.deleteSuiteValidateBeforeCall(code, id, suiteDelete, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSuiteCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        Object localVarPostBody = null;
        String localVarPath = "/suite/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSuiteValidateBeforeCall(String code, Integer id, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSuite(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling getSuite(Async)");
        }
        Call localVarCall = this.getSuiteCall(code, id, _callback);
        return localVarCall;
    }

    public SuiteResponse getSuite(String code, Integer id) throws QaseException {
        ApiResponse<SuiteResponse> localVarResp = this.getSuiteWithHttpInfo(code, id);
        return localVarResp.getData();
    }

    public ApiResponse<SuiteResponse> getSuiteWithHttpInfo(String code, Integer id) throws QaseException {
        Call localVarCall = this.getSuiteValidateBeforeCall(code, id, null);
        Type localVarReturnType = new TypeToken<SuiteResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSuiteAsync(String code, Integer id, ApiCallback<SuiteResponse> _callback) throws QaseException {
        Call localVarCall = this.getSuiteValidateBeforeCall(code, id, _callback);
        Type localVarReturnType = new TypeToken<SuiteResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSuitesCall(String code, Filters7 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/suite/{code}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSuitesValidateBeforeCall(String code, Filters7 filters, Integer limit, Integer offset, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling getSuites(Async)");
        }
        Call localVarCall = this.getSuitesCall(code, filters, limit, offset, _callback);
        return localVarCall;
    }

    public SuiteListResponse getSuites(String code, Filters7 filters, Integer limit, Integer offset) throws QaseException {
        ApiResponse<SuiteListResponse> localVarResp = this.getSuitesWithHttpInfo(code, filters, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<SuiteListResponse> getSuitesWithHttpInfo(String code, Filters7 filters, Integer limit, Integer offset) throws QaseException {
        Call localVarCall = this.getSuitesValidateBeforeCall(code, filters, limit, offset, null);
        Type localVarReturnType = new TypeToken<SuiteListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSuitesAsync(String code, Filters7 filters, Integer limit, Integer offset, ApiCallback<SuiteListResponse> _callback) throws QaseException {
        Call localVarCall = this.getSuitesValidateBeforeCall(code, filters, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<SuiteListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSuiteCall(String code, Integer id, SuiteCreate suiteCreate, ApiCallback _callback) throws QaseException {
        SuiteCreate localVarPostBody = suiteCreate;
        String localVarPath = "/suite/{code}/{id}".replaceAll("\\{code\\}", this.localVarApiClient.escapeString(code)).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"TokenAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuiteValidateBeforeCall(String code, Integer id, SuiteCreate suiteCreate, ApiCallback _callback) throws QaseException {
        if (code == null) {
            throw new QaseException("Missing the required parameter 'code' when calling updateSuite(Async)");
        }
        if (id == null) {
            throw new QaseException("Missing the required parameter 'id' when calling updateSuite(Async)");
        }
        if (suiteCreate == null) {
            throw new QaseException("Missing the required parameter 'suiteCreate' when calling updateSuite(Async)");
        }
        Call localVarCall = this.updateSuiteCall(code, id, suiteCreate, _callback);
        return localVarCall;
    }

    public IdResponse updateSuite(String code, Integer id, SuiteCreate suiteCreate) throws QaseException {
        ApiResponse<IdResponse> localVarResp = this.updateSuiteWithHttpInfo(code, id, suiteCreate);
        return localVarResp.getData();
    }

    public ApiResponse<IdResponse> updateSuiteWithHttpInfo(String code, Integer id, SuiteCreate suiteCreate) throws QaseException {
        Call localVarCall = this.updateSuiteValidateBeforeCall(code, id, suiteCreate, null);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSuiteAsync(String code, Integer id, SuiteCreate suiteCreate, ApiCallback<IdResponse> _callback) throws QaseException {
        Call localVarCall = this.updateSuiteValidateBeforeCall(code, id, suiteCreate, _callback);
        Type localVarReturnType = new TypeToken<IdResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

