/*
 * Decompiled with CFR 0.152.
 */
package io.qase.cucumber5;

import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.qase.api.StepStorage;
import io.qase.api.services.QaseTestCaseListener;
import io.qase.api.utils.CucumberUtils;
import io.qase.api.utils.IntegrationUtils;
import io.qase.client.model.ResultCreate;
import io.qase.cucumber5.guice.module.Cucumber5Module;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class QaseEventListener
implements ConcurrentEventListener {
    private static final String REPORTER_NAME = "Cucumber 5-JVM";
    private final AtomicReference<Object> qaseTestCaseListener = new AtomicReference();

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this::testCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::testCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::testRunFinished);
    }

    private void testRunFinished(TestRunFinished testRunFinished) {
        this.getQaseTestCaseListener().onTestCasesSetFinished();
    }

    private void testCaseStarted(TestCaseStarted event) {
        this.getQaseTestCaseListener().onTestCaseStarted();
    }

    private void testCaseFinished(TestCaseFinished event) {
        this.getQaseTestCaseListener().onTestCaseFinished(resultCreate -> this.setupResultItem((ResultCreate)resultCreate, event));
    }

    private void setupResultItem(ResultCreate resultCreate, TestCaseFinished event) {
        List tags = event.getTestCase().getTags();
        Long caseId = CucumberUtils.getCaseId((List)tags);
        ResultCreate.StatusEnum status = this.convertStatus(event.getResult().getStatus());
        Optional<Throwable> optionalThrowable = Optional.ofNullable(event.getResult().getError());
        String comment = optionalThrowable.flatMap(throwable -> Optional.of(throwable.toString())).orElse(null);
        Boolean isDefect = optionalThrowable.flatMap(throwable -> Optional.of(throwable instanceof AssertionError)).orElse(false);
        String stacktrace = optionalThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        LinkedList steps = StepStorage.stopSteps();
        resultCreate.caseId(caseId).status(status).comment(comment).stacktrace(stacktrace).steps((List)(steps.isEmpty() ? null : steps)).defect(isDefect);
    }

    private ResultCreate.StatusEnum convertStatus(Status status) {
        switch (status) {
            case FAILED: {
                return ResultCreate.StatusEnum.FAILED;
            }
            case PASSED: {
                return ResultCreate.StatusEnum.PASSED;
            }
        }
        return ResultCreate.StatusEnum.SKIPPED;
    }

    private static QaseTestCaseListener createQaseListener() {
        return (QaseTestCaseListener)Cucumber5Module.getInjector().getInstance(QaseTestCaseListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QaseTestCaseListener getQaseTestCaseListener() {
        Object value = this.qaseTestCaseListener.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.qaseTestCaseListener;
            synchronized (atomicReference) {
                value = this.qaseTestCaseListener.get();
                if (value == null) {
                    QaseTestCaseListener actualValue = QaseEventListener.createQaseListener();
                    value = actualValue == null ? this.qaseTestCaseListener : actualValue;
                    this.qaseTestCaseListener.set(value);
                }
            }
        }
        return (QaseTestCaseListener)(value == this.qaseTestCaseListener ? null : value);
    }

    static {
        System.setProperty("QASE_CLIENT_REPORTER_NAME", REPORTER_NAME);
    }
}

