/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.models.report;

import io.qase.commons.models.report.ReportResult;
import io.qase.commons.models.report.RunExecution;
import io.qase.commons.models.report.RunStats;
import io.qase.commons.models.report.ShortReportResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Run {
    public String title;
    public RunExecution execution;
    public RunStats stats;
    public List<ShortReportResult> results;
    public List<String> threads;
    public List<String> suites;
    public String environment;
    public Map<String, String> hostData;

    public Run(String title, long startTime, long endTime, String environment) {
        this.title = title;
        this.execution = new RunExecution(startTime, endTime);
        this.stats = new RunStats();
        this.results = new ArrayList<ShortReportResult>();
        this.threads = new ArrayList<String>();
        this.suites = new ArrayList<String>();
        this.environment = environment;
    }

    public void addResults(List<ReportResult> results) {
        for (ReportResult result2 : results) {
            ShortReportResult shortResult = new ShortReportResult();
            shortResult.id = result2.id;
            shortResult.title = result2.title;
            shortResult.status = result2.execution.status.toString().toLowerCase();
            shortResult.duration = result2.execution.duration;
            shortResult.thread = result2.execution.thread;
            this.execution.track(shortResult);
            this.stats.track(shortResult, result2.muted);
            this.results.add(shortResult);
        }
        this.threads = this.results.stream().map(result -> result.thread).distinct().collect(Collectors.toList());
    }

    public void addHostData() {
        this.hostData = this.hostData;
    }
}

