/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.hooks;

import io.qase.commons.hooks.DefaultListener;
import io.qase.commons.hooks.HooksListener;
import io.qase.commons.hooks.HooksServiceLoader;
import io.qase.commons.logger.Logger;
import io.qase.commons.models.domain.TestResult;
import java.util.List;
import java.util.function.BiConsumer;

public class HooksManager {
    private static final Logger logger = Logger.getInstance();
    private final List<HooksListener> listeners;

    public HooksManager(List<HooksListener> listeners) {
        this.listeners = listeners;
    }

    public void beforeTestStop(TestResult result) {
        this.runSafelyMethod(this.listeners, HooksListener::beforeTestStop, result);
    }

    protected <T extends DefaultListener, S> void runSafelyMethod(List<T> listeners, BiConsumer<T, S> method, S object) {
        listeners.forEach(listener -> {
            try {
                method.accept(listener, object);
            }
            catch (Exception e) {
                logger.error("Could not invoke listener method", e);
            }
        });
    }

    public static HooksManager getDefaultHooksManager() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new HooksManager(HooksServiceLoader.load(HooksListener.class, classLoader));
    }
}

