/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.hooks;

import io.qase.commons.logger.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class HooksServiceLoader {
    private static final Logger logger = Logger.getInstance();

    private HooksServiceLoader() {
        throw new IllegalStateException("Do not have instance");
    }

    public static <T> List<T> load(Class<T> type, ClassLoader classLoader) {
        ArrayList<T> loaded = new ArrayList<T>();
        Iterator<T> iterator = ServiceLoader.load(type, classLoader).iterator();
        while (HooksServiceLoader.nextSafely(iterator)) {
            try {
                T next = iterator.next();
                loaded.add(next);
                logger.debug("Found type %s", type);
            }
            catch (Exception e) {
                logger.error("Could not load listener %s: %s", type, e.getMessage());
            }
        }
        return loaded;
    }

    private static boolean nextSafely(Iterator iterator) {
        try {
            return iterator.hasNext();
        }
        catch (Exception e) {
            logger.error("nextSafely failed", e);
            return false;
        }
    }
}

