/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class Logger {
    private static volatile Logger INSTANCE;
    private final ReentrantLock fileLock = new ReentrantLock();
    private static final String LOG_DIRECTORY = "logs";
    private static final String DEFAULT_LOG_FILE = "log.txt";
    private static final DateTimeFormatter DEFAULT_DATE_FORMAT;
    private String logFile = "logs" + File.separator + "log.txt";
    private DateTimeFormatter dateFormat = DEFAULT_DATE_FORMAT;
    private long maxFileSize = 0x6400000L;
    private int maxBackupFiles = 5;
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_CYAN = "\u001b[36m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static final ThreadLocal<Map<String, String>> MDC_CONTEXT;
    private volatile LogLevel globalLogLevel = LogLevel.INFO;
    private final Map<String, LogLevel> packageLogLevels = new HashMap<String, LogLevel>();
    private final BlockingQueue<LogMessage> messageQueue = new LinkedBlockingQueue<LogMessage>();
    private final Thread loggerThread;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private long errorCount = 0L;
    private long warnCount = 0L;
    private long infoCount = 0L;
    private long debugCount = 0L;
    private long traceCount = 0L;

    private Logger() {
        this.loggerThread = new Thread(() -> {
            while (this.running.get() || !this.messageQueue.isEmpty()) {
                try {
                    LogMessage message = this.messageQueue.take();
                    this.processLogMessage(message);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    System.err.println("Logger thread interrupted: " + e.getMessage());
                }
                catch (Exception e) {
                    System.err.println("Error in logger thread: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
        this.loggerThread.setName("EnhancedLogger-Thread");
        this.loggerThread.setDaemon(true);
        this.loggerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Logger getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Logger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public synchronized void setGlobalLogLevel(LogLevel logLevel) {
        this.globalLogLevel = logLevel;
    }

    public synchronized void setPackageLogLevel(String packageName, LogLevel logLevel) {
        this.packageLogLevels.put(packageName, logLevel);
    }

    public synchronized void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public synchronized void setDateFormat(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
    }

    public synchronized void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public synchronized void setMaxBackupFiles(int maxBackupFiles) {
        this.maxBackupFiles = maxBackupFiles;
    }

    public static void putMdc(String key, String value) {
        MDC_CONTEXT.get().put(key, value);
    }

    public static String getMdc(String key) {
        return MDC_CONTEXT.get().get(key);
    }

    public static void clearMdc() {
        MDC_CONTEXT.get().clear();
    }

    public static void removeMdc(String key) {
        MDC_CONTEXT.get().remove(key);
    }

    public void error(String message) {
        this.log(LogLevel.ERROR, message, null);
    }

    public void error(String message, Throwable throwable) {
        this.log(LogLevel.ERROR, message, throwable);
    }

    public void error(String format, Object ... args) {
        if (this.isEnabled(LogLevel.ERROR)) {
            this.log(LogLevel.ERROR, String.format(format, args), null);
        }
    }

    public void warn(String message) {
        this.log(LogLevel.WARN, message, null);
    }

    public void warn(String message, Throwable throwable) {
        this.log(LogLevel.WARN, message, throwable);
    }

    public void warn(String format, Object ... args) {
        if (this.isEnabled(LogLevel.WARN)) {
            this.log(LogLevel.WARN, String.format(format, args), null);
        }
    }

    public void info(String message) {
        this.log(LogLevel.INFO, message, null);
    }

    public void info(String format, Object ... args) {
        if (this.isEnabled(LogLevel.INFO)) {
            this.log(LogLevel.INFO, String.format(format, args), null);
        }
    }

    public void debug(String message) {
        this.log(LogLevel.DEBUG, message, null);
    }

    public void debug(String message, Throwable throwable) {
        this.log(LogLevel.DEBUG, message, throwable);
    }

    public void debug(String format, Object ... args) {
        if (this.isEnabled(LogLevel.DEBUG)) {
            this.log(LogLevel.DEBUG, String.format(format, args), null);
        }
    }

    public void trace(String message) {
        this.log(LogLevel.TRACE, message, null);
    }

    public void trace(String format, Object ... args) {
        if (this.isEnabled(LogLevel.TRACE)) {
            this.log(LogLevel.TRACE, String.format(format, args), null);
        }
    }

    public boolean isEnabled(LogLevel level) {
        String callerClass = this.getCallerClassName();
        LogLevel effectiveLevel = this.getEffectiveLogLevel(callerClass);
        return level.getValue() <= effectiveLevel.getValue();
    }

    private LogLevel getEffectiveLogLevel(String className) {
        String bestMatch = "";
        LogLevel bestLevel = this.globalLogLevel;
        for (Map.Entry<String, LogLevel> entry : this.packageLogLevels.entrySet()) {
            String pkg = entry.getKey();
            if (!className.startsWith(pkg) || pkg.length() <= bestMatch.length()) continue;
            bestMatch = pkg;
            bestLevel = entry.getValue();
        }
        return bestLevel;
    }

    private void log(LogLevel level, String message, Throwable throwable) {
        String callerClass = this.getCallerClassName();
        if (level.getValue() > this.getEffectiveLogLevel(callerClass).getValue()) {
            return;
        }
        HashMap<String, String> mdcCopy = new HashMap<String, String>(MDC_CONTEXT.get());
        LogMessage logMessage = new LogMessage(level, message, throwable, mdcCopy, callerClass);
        this.updateStatistics(level);
        this.messageQueue.add(logMessage);
    }

    private void processLogMessage(LogMessage message) {
        String formattedMessage = this.formatLogMessage(message);
        this.printToConsole(message.level, formattedMessage);
        this.writeToFile(formattedMessage, message.throwable);
    }

    private String formatLogMessage(LogMessage message) {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(message.timestamp.format(this.dateFormat)).append("] ");
        sb.append('[').append((Object)message.level).append("] ");
        sb.append('[').append("Thread-").append(Thread.currentThread().getId()).append("] ");
        sb.append('[').append(message.callerClass).append("] ");
        if (!message.mdcContext.isEmpty()) {
            sb.append('[');
            boolean first = true;
            for (Map.Entry<String, String> entry : message.mdcContext.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append('=').append(entry.getValue());
                first = false;
            }
            sb.append("] ");
        }
        sb.append(message.message);
        return sb.toString();
    }

    private void printToConsole(LogLevel level, String message) {
        String colorCode;
        switch (level) {
            case ERROR: {
                colorCode = ANSI_RED;
                break;
            }
            case WARN: {
                colorCode = ANSI_YELLOW;
                break;
            }
            case INFO: {
                colorCode = ANSI_GREEN;
                break;
            }
            case DEBUG: {
                colorCode = ANSI_CYAN;
                break;
            }
            case TRACE: {
                colorCode = ANSI_BLUE;
                break;
            }
            default: {
                colorCode = ANSI_RESET;
            }
        }
        System.out.println(colorCode + message + ANSI_RESET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String message, Throwable throwable) {
        this.fileLock.lock();
        try {
            this.createLogDirectory();
            File logFile = new File(this.logFile);
            if (logFile.exists() && logFile.length() > this.maxFileSize) {
                this.rotateLogFiles();
            }
            try (FileWriter fw = new FileWriter(logFile, true);
                 PrintWriter pw = new PrintWriter(fw);){
                pw.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(pw);
                }
                pw.flush();
            }
            catch (IOException e) {
                System.err.println("Error writing to log file: " + e.getMessage());
            }
        }
        finally {
            this.fileLock.unlock();
        }
    }

    private void rotateLogFiles() {
        File oldestBackup = new File(this.logFile + "." + this.maxBackupFiles);
        if (oldestBackup.exists()) {
            oldestBackup.delete();
        }
        for (int i = this.maxBackupFiles - 1; i > 0; --i) {
            File file = new File(this.logFile + "." + i);
            if (!file.exists()) continue;
            file.renameTo(new File(this.logFile + "." + (i + 1)));
        }
        File currentLog = new File(this.logFile);
        currentLog.renameTo(new File(this.logFile + ".1"));
    }

    private String getCallerClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String thisClassName = this.getClass().getName();
        for (int i = 2; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (className.equals(thisClassName) || className.startsWith("java.lang.Thread")) continue;
            return className;
        }
        return "Unknown";
    }

    private synchronized void updateStatistics(LogLevel level) {
        switch (level) {
            case ERROR: {
                ++this.errorCount;
                break;
            }
            case WARN: {
                ++this.warnCount;
                break;
            }
            case INFO: {
                ++this.infoCount;
                break;
            }
            case DEBUG: {
                ++this.debugCount;
                break;
            }
            case TRACE: {
                ++this.traceCount;
            }
        }
    }

    private void createLogDirectory() {
        boolean created;
        File directory = new File(LOG_DIRECTORY);
        if (!directory.exists() && !(created = directory.mkdir())) {
            System.err.println("Can not create logs directory: logs");
        }
    }

    public synchronized Map<String, Long> getStatistics() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        stats.put("ERROR", this.errorCount);
        stats.put("WARN", this.warnCount);
        stats.put("INFO", this.infoCount);
        stats.put("DEBUG", this.debugCount);
        stats.put("TRACE", this.traceCount);
        return stats;
    }

    public void shutdown() {
        this.running.set(false);
        this.loggerThread.interrupt();
        try {
            this.loggerThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Interrupted while shutting down logger");
        }
    }

    public void flush() {
        Object marker = new Object();
        AtomicBoolean processed = new AtomicBoolean(false);
        try {
            this.log(LogLevel.INFO, "FLUSH-MARKER-" + marker.hashCode(), null);
            while (!processed.get() && !this.messageQueue.isEmpty()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        DEFAULT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        MDC_CONTEXT = ThreadLocal.withInitial(HashMap::new);
    }

    public static enum LogLevel {
        OFF(0),
        ERROR(1),
        WARN(2),
        INFO(3),
        DEBUG(4),
        TRACE(5);

        private final int value;

        private LogLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class LogMessage {
        final LogLevel level;
        final String message;
        final Throwable throwable;
        final Map<String, String> mdcContext;
        final String callerClass;
        final LocalDateTime timestamp;

        LogMessage(LogLevel level, String message, Throwable throwable, Map<String, String> mdcContext, String callerClass) {
            this.level = level;
            this.message = message;
            this.throwable = throwable;
            this.mdcContext = new HashMap<String, String>(mdcContext);
            this.callerClass = callerClass;
            this.timestamp = LocalDateTime.now();
        }
    }
}

