/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.reporters;

import io.qase.commons.QaseException;
import io.qase.commons.client.ApiClientV2;
import io.qase.commons.config.Mode;
import io.qase.commons.config.QaseConfig;
import io.qase.commons.hooks.HooksManager;
import io.qase.commons.logger.Logger;
import io.qase.commons.models.domain.TestResult;
import io.qase.commons.reporters.FileReporter;
import io.qase.commons.reporters.InternalReporter;
import io.qase.commons.reporters.Reporter;
import io.qase.commons.reporters.TestopsReporter;
import io.qase.commons.writers.FileWriter;
import java.util.List;

public class CoreReporter
implements Reporter {
    private static final Logger logger = Logger.getInstance();
    private InternalReporter reporter;
    private InternalReporter fallback;
    private final HooksManager hooksManager;

    public CoreReporter(QaseConfig config) {
        this.reporter = this.createReporter(config, config.mode);
        this.fallback = this.createReporter(config, config.fallback);
        this.hooksManager = HooksManager.getDefaultHooksManager();
    }

    @Override
    public void startTestRun() {
        logger.info("Starting test run");
        this.executeWithFallback(() -> this.reporter.startTestRun(), "start test run");
    }

    @Override
    public void completeTestRun() {
        logger.info("Completing test run");
        this.executeWithFallback(() -> this.reporter.completeTestRun(), "complete test run");
    }

    @Override
    public void addResult(TestResult result) {
        logger.debug("Adding result: %s", result);
        this.hooksManager.beforeTestStop(result);
        this.executeWithFallback(() -> this.reporter.addResult(result), "add result");
    }

    @Override
    public void uploadResults() {
        logger.info("Uploading results");
        this.executeWithFallback(() -> this.reporter.uploadResults(), "upload results");
    }

    @Override
    public List<Long> getTestCaseIdsForExecution() {
        return this.reporter.getTestCaseIdsForExecution();
    }

    private void executeWithFallback(ReporterAction action, String actionName) {
        if (this.reporter != null) {
            try {
                action.execute();
            }
            catch (QaseException e) {
                logger.error("Failed to %s with reporter: %s", actionName, e.getMessage());
                this.useFallback();
                this.retryAction(action, actionName);
            }
        }
    }

    private void retryAction(ReporterAction action, String actionName) {
        if (this.reporter != null) {
            try {
                action.execute();
            }
            catch (QaseException ex) {
                logger.error("Failed to %s with reporter after fallback: %s", actionName, ex.getMessage());
                this.reporter = null;
            }
        }
    }

    private void useFallback() {
        if (this.fallback == null) {
            this.reporter = null;
            return;
        }
        try {
            this.fallback.startTestRun();
            this.fallback.setResults(this.reporter.getResults());
            this.reporter = this.fallback;
            this.fallback = null;
        }
        catch (QaseException e) {
            logger.error("Failed to start test run with fallback reporter", e);
            this.reporter = null;
        }
    }

    private InternalReporter createReporter(QaseConfig config, Mode mode) {
        switch (mode) {
            case TESTOPS: {
                ApiClientV2 client = new ApiClientV2(config);
                return new TestopsReporter(config.testops, client);
            }
            case REPORT: {
                FileWriter writer = new FileWriter(config.report.connection);
                return new FileReporter(config, writer);
            }
        }
        return null;
    }

    @FunctionalInterface
    private static interface ReporterAction {
        public void execute() throws QaseException;
    }
}

