#include <QtCore/QtGlobal>
#include <QtLocation/qgeorouterequest.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qdatetime.h>
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeorectangle.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiLocation/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QGeoRouteRequest(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QGeoRouteRequest")
    QGeoRouteRequest *_ptr = reinterpret_cast<QGeoRouteRequest *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)
void __qt_construct_QGeoRouteRequest_cref_QGeoCoordinate_cref_QGeoCoordinate(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)")
    jobject origin0 = __java_arguments[0].l;
    const QGeoCoordinate& __qt_origin0 = qtjambi_cast<const QGeoCoordinate& >(__jni_env, origin0);
    jobject destination1 = __java_arguments[1].l;
    const QGeoCoordinate& __qt_destination1 = qtjambi_cast<const QGeoCoordinate& >(__jni_env, destination1);
    QGeoRouteRequest *__qt_this = new(__qtjambi_ptr) QGeoRouteRequest(__qt_origin0, __qt_destination1);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRouteRequest::QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_initialize_1native__Lio_qt_location_QGeoRouteRequest_2Lio_qt_positioning_QGeoCoordinate_2Lio_qt_positioning_QGeoCoordinate_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject origin0,
 jobject destination1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRouteRequest::QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)")
    QTJAMBI_TRY {
        jvalue arguments[2];
        arguments[0].l = origin0;
        arguments[1].l = destination1;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRouteRequest_cref_QGeoCoordinate_cref_QGeoCoordinate, sizeof(QGeoRouteRequest), typeid(QGeoRouteRequest), false, &deleter_QGeoRouteRequest, arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRouteRequest(QGeoRouteRequest)
void __qt_construct_QGeoRouteRequest_cref_QGeoRouteRequest(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRouteRequest(QGeoRouteRequest)")
    jobject other0 = __java_arguments[0].l;
    const QGeoRouteRequest& __qt_other0 = qtjambi_cast<const QGeoRouteRequest& >(__jni_env, other0);
    QGeoRouteRequest *__qt_this = new(__qtjambi_ptr) QGeoRouteRequest(__qt_other0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRouteRequest::QGeoRouteRequest(QGeoRouteRequest)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_initialize_1native__Lio_qt_location_QGeoRouteRequest_2Lio_qt_location_QGeoRouteRequest_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRouteRequest::QGeoRouteRequest(QGeoRouteRequest)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRouteRequest_cref_QGeoRouteRequest, sizeof(QGeoRouteRequest), typeid(QGeoRouteRequest), false, &deleter_QGeoRouteRequest, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QGeoRouteRequest(QList<QGeoCoordinate>)
void __qt_construct_QGeoRouteRequest(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRouteRequest(QList<QGeoCoordinate>)")
    Q_UNUSED(__java_arguments)
    QGeoRouteRequest *__qt_this = new(__qtjambi_ptr) QGeoRouteRequest();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QGeoRouteRequest(QList<QGeoCoordinate>)
void __qt_construct_QGeoRouteRequest_cref_QList(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QGeoRouteRequest(QList<QGeoCoordinate>)")
    QtJambiScope __qtjambi_scope;
    jobject waypoints0 = __java_arguments[0].l;
    const QList<QGeoCoordinate>&  __qt_waypoints0 = qtjambi_cast<const QList<QGeoCoordinate>& >(__jni_env, __qtjambi_scope, waypoints0);
    QGeoRouteRequest *__qt_this = new(__qtjambi_ptr) QGeoRouteRequest(__qt_waypoints0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QGeoRouteRequest::QGeoRouteRequest(QList<QGeoCoordinate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_initialize_1native__Lio_qt_location_QGeoRouteRequest_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject waypoints0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QGeoRouteRequest::QGeoRouteRequest(QList<QGeoCoordinate>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = waypoints0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QGeoRouteRequest_cref_QList, sizeof(QGeoRouteRequest), typeid(QGeoRouteRequest), false, &deleter_QGeoRouteRequest, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QGeoRouteRequest
void __qt_destruct_QGeoRouteRequest(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QGeoRouteRequest")
    reinterpret_cast<QGeoRouteRequest*>(ptr)->~QGeoRouteRequest();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QGeoRouteRequest::departureTime()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_departureTime_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::departureTime()const", __qt_this)
        QDateTime __qt_return_value = __qt_this->departureTime();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::excludeAreas()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_excludeAreas_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::excludeAreas()const", __qt_this)
        QList<QGeoRectangle> __qt_return_value = __qt_this->excludeAreas();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::featureTypes()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_featureTypes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::featureTypes()const", __qt_this)
        QList<QGeoRouteRequest::FeatureType> __qt_return_value = __qt_this->featureTypes();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::featureWeight(QGeoRouteRequest::FeatureType)const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_featureWeight_1native_1QGeoRouteRequest_1FeatureType_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint featureType0)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::featureWeight(QGeoRouteRequest::FeatureType)const", __qt_this)
        QGeoRouteRequest::FeatureType __qt_featureType0 = qtjambi_cast<QGeoRouteRequest::FeatureType>(__jni_env, featureType0);
        QGeoRouteRequest::FeatureWeight __qt_return_value = __qt_this->featureWeight(QGeoRouteRequest::FeatureType(__qt_featureType0));
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::maneuverDetail()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_maneuverDetail_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::maneuverDetail()const", __qt_this)
        QGeoRouteRequest::ManeuverDetail __qt_return_value = __qt_this->maneuverDetail();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::numberAlternativeRoutes()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_numberAlternativeRoutes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::numberAlternativeRoutes()const", __qt_this)
        __java_return_value = __qt_this->numberAlternativeRoutes();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::operator=(QGeoRouteRequest)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_assign_1native_1cref_1QGeoRouteRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::operator=(QGeoRouteRequest)", __qt_this)
        const QGeoRouteRequest& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QGeoRouteRequest>(__jni_env, other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::operator==(QGeoRouteRequest,QGeoRouteRequest)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_equals_1native_1cref_1QGeoRouteRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::operator==(QGeoRouteRequest,QGeoRouteRequest)", __qt_this)
        const QGeoRouteRequest& __qt_rhs1 = QtJambiAPI::objectReferenceFromNativeId<QGeoRouteRequest>(__jni_env, rhs1);
        __java_return_value = (*__qt_this) == __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::routeOptimization()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_routeOptimization_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::routeOptimization()const", __qt_this)
        QGeoRouteRequest::RouteOptimizations __qt_return_value = __qt_this->routeOptimization();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::segmentDetail()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_segmentDetail_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::segmentDetail()const", __qt_this)
        QGeoRouteRequest::SegmentDetail __qt_return_value = __qt_this->segmentDetail();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::setDepartureTime(QDateTime)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setDepartureTime_1native_1cref_1QDateTime__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID departureTime0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setDepartureTime(QDateTime)", __qt_this)
        const QDateTime& __qt_departureTime0 = QtJambiAPI::valueReferenceFromNativeId<QDateTime>(departureTime0);
        __qt_this->setDepartureTime(__qt_departureTime0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setExcludeAreas(QList<QGeoRectangle>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setExcludeAreas_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject areas0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setExcludeAreas(QList<QGeoRectangle>)", __qt_this)
        const QList<QGeoRectangle>&  __qt_areas0 = qtjambi_cast<const QList<QGeoRectangle>& >(__jni_env, __qtjambi_scope, areas0);
        __qt_this->setExcludeAreas(__qt_areas0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setFeatureWeight(QGeoRouteRequest::FeatureType,QGeoRouteRequest::FeatureWeight)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setFeatureWeight_1native_1QGeoRouteRequest_1FeatureType_1QGeoRouteRequest_1FeatureWeight__JII)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint featureType0,
 jint featureWeight1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setFeatureWeight(QGeoRouteRequest::FeatureType,QGeoRouteRequest::FeatureWeight)", __qt_this)
        QGeoRouteRequest::FeatureType __qt_featureType0 = qtjambi_cast<QGeoRouteRequest::FeatureType>(__jni_env, featureType0);
        QGeoRouteRequest::FeatureWeight __qt_featureWeight1 = qtjambi_cast<QGeoRouteRequest::FeatureWeight>(__jni_env, featureWeight1);
        __qt_this->setFeatureWeight(QGeoRouteRequest::FeatureType(__qt_featureType0), QGeoRouteRequest::FeatureWeight(__qt_featureWeight1));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setManeuverDetail(QGeoRouteRequest::ManeuverDetail)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setManeuverDetail_1native_1QGeoRouteRequest_1ManeuverDetail__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint maneuverDetail0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setManeuverDetail(QGeoRouteRequest::ManeuverDetail)", __qt_this)
        QGeoRouteRequest::ManeuverDetail __qt_maneuverDetail0 = qtjambi_cast<QGeoRouteRequest::ManeuverDetail>(__jni_env, maneuverDetail0);
        __qt_this->setManeuverDetail(QGeoRouteRequest::ManeuverDetail(__qt_maneuverDetail0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setNumberAlternativeRoutes(int)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setNumberAlternativeRoutes_1native_1int__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint alternatives0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setNumberAlternativeRoutes(int)", __qt_this)
        __qt_this->setNumberAlternativeRoutes(static_cast<int>(alternatives0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setRouteOptimization(QGeoRouteRequest::RouteOptimizations)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setRouteOptimization_1native_1QGeoRouteRequest_1RouteOptimizations__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint optimization0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setRouteOptimization(QGeoRouteRequest::RouteOptimizations)", __qt_this)
        QGeoRouteRequest::RouteOptimizations __qt_optimization0 = qtjambi_cast<QGeoRouteRequest::RouteOptimizations>(__jni_env, optimization0);
        __qt_this->setRouteOptimization(QGeoRouteRequest::RouteOptimizations(__qt_optimization0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setSegmentDetail(QGeoRouteRequest::SegmentDetail)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setSegmentDetail_1native_1QGeoRouteRequest_1SegmentDetail__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint segmentDetail0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setSegmentDetail(QGeoRouteRequest::SegmentDetail)", __qt_this)
        QGeoRouteRequest::SegmentDetail __qt_segmentDetail0 = qtjambi_cast<QGeoRouteRequest::SegmentDetail>(__jni_env, segmentDetail0);
        __qt_this->setSegmentDetail(QGeoRouteRequest::SegmentDetail(__qt_segmentDetail0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setTravelModes(QGeoRouteRequest::TravelModes)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setTravelModes_1native_1QGeoRouteRequest_1TravelModes__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint travelModes0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setTravelModes(QGeoRouteRequest::TravelModes)", __qt_this)
        QGeoRouteRequest::TravelModes __qt_travelModes0 = qtjambi_cast<QGeoRouteRequest::TravelModes>(__jni_env, travelModes0);
        __qt_this->setTravelModes(QGeoRouteRequest::TravelModes(__qt_travelModes0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::setWaypoints(QList<QGeoCoordinate>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_setWaypoints_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject waypoints0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::setWaypoints(QList<QGeoCoordinate>)", __qt_this)
        const QList<QGeoCoordinate>&  __qt_waypoints0 = qtjambi_cast<const QList<QGeoCoordinate>& >(__jni_env, __qtjambi_scope, waypoints0);
        __qt_this->setWaypoints(__qt_waypoints0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::swap(QGeoRouteRequest&)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_swap_1native_1ref_1QGeoRouteRequest__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::swap(QGeoRouteRequest&)", __qt_this)
        QGeoRouteRequest& __qt_other0 = QtJambiAPI::objectReferenceFromNativeId<QGeoRouteRequest>(__jni_env, other0);
        __qt_this->swap(__qt_other0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QGeoRouteRequest::travelModes()const
extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_travelModes_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jint __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::travelModes()const", __qt_this)
        QGeoRouteRequest::TravelModes __qt_return_value = __qt_this->travelModes();
        __java_return_value = __qt_return_value;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QGeoRouteRequest::waypoints()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_waypoints_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QGeoRouteRequest::waypoints()const", __qt_this)
        QList<QGeoCoordinate> __qt_return_value = __qt_this->waypoints();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_location_QGeoRouteRequest_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QGeoRouteRequest *__qt_this = QtJambiAPI::objectFromNativeId<QGeoRouteRequest>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QGeoRouteRequest(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QGeoRouteRequest>("QGeoRouteRequest", "io/qt/location/QGeoRouteRequest");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QGeoRouteRequest, {
        ConstructorInfo(&__qt_construct_QGeoRouteRequest_cref_QGeoCoordinate_cref_QGeoCoordinate, "Lio/qt/positioning/QGeoCoordinate;Lio/qt/positioning/QGeoCoordinate;")
       ,ConstructorInfo(&__qt_construct_QGeoRouteRequest_cref_QGeoRouteRequest, "Lio/qt/location/QGeoRouteRequest;")
       ,ConstructorInfo(&__qt_construct_QGeoRouteRequest, nullptr)
       ,ConstructorInfo(&__qt_construct_QGeoRouteRequest_cref_QList, "Ljava/util/Collection;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QGeoRouteRequest);
    registerMetaType<QGeoRouteRequest>("QGeoRouteRequest");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QGeoRouteRequest::FeatureType>("QGeoRouteRequest::FeatureType", "io/qt/location/QGeoRouteRequest$FeatureType", "QGeoRouteRequest::FeatureTypes", "QFlags<QGeoRouteRequest::FeatureType>", "io/qt/location/QGeoRouteRequest$FeatureTypes");
    registerEnumTypeInfo<QGeoRouteRequest::FeatureWeight>("QGeoRouteRequest::FeatureWeight", "io/qt/location/QGeoRouteRequest$FeatureWeight", "QGeoRouteRequest::FeatureWeights", "QFlags<QGeoRouteRequest::FeatureWeight>", "io/qt/location/QGeoRouteRequest$FeatureWeights");
    registerEnumTypeInfo<QGeoRouteRequest::ManeuverDetail>("QGeoRouteRequest::ManeuverDetail", "io/qt/location/QGeoRouteRequest$ManeuverDetail", "QGeoRouteRequest::ManeuverDetails", "QFlags<QGeoRouteRequest::ManeuverDetail>", "io/qt/location/QGeoRouteRequest$ManeuverDetails");
    registerEnumTypeInfo<QGeoRouteRequest::RouteOptimization>("QGeoRouteRequest::RouteOptimization", "io/qt/location/QGeoRouteRequest$RouteOptimization", "QGeoRouteRequest::RouteOptimizations", "QFlags<QGeoRouteRequest::RouteOptimization>", "io/qt/location/QGeoRouteRequest$RouteOptimizations");
    registerEnumTypeInfo<QGeoRouteRequest::SegmentDetail>("QGeoRouteRequest::SegmentDetail", "io/qt/location/QGeoRouteRequest$SegmentDetail", "QGeoRouteRequest::SegmentDetails", "QFlags<QGeoRouteRequest::SegmentDetail>", "io/qt/location/QGeoRouteRequest$SegmentDetails");
    registerEnumTypeInfo<QGeoRouteRequest::TravelMode>("QGeoRouteRequest::TravelMode", "io/qt/location/QGeoRouteRequest$TravelMode", "QGeoRouteRequest::TravelModes", "QFlags<QGeoRouteRequest::TravelMode>", "io/qt/location/QGeoRouteRequest$TravelModes");
// END: enums and flags
}
