#ifndef QOPENGLFUNCTIONS_ES2_SHELL_H
#define QOPENGLFUNCTIONS_ES2_SHELL_H

#include <QtCore/QtGlobal>
#if __has_include(<QtOpenGL/qopenglfunctions_es2.h>)
#include <QtOpenGL/qopenglfunctions_es2.h>
#endif
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtGui/qopenglcontext.h>
#include <QtOpenGL/qopenglversionprofile.h>
#include <QtJambi/RegistryAPI>


#if QT_CONFIG(opengles2) && __has_include(<QtOpenGL/QOpenGLFunctions_ES2>)

class QOpenGLFunctions_ES2_shell : public QOpenGLFunctions_ES2, public QtJambiShellInterface
{
public:
    QOpenGLFunctions_ES2_shell();
    ~QOpenGLFunctions_ES2_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QOpenGLFunctions_ES2_oshell;
};


class QOpenGLFunctions_ES2_oshell : public QOpenGLFunctions_ES2_shell
{
public:
    using QOpenGLFunctions_ES2_shell::QOpenGLFunctions_ES2_shell;
    bool initializeOpenGLFunctions() override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QOpenGLFunctions_ES2_access : public QOpenGLFunctions_ES2
{
    jboolean __qt_initializeOpenGLFunctions(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
};

#endif // QT_CONFIG(opengles2) && __has_include(<QtOpenGL/QOpenGLFunctions_ES2>)
#endif // QOPENGLFUNCTIONS_ES2_SHELL_H
