/*
 * Decompiled with CFR 0.152.
 */
package io.qt.qml.util;

import io.qt.core.QDir;
import io.qt.core.QFile;
import io.qt.core.QFileInfo;
import io.qt.core.QIODevice;
import io.qt.core.QIODeviceBase;
import io.qt.core.QList;
import io.qt.core.QResource;
import io.qt.core.QStringList;
import io.qt.core.QTextStream;
import io.qt.core.QUrl;
import io.qt.qml.QQmlExtensionPlugin;
import io.qt.qml.QtQml;
import io.qt.qml.util.QmlAddedInMinorVersion;
import io.qt.qml.util.QmlImport;
import io.qt.qml.util.QmlImportMajorVersion;
import io.qt.qml.util.QmlNoMajorVersionException;
import io.qt.qml.util.QmlTypeRegistrationException;
import io.qt.qml.util.QtJambi_LibraryUtilities;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

public final class QmlTypes {
    private static final QmlClassLoader qmlClassLoader;

    private QmlTypes() throws InstantiationError {
        throw new InstantiationError("Cannot instantiate class QmlTypes.");
    }

    public static void registerPackage(Package pkg) {
        QmlTypes.registerPackage(pkg, null);
    }

    public static void registerPackage(Package pkg, int versionMajor) {
        QmlTypes.registerPackage(pkg, null, versionMajor, new Class[0]);
    }

    public static void registerPackage(Package pkg, String uri) {
        QmlImportMajorVersion importMajorVersion = pkg.getAnnotation(QmlImportMajorVersion.class);
        QmlImport qmlimport = pkg.getAnnotation(QmlImport.class);
        if (importMajorVersion == null && qmlimport == null) {
            try {
                Class<?> infoClass = QmlTypes.class.getClassLoader().loadClass(pkg.getName() + ".package-info");
                importMajorVersion = infoClass.getAnnotation(QmlImportMajorVersion.class);
                qmlimport = infoClass.getAnnotation(QmlImport.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (importMajorVersion == null && qmlimport == null) {
                throw new QmlNoMajorVersionException("No QmlImport annotation in package " + pkg);
            }
        }
        if (qmlimport != null) {
            QmlTypes.registerPackage(pkg, uri, qmlimport.majorVersion(), qmlimport.classes());
        } else {
            QmlTypes.registerPackage(pkg, uri, importMajorVersion.value(), new Class[0]);
        }
    }

    public static void registerPackage(Package pkg, String uri, int versionMajor, Class<?> ... classes) {
        boolean isModule;
        boolean bl = isModule = uri == null;
        if (uri == null) {
            uri = pkg.getName();
        }
        ArrayList registeredClasses = new ArrayList();
        for (Class<?> cls : classes) {
            if (registeredClasses.contains(cls)) continue;
            registeredClasses.add(cls);
        }
        QDir classPath = new QDir(":" + pkg.getName().replace('.', '/'));
        for (String className : classPath.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
            if (!className.endsWith(".class") || className.endsWith("-info.class") || className.contains("$")) continue;
            className = pkg.getName() + "." + className.substring(0, className.length() - 6);
            try {
                Class<?> cls;
                try {
                    cls = qmlClassLoader.loadClass(className);
                }
                catch (Exception e) {
                    try {
                        cls = ClassLoader.getSystemClassLoader().loadClass(className);
                    }
                    catch (Exception e1) {
                        try {
                            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                        }
                        catch (Exception e2) {
                            cls = Class.forName(className);
                        }
                    }
                }
                if (registeredClasses.contains(cls)) continue;
                registeredClasses.add(cls);
            }
            catch (Exception exception) {}
        }
        try {
            QmlTypes.analyzeType(uri, versionMajor, null, registeredClasses.toArray(new Class[registeredClasses.size()]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String qmlFile : classPath.entryList(Collections.singletonList("*.qml"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
            QtQml.qmlRegisterType(new QUrl("qrc:" + pkg.getName().replace('.', '/') + "/" + qmlFile), uri, versionMajor, 0, qmlFile.substring(0, qmlFile.length() - 4));
        }
        if (isModule) {
            QtQml.qmlRegisterModule(uri, versionMajor, 0);
            QtQml.qmlProtectModule(uri, versionMajor);
        }
    }

    public static void registerPackage(String pkg) {
        QmlTypes.registerPackage(pkg, null);
    }

    public static void registerPackage(String pkg, String uri) {
        Package _package = QtJambi_LibraryUtilities.internal.getDefinedPackage((ClassLoader)qmlClassLoader, pkg);
        if (_package == null) {
            _package = QtJambi_LibraryUtilities.internal.getDefinedPackage(ClassLoader.getSystemClassLoader(), pkg);
        }
        if (_package == null) {
            _package = QtJambi_LibraryUtilities.internal.getDefinedPackage(Thread.currentThread().getContextClassLoader(), pkg);
        }
        if (_package == null) {
            QDir classPath = new QDir(":" + pkg.replace('.', '/'));
            for (String className : classPath.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                if (!className.endsWith(".class") || className.endsWith("-info.class") || className.contains("$")) continue;
                className = pkg + "." + className.substring(0, className.length() - 6);
                try {
                    Class<?> cls;
                    try {
                        cls = qmlClassLoader.loadClass(className);
                    }
                    catch (Exception e) {
                        try {
                            cls = ClassLoader.getSystemClassLoader().loadClass(className);
                        }
                        catch (Exception e1) {
                            try {
                                cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                            }
                            catch (Exception e2) {
                                cls = Class.forName(className);
                            }
                        }
                    }
                    _package = cls.getPackage();
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (_package == null) {
            throw new IllegalArgumentException("No such package " + pkg);
        }
        QmlTypes.registerPackage(_package, uri);
    }

    public static void registerPackage(String pkg, int versionMajor) {
        QmlTypes.registerPackage(pkg, null, versionMajor);
    }

    public static void registerPackage(String pkg, String uri, int versionMajor) {
        Package _package = QtJambi_LibraryUtilities.internal.getDefinedPackage((ClassLoader)qmlClassLoader, pkg);
        if (_package == null) {
            _package = QtJambi_LibraryUtilities.internal.getDefinedPackage(ClassLoader.getSystemClassLoader(), pkg);
        }
        if (_package == null) {
            _package = QtJambi_LibraryUtilities.internal.getDefinedPackage(Thread.currentThread().getContextClassLoader(), pkg);
        }
        if (_package == null) {
            QDir classPath = new QDir(":" + pkg.replace('.', '/'));
            for (String className : classPath.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                if (!className.endsWith(".class") || className.endsWith("-info.class") || className.contains("$")) continue;
                className = pkg + "." + className.substring(0, className.length() - 6);
                try {
                    Class<?> cls;
                    try {
                        cls = qmlClassLoader.loadClass(className);
                    }
                    catch (Exception e) {
                        try {
                            cls = ClassLoader.getSystemClassLoader().loadClass(className);
                        }
                        catch (Exception e1) {
                            try {
                                cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                            }
                            catch (Exception e2) {
                                cls = Class.forName(className);
                            }
                        }
                    }
                    _package = cls.getPackage();
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (_package == null) {
            throw new IllegalArgumentException("No such package " + pkg);
        }
        QmlTypes.registerPackage(_package, uri, versionMajor, new Class[0]);
    }

    public static int registerType(Class<?> type) {
        if (type.getPackage() == null) {
            throw new QmlTypeRegistrationException("Cannot register classes from default package.");
        }
        QmlImportMajorVersion importMajorVersion = type.getPackage().getAnnotation(QmlImportMajorVersion.class);
        QmlImport qmlimport = type.getPackage().getAnnotation(QmlImport.class);
        if (importMajorVersion == null && qmlimport == null) {
            throw new QmlNoMajorVersionException("No QmlImport annotation in package " + type.getPackage());
        }
        return qmlimport != null ? QmlTypes.registerType(type, qmlimport.majorVersion()) : QmlTypes.registerType(type, importMajorVersion.value());
    }

    public static int registerType(Class<?> type, int versionMajor) {
        return QmlTypes.registerType(type, type.getPackage().getName(), versionMajor);
    }

    public static int registerType(Class<?> type, String uri, int versionMajor) {
        try {
            QList resultTypeIDs = new QList(Integer.TYPE);
            QmlTypes.analyzeType(uri, versionMajor, (Collection<Integer>)resultTypeIDs, type);
            return resultTypeIDs.isEmpty() ? -1 : (Integer)resultTypeIDs.first();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QmlTypeRegistrationException("Cannot register class " + type.getName(), e);
        }
    }

    private static native void analyzeType(String var0, int var1, Collection<Integer> var2, Class<?> ... var3) throws Exception;

    private static int getMinorVersion(Class<?> cls) {
        int versionMinor = 0;
        QmlAddedInMinorVersion addedInMinorVersion = cls.getAnnotation(QmlAddedInMinorVersion.class);
        if (addedInMinorVersion != null) {
            versionMinor = addedInMinorVersion.value();
        }
        return versionMinor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerModule(String libraryDir, String uri) {
        QFile qmldir;
        QDir directory = new QDir(libraryDir);
        if (!directory.exists("qmldir") && !(directory = new QDir(":qml/" + uri.replace(".", "/"))).exists("qmldir")) {
            directory = new QDir(":qt-project.org/imports/" + uri.replace(".", "/"));
        }
        if ((qmldir = new QFile(directory.filePath("qmldir"))).exists() && qmldir.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
            QStringList classPath = new QStringList();
            QStringList libraryPath = new QStringList();
            try {
                QTextStream s = new QTextStream((QIODevice)qmldir);
                while (!s.atEnd()) {
                    String line = s.readLine();
                    if (line.startsWith("classpath ")) {
                        classPath.clear();
                        classPath.append(Arrays.asList(line.substring(10).trim().split(",")));
                        continue;
                    }
                    if (!line.startsWith("librarypath ")) continue;
                    libraryPath.append(Arrays.asList(System.getProperty("java.library.path", "").split(File.pathSeparator)));
                    for (String lp : line.substring(12).trim().split(",")) {
                        if (libraryPath.contains((Object)(lp = QDir.toNativeSeparators((String)directory.absoluteFilePath(lp))))) continue;
                        libraryPath.append((Object)lp);
                    }
                }
            }
            finally {
                qmldir.close();
            }
            if (!libraryPath.isEmpty()) {
                System.setProperty("java.library.path", libraryPath.join(File.pathSeparatorChar));
            }
            if (classPath.isEmpty()) {
                classPath.append((Collection)directory.entryList(Arrays.asList("*.jar"), new QDir.Filter[]{QDir.Filter.Files}));
            }
            for (String cp : classPath) {
                File file = new File(QDir.toNativeSeparators((String)directory.absoluteFilePath(cp)));
                try {
                    URL url = file.toURI().toURL();
                    if (Arrays.asList(qmlClassLoader.getURLs()).contains(url)) continue;
                    qmlClassLoader.addURL(url);
                }
                catch (Throwable e) {
                    Logger.getLogger("internal").throwing(QmlTypes.class.getName(), "registerTypes()", e);
                }
            }
            Package _package = QtJambi_LibraryUtilities.internal.getDefinedPackage((ClassLoader)qmlClassLoader, uri);
            if (_package == null) {
                _package = QtJambi_LibraryUtilities.internal.getDefinedPackage(ClassLoader.getSystemClassLoader(), uri);
            }
            if (_package == null) {
                _package = QtJambi_LibraryUtilities.internal.getDefinedPackage(Thread.currentThread().getContextClassLoader(), uri);
            }
            if (_package == null) {
                QDir classPathDir = new QDir(":" + uri.replace('.', '/'));
                for (String className : classPathDir.entryList(Collections.singletonList("*.class"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                    if (!className.endsWith(".class") || className.endsWith("-info.class") || className.contains("$")) continue;
                    className = uri + "." + className.substring(0, className.length() - 6);
                    try {
                        Class<?> cls = qmlClassLoader.loadClass(className);
                        _package = cls.getPackage();
                        break;
                    }
                    catch (Exception cls) {
                    }
                }
            }
            int version = 1;
            if (_package != null) {
                QmlImportMajorVersion importMajorVersion = _package.getAnnotation(QmlImportMajorVersion.class);
                QmlImport qmlimport = _package.getAnnotation(QmlImport.class);
                if (importMajorVersion == null && qmlimport == null) {
                    try {
                        Class<?> infoClass = QmlTypes.class.getClassLoader().loadClass(_package.getName() + ".package-info");
                        importMajorVersion = infoClass.getAnnotation(QmlImportMajorVersion.class);
                        qmlimport = infoClass.getAnnotation(QmlImport.class);
                    }
                    catch (Throwable infoClass) {
                        // empty catch block
                    }
                    if (importMajorVersion == null && qmlimport == null) {
                        throw new QmlNoMajorVersionException("No QmlImport annotation in package " + _package.getName());
                    }
                }
                if (qmlimport != null) {
                    version = qmlimport.majorVersion();
                    QmlTypes.registerPackage(_package, uri, version, qmlimport.classes());
                } else {
                    version = importMajorVersion.value();
                    QmlTypes.registerPackage(_package, uri, version, new Class[0]);
                }
            }
            for (String qmlFile : directory.entryList(Collections.singletonList("*.qml"), new QDir.Filters(new QDir.Filter[]{QDir.Filter.Files, QDir.Filter.NoSymLinks}))) {
                QUrl url = directory.path().startsWith(":") ? new QUrl("qrc" + directory.absoluteFilePath(qmlFile)) : QUrl.fromLocalFile((String)directory.absoluteFilePath(qmlFile));
                QtQml.qmlRegisterType(url, uri, version, 0, qmlFile.substring(0, qmlFile.length() - 4));
            }
            QtQml.qmlRegisterModule(uri, version, 0);
            QtQml.qmlProtectModule(uri, version);
        }
    }

    static {
        QtJambi_LibraryUtilities.initialize();
        qmlClassLoader = new QmlClassLoader();
    }

    private static class QmlClassLoader
    extends URLClassLoader {
        public QmlClassLoader() {
            super(new URL[0]);
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
            QResource.addClassPath((String)url.toString());
        }
    }

    private static class JarImport
    extends QQmlExtensionPlugin {
        private final String libraryPath;

        @Override
        public void registerTypes(String uri) {
            QmlTypes.registerModule(this.libraryPath, uri);
        }

        private JarImport(String libraryPath) {
            this.libraryPath = new QFileInfo(libraryPath).absolutePath();
        }
    }
}

