package io.qt.webengine;

import io.qt.*;


/**
 * <p>Web engine profile shared by multiple pages</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html">QQuickWebEngineProfile</a></code></p>
 */
public class QQuickWebEngineProfile extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcUrlSchemeHandler;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickWebEngineProfile.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#HttpCacheType-enum">QQuickWebEngineProfile::HttpCacheType</a></code></p>
     */
    public enum HttpCacheType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#HttpCacheType-enum">QQuickWebEngineProfile::<wbr/>MemoryHttpCache</a></code></p>
         */
        MemoryHttpCache(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#HttpCacheType-enum">QQuickWebEngineProfile::<wbr/>DiskHttpCache</a></code></p>
         */
        DiskHttpCache(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#HttpCacheType-enum">QQuickWebEngineProfile::<wbr/>NoCache</a></code></p>
         */
        NoCache(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HttpCacheType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HttpCacheType resolve(int value) {
            switch (value) {
            case 0: return MemoryHttpCache;
            case 1: return DiskHttpCache;
            case 2: return NoCache;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#PersistentCookiesPolicy-enum">QQuickWebEngineProfile::PersistentCookiesPolicy</a></code></p>
     */
    public enum PersistentCookiesPolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#PersistentCookiesPolicy-enum">QQuickWebEngineProfile::<wbr/>NoPersistentCookies</a></code></p>
         */
        NoPersistentCookies(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#PersistentCookiesPolicy-enum">QQuickWebEngineProfile::<wbr/>AllowPersistentCookies</a></code></p>
         */
        AllowPersistentCookies(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#PersistentCookiesPolicy-enum">QQuickWebEngineProfile::<wbr/>ForcePersistentCookies</a></code></p>
         */
        ForcePersistentCookies(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PersistentCookiesPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PersistentCookiesPolicy resolve(int value) {
            switch (value) {
            case 0: return NoPersistentCookies;
            case 1: return AllowPersistentCookies;
            case 2: return ForcePersistentCookies;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cachePath-prop">QQuickWebEngineProfile::<wbr/>cachePathChanged()</a></code></p>
     */
    @QtPropertyNotify(name="cachePath")
    public final @NonNull Signal0 cachePathChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadFinished">QQuickWebEngineProfile::<wbr/>downloadFinished(QQuickWebEngineDownloadItem*)</a></code></p>
     */
    public final @NonNull PrivateSignal1<? extends io.qt.core.@Nullable QObject> downloadFinished = new PrivateSignal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadPath-prop">QQuickWebEngineProfile::<wbr/>downloadPathChanged()</a></code></p>
     */
    @QtPropertyNotify(name="downloadPath")
    public final @NonNull Signal0 downloadPathChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadRequested">QQuickWebEngineProfile::<wbr/>downloadRequested(QQuickWebEngineDownloadItem*)</a></code></p>
     */
    public final @NonNull PrivateSignal1<? extends io.qt.core.@Nullable QObject> downloadRequested = new PrivateSignal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpAcceptLanguage-prop">QQuickWebEngineProfile::<wbr/>httpAcceptLanguageChanged()</a></code></p>
     */
    @QtPropertyNotify(name="httpAcceptLanguage")
    public final @NonNull Signal0 httpAcceptLanguageChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheMaximumSize-prop">QQuickWebEngineProfile::<wbr/>httpCacheMaximumSizeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="httpCacheMaximumSize")
    public final @NonNull Signal0 httpCacheMaximumSizeChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheType-prop">QQuickWebEngineProfile::<wbr/>httpCacheTypeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="httpCacheType")
    public final @NonNull Signal0 httpCacheTypeChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpUserAgent-prop">QQuickWebEngineProfile::<wbr/>httpUserAgentChanged()</a></code></p>
     */
    @QtPropertyNotify(name="httpUserAgent")
    public final @NonNull Signal0 httpUserAgentChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#offTheRecord-prop">QQuickWebEngineProfile::<wbr/>offTheRecordChanged()</a></code></p>
     */
    @QtPropertyNotify(name="offTheRecord")
    public final @NonNull Signal0 offTheRecordChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentCookiesPolicy-prop">QQuickWebEngineProfile::<wbr/>persistentCookiesPolicyChanged()</a></code></p>
     */
    @QtPropertyNotify(name="persistentCookiesPolicy")
    public final @NonNull Signal0 persistentCookiesPolicyChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentStoragePath-prop">QQuickWebEngineProfile::<wbr/>persistentStoragePathChanged()</a></code></p>
     */
    @QtPropertyNotify(name="persistentStoragePath")
    public final @NonNull Signal0 persistentStoragePathChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#presentNotification">QQuickWebEngineProfile::<wbr/>presentNotification(QWebEngineNotification*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.webengine.core.@Nullable QWebEngineNotification> presentNotification = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckEnabled-prop">QQuickWebEngineProfile::<wbr/>spellCheckEnabledChanged()</a></code></p>
     */
    @QtPropertyNotify(name="spellCheckEnabled")
    public final @NonNull Signal0 spellCheckEnabledChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckLanguages-prop">QQuickWebEngineProfile::<wbr/>spellCheckLanguagesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="spellCheckLanguages")
    public final @NonNull Signal0 spellCheckLanguagesChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#storageName-prop">QQuickWebEngineProfile::<wbr/>storageNameChanged()</a></code></p>
     */
    @QtPropertyNotify(name="storageName")
    public final @NonNull Signal0 storageNameChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#useForGlobalCertificateVerification-prop">QQuickWebEngineProfile::<wbr/>useForGlobalCertificateVerificationChanged()</a></code></p>
     */
    @QtPropertyNotify(name="useForGlobalCertificateVerification")
    public final @NonNull Signal0 useForGlobalCertificateVerificationChanged = new Signal0();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#QQuickWebEngineProfile">QQuickWebEngineProfile::<wbr/>QQuickWebEngineProfile(QObject*)</a></code></p>
     */
    public QQuickWebEngineProfile(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickWebEngineProfile instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cachePath-prop">QQuickWebEngineProfile::<wbr/>cachePath()const</a></code></p>
     */
    @QtPropertyReader(name="cachePath")
    @QtUninvokable
    public final java.lang.@NonNull String cachePath(){
        return cachePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String cachePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#clearHttpCache">QQuickWebEngineProfile::<wbr/>clearHttpCache()</a></code></p>
     */
    public final void clearHttpCache(){
        clearHttpCache_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clearHttpCache_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#clientCertificateStore">QQuickWebEngineProfile::<wbr/>clientCertificateStore()</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineClientCertificateStore clientCertificateStore(){
        return clientCertificateStore_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineClientCertificateStore clientCertificateStore_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cookieStore">QQuickWebEngineProfile::<wbr/>cookieStore()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineCookieStore cookieStore(){
        return cookieStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineCookieStore cookieStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadPath-prop">QQuickWebEngineProfile::<wbr/>downloadPath()const</a></code></p>
     */
    @QtPropertyReader(name="downloadPath")
    @QtUninvokable
    public final java.lang.@NonNull String downloadPath(){
        return downloadPath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadPath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpAcceptLanguage-prop">QQuickWebEngineProfile::<wbr/>httpAcceptLanguage()const</a></code></p>
     */
    @QtPropertyReader(name="httpAcceptLanguage")
    @QtUninvokable
    public final java.lang.@NonNull String httpAcceptLanguage(){
        return httpAcceptLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String httpAcceptLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheMaximumSize-prop">QQuickWebEngineProfile::<wbr/>httpCacheMaximumSize()const</a></code></p>
     */
    @QtPropertyReader(name="httpCacheMaximumSize")
    @QtUninvokable
    public final int httpCacheMaximumSize(){
        return httpCacheMaximumSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int httpCacheMaximumSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheType-prop">QQuickWebEngineProfile::<wbr/>httpCacheType()const</a></code></p>
     */
    @QtPropertyReader(name="httpCacheType")
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineProfile.@NonNull HttpCacheType httpCacheType(){
        return io.qt.webengine.QQuickWebEngineProfile.HttpCacheType.resolve(httpCacheType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int httpCacheType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpUserAgent-prop">QQuickWebEngineProfile::<wbr/>httpUserAgent()const</a></code></p>
     */
    @QtPropertyReader(name="httpUserAgent")
    @QtUninvokable
    public final java.lang.@NonNull String httpUserAgent(){
        return httpUserAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String httpUserAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#installUrlSchemeHandler">QQuickWebEngineProfile::<wbr/>installUrlSchemeHandler(QByteArray,<wbr/>QWebEngineUrlSchemeHandler*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void installUrlSchemeHandler(io.qt.core.@NonNull QByteArray scheme, io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler arg__2){
        installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        if (arg__2 != null) {
            if(__rcUrlSchemeHandler==null)
                __rcUrlSchemeHandler = QtJambi_LibraryUtilities.internal.newRCList();
            __rcUrlSchemeHandler.add(arg__2);
        }
    }
    
    @QtUninvokable
    private native void installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long scheme, long arg__2);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#offTheRecord-prop">QQuickWebEngineProfile::<wbr/>isOffTheRecord()const</a></code></p>
     */
    @QtPropertyReader(name="offTheRecord")
    @QtUninvokable
    public final boolean isOffTheRecord(){
        return isOffTheRecord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOffTheRecord_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckEnabled-prop">QQuickWebEngineProfile::<wbr/>isSpellCheckEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="spellCheckEnabled")
    @QtUninvokable
    public final boolean isSpellCheckEnabled(){
        return isSpellCheckEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSpellCheckEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#useForGlobalCertificateVerification-prop">QQuickWebEngineProfile::<wbr/>isUsedForGlobalCertificateVerification()const</a></code></p>
     */
    @QtPropertyReader(name="useForGlobalCertificateVerification")
    @QtUninvokable
    public final boolean isUsedForGlobalCertificateVerification(){
        return isUsedForGlobalCertificateVerification_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isUsedForGlobalCertificateVerification_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentCookiesPolicy-prop">QQuickWebEngineProfile::<wbr/>persistentCookiesPolicy()const</a></code></p>
     */
    @QtPropertyReader(name="persistentCookiesPolicy")
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineProfile.@NonNull PersistentCookiesPolicy persistentCookiesPolicy(){
        return io.qt.webengine.QQuickWebEngineProfile.PersistentCookiesPolicy.resolve(persistentCookiesPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int persistentCookiesPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentStoragePath-prop">QQuickWebEngineProfile::<wbr/>persistentStoragePath()const</a></code></p>
     */
    @QtPropertyReader(name="persistentStoragePath")
    @QtUninvokable
    public final java.lang.@NonNull String persistentStoragePath(){
        return persistentStoragePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String persistentStoragePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#removeAllUrlSchemeHandlers">QQuickWebEngineProfile::<wbr/>removeAllUrlSchemeHandlers()</a></code></p>
     */
    @QtUninvokable
    public final void removeAllUrlSchemeHandlers(){
        removeAllUrlSchemeHandlers_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void removeAllUrlSchemeHandlers_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#removeUrlScheme">QQuickWebEngineProfile::<wbr/>removeUrlScheme(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void removeUrlScheme(io.qt.core.@NonNull QByteArray scheme){
        removeUrlScheme_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme));
    }
    
    @QtUninvokable
    private native void removeUrlScheme_native_cref_QByteArray(long __this__nativeId, long scheme);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#removeUrlSchemeHandler">QQuickWebEngineProfile::<wbr/>removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void removeUrlSchemeHandler(io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler arg__1){
        removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        if (arg__1 != null) {
            while (__rcUrlSchemeHandler != null && __rcUrlSchemeHandler.remove(arg__1)) ;
        }
    }
    
    @QtUninvokable
    private native void removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cachePath-prop">QQuickWebEngineProfile::<wbr/>setCachePath(QString)</a></code></p>
     */
    @QtPropertyWriter(name="cachePath")
    @QtUninvokable
    public final void setCachePath(java.lang.@NonNull String path){
        setCachePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setCachePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadPath-prop">QQuickWebEngineProfile::<wbr/>setDownloadPath(QString)</a></code></p>
     */
    @QtPropertyWriter(name="downloadPath")
    @QtUninvokable
    public final void setDownloadPath(java.lang.@NonNull String path){
        setDownloadPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setDownloadPath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpAcceptLanguage-prop">QQuickWebEngineProfile::<wbr/>setHttpAcceptLanguage(QString)</a></code></p>
     */
    @QtPropertyWriter(name="httpAcceptLanguage")
    @QtUninvokable
    public final void setHttpAcceptLanguage(java.lang.@NonNull String httpAcceptLanguage){
        setHttpAcceptLanguage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), httpAcceptLanguage);
    }
    
    @QtUninvokable
    private native void setHttpAcceptLanguage_native_cref_QString(long __this__nativeId, java.lang.String httpAcceptLanguage);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheMaximumSize-prop">QQuickWebEngineProfile::<wbr/>setHttpCacheMaximumSize(int)</a></code></p>
     */
    @QtPropertyWriter(name="httpCacheMaximumSize")
    @QtUninvokable
    public final void setHttpCacheMaximumSize(int maxSize){
        setHttpCacheMaximumSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxSize);
    }
    
    @QtUninvokable
    private native void setHttpCacheMaximumSize_native_int(long __this__nativeId, int maxSize);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheType-prop">QQuickWebEngineProfile::<wbr/>setHttpCacheType(QQuickWebEngineProfile::HttpCacheType)</a></code></p>
     */
    @QtPropertyWriter(name="httpCacheType")
    @QtUninvokable
    public final void setHttpCacheType(io.qt.webengine.QQuickWebEngineProfile.@NonNull HttpCacheType arg__1){
        setHttpCacheType_native_QQuickWebEngineProfile_HttpCacheType(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setHttpCacheType_native_QQuickWebEngineProfile_HttpCacheType(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpUserAgent-prop">QQuickWebEngineProfile::<wbr/>setHttpUserAgent(QString)</a></code></p>
     */
    @QtPropertyWriter(name="httpUserAgent")
    @QtUninvokable
    public final void setHttpUserAgent(java.lang.@NonNull String userAgent){
        setHttpUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @QtUninvokable
    private native void setHttpUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#offTheRecord-prop">QQuickWebEngineProfile::<wbr/>setOffTheRecord(bool)</a></code></p>
     */
    @QtPropertyWriter(name="offTheRecord")
    @QtUninvokable
    public final void setOffTheRecord(boolean offTheRecord){
        setOffTheRecord_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), offTheRecord);
    }
    
    @QtUninvokable
    private native void setOffTheRecord_native_bool(long __this__nativeId, boolean offTheRecord);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentCookiesPolicy-prop">QQuickWebEngineProfile::<wbr/>setPersistentCookiesPolicy(QQuickWebEngineProfile::PersistentCookiesPolicy)</a></code></p>
     */
    @QtPropertyWriter(name="persistentCookiesPolicy")
    @QtUninvokable
    public final void setPersistentCookiesPolicy(io.qt.webengine.QQuickWebEngineProfile.@NonNull PersistentCookiesPolicy arg__1){
        setPersistentCookiesPolicy_native_QQuickWebEngineProfile_PersistentCookiesPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setPersistentCookiesPolicy_native_QQuickWebEngineProfile_PersistentCookiesPolicy(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentStoragePath-prop">QQuickWebEngineProfile::<wbr/>setPersistentStoragePath(QString)</a></code></p>
     */
    @QtPropertyWriter(name="persistentStoragePath")
    @QtUninvokable
    public final void setPersistentStoragePath(java.lang.@NonNull String path){
        setPersistentStoragePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setPersistentStoragePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile-obsolete.html#setRequestInterceptor">QQuickWebEngineProfile::<wbr/>setRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setRequestInterceptor(io.qt.webengine.core.@Nullable QWebEngineUrlRequestInterceptor interceptor){
        setRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @QtUninvokable
    private native void setRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckEnabled-prop">QQuickWebEngineProfile::<wbr/>setSpellCheckEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="spellCheckEnabled")
    @QtUninvokable
    public final void setSpellCheckEnabled(boolean enabled){
        setSpellCheckEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setSpellCheckEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckLanguages-prop">QQuickWebEngineProfile::<wbr/>setSpellCheckLanguages(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="spellCheckLanguages")
    @QtUninvokable
    public final void setSpellCheckLanguages(java.util.@NonNull Collection<java.lang.@NonNull String> languages){
        setSpellCheckLanguages_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), languages);
    }
    
    @QtUninvokable
    private native void setSpellCheckLanguages_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> languages);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#storageName-prop">QQuickWebEngineProfile::<wbr/>setStorageName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="storageName")
    @QtUninvokable
    public final void setStorageName(java.lang.@NonNull String name){
        setStorageName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setStorageName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#setUrlRequestInterceptor">QQuickWebEngineProfile::<wbr/>setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.@Nullable QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#useForGlobalCertificateVerification-prop">QQuickWebEngineProfile::<wbr/>setUseForGlobalCertificateVerification(bool)</a></code></p>
     */
    @QtPropertyWriter(name="useForGlobalCertificateVerification")
    @QtUninvokable
    public final void setUseForGlobalCertificateVerification(boolean b){
        setUseForGlobalCertificateVerification_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), b);
    }
    
    @QtUninvokable
    private native void setUseForGlobalCertificateVerification_native_bool(long __this__nativeId, boolean b);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckLanguages">QQuickWebEngineProfile::<wbr/>spellCheckLanguages()const</a></code></p>
     */
    @QtPropertyReader(name="spellCheckLanguages")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList spellCheckLanguages(){
        return spellCheckLanguages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList spellCheckLanguages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#storageName-prop">QQuickWebEngineProfile::<wbr/>storageName()const</a></code></p>
     */
    @QtPropertyReader(name="storageName")
    @QtUninvokable
    public final java.lang.@NonNull String storageName(){
        return storageName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String storageName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#urlSchemeHandler">QQuickWebEngineProfile::<wbr/>urlSchemeHandler(QByteArray)const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler urlSchemeHandler(io.qt.core.@NonNull QByteArray arg__1){
        return urlSchemeHandler_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineUrlSchemeHandler urlSchemeHandler_native_cref_QByteArray_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#userScripts-prop">QQuickWebEngineProfile::<wbr/>userScripts()</a></code></p>
     */
    @QtPropertyReader(name="userScripts")
    @QtUninvokable
    public final io.qt.qml.@NonNull QQmlListProperty<io.qt.webengine.@NonNull QQuickWebEngineScript> userScripts(){
        return userScripts_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qml.QQmlListProperty<io.qt.webengine.QQuickWebEngineScript> userScripts_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#defaultProfile">QQuickWebEngineProfile::<wbr/>defaultProfile()</a></code></p>
     */
    public native static io.qt.webengine.@Nullable QQuickWebEngineProfile defaultProfile();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QQuickWebEngineProfile(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QQuickWebEngineProfile(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QQuickWebEngineProfile instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWebEngineProfile(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWebEngineProfile() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #cachePath()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getCachePath() {
        return cachePath();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #downloadPath()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDownloadPath() {
        return downloadPath();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #httpAcceptLanguage()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getHttpAcceptLanguage() {
        return httpAcceptLanguage();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #httpCacheMaximumSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getHttpCacheMaximumSize() {
        return httpCacheMaximumSize();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #httpCacheType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineProfile.@NonNull HttpCacheType getHttpCacheType() {
        return httpCacheType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #httpUserAgent()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getHttpUserAgent() {
        return httpUserAgent();
    }
    
    /**
     * <p>Overloaded function for {@link #installUrlSchemeHandler(io.qt.core.QByteArray, io.qt.webengine.core.QWebEngineUrlSchemeHandler)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void installUrlSchemeHandler(byte @NonNull[] scheme, io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler arg__2) {
        installUrlSchemeHandler(new io.qt.core.QByteArray(scheme), arg__2);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isOffTheRecord()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getOffTheRecord() {
        return isOffTheRecord();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isSpellCheckEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSpellCheckEnabled() {
        return isSpellCheckEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isUsedForGlobalCertificateVerification()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUseForGlobalCertificateVerification() {
        return isUsedForGlobalCertificateVerification();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #persistentCookiesPolicy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineProfile.@NonNull PersistentCookiesPolicy getPersistentCookiesPolicy() {
        return persistentCookiesPolicy();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #persistentStoragePath()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getPersistentStoragePath() {
        return persistentStoragePath();
    }
    
    /**
     * <p>Overloaded function for {@link #removeUrlScheme(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void removeUrlScheme(byte @NonNull[] scheme) {
        removeUrlScheme(new io.qt.core.QByteArray(scheme));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #spellCheckLanguages()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getSpellCheckLanguages() {
        return spellCheckLanguages();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #storageName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getStorageName() {
        return storageName();
    }
    
    /**
     * <p>Overloaded function for {@link #urlSchemeHandler(io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler urlSchemeHandler(byte @NonNull[] arg__1) {
        return urlSchemeHandler(new io.qt.core.QByteArray(arg__1));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #userScripts()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qml.@NonNull QQmlListProperty<io.qt.webengine.@NonNull QQuickWebEngineScript> getUserScripts() {
        return userScripts();
    }
}
