package io.qt.webengine;

import io.qt.*;


/**
 * <p>Enables the injection of scripts in the JavaScript engine</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html">QQuickWebEngineScript</a></code></p>
 */
public class QQuickWebEngineScript extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickWebEngineScript.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#InjectionPoint-enum">QQuickWebEngineScript::InjectionPoint</a></code></p>
     */
    public enum InjectionPoint implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#InjectionPoint-enum">QQuickWebEngineScript::<wbr/>Deferred</a></code></p>
         */
        Deferred(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#InjectionPoint-enum">QQuickWebEngineScript::<wbr/>DocumentReady</a></code></p>
         */
        DocumentReady(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#InjectionPoint-enum">QQuickWebEngineScript::<wbr/>DocumentCreation</a></code></p>
         */
        DocumentCreation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private InjectionPoint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull InjectionPoint resolve(int value) {
            switch (value) {
            case 0: return Deferred;
            case 1: return DocumentReady;
            case 2: return DocumentCreation;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#ScriptWorldId-enum">QQuickWebEngineScript::ScriptWorldId</a></code></p>
     */
    public enum ScriptWorldId implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#ScriptWorldId-enum">QQuickWebEngineScript::<wbr/>MainWorld</a></code></p>
         */
        MainWorld(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#ScriptWorldId-enum">QQuickWebEngineScript::<wbr/>ApplicationWorld</a></code></p>
         */
        ApplicationWorld(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#ScriptWorldId-enum">QQuickWebEngineScript::<wbr/>UserWorld</a></code></p>
         */
        UserWorld(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ScriptWorldId(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ScriptWorldId resolve(int value) {
            switch (value) {
            case 0: return MainWorld;
            case 1: return ApplicationWorld;
            case 2: return UserWorld;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#injectionPoint-prop">QQuickWebEngineScript::<wbr/>injectionPointChanged(QQuickWebEngineScript::InjectionPoint)</a></code></p>
     */
    @QtPropertyNotify(name="injectionPoint")
    public final @NonNull Signal1<io.qt.webengine.QQuickWebEngineScript.@NonNull InjectionPoint> injectionPointChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#name-prop">QQuickWebEngineScript::<wbr/>nameChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="name")
    public final @NonNull Signal1<java.lang.@NonNull String> nameChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#runOnSubframes-prop">QQuickWebEngineScript::<wbr/>runOnSubframesChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="runOnSubframes")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> runOnSubframesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceCode-prop">QQuickWebEngineScript::<wbr/>sourceCodeChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="sourceCode")
    public final @NonNull Signal1<java.lang.@NonNull String> sourceCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceUrl-prop">QQuickWebEngineScript::<wbr/>sourceUrlChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="sourceUrl")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceUrlChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#worldId-prop">QQuickWebEngineScript::<wbr/>worldIdChanged(QQuickWebEngineScript::ScriptWorldId)</a></code></p>
     */
    @QtPropertyNotify(name="worldId")
    public final @NonNull Signal1<io.qt.webengine.QQuickWebEngineScript.@NonNull ScriptWorldId> worldIdChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#QQuickWebEngineScript">QQuickWebEngineScript::<wbr/>QQuickWebEngineScript(QObject*)</a></code></p>
     */
    public QQuickWebEngineScript(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickWebEngineScript instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#injectionPoint-prop">QQuickWebEngineScript::<wbr/>injectionPoint()const</a></code></p>
     */
    @QtPropertyReader(name="injectionPoint")
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineScript.@NonNull InjectionPoint injectionPoint(){
        return io.qt.webengine.QQuickWebEngineScript.InjectionPoint.resolve(injectionPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int injectionPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#name-prop">QQuickWebEngineScript::<wbr/>name()const</a></code></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#runOnSubframes-prop">QQuickWebEngineScript::<wbr/>runOnSubframes()const</a></code></p>
     */
    @QtPropertyReader(name="runOnSubframes")
    @QtUninvokable
    public final boolean runOnSubframes(){
        return runOnSubframes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean runOnSubframes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#injectionPoint-prop">QQuickWebEngineScript::<wbr/>setInjectionPoint(QQuickWebEngineScript::InjectionPoint)</a></code></p>
     */
    @QtPropertyWriter(name="injectionPoint")
    public final void setInjectionPoint(io.qt.webengine.QQuickWebEngineScript.@NonNull InjectionPoint injectionPoint){
        setInjectionPoint_native_QQuickWebEngineScript_InjectionPoint(QtJambi_LibraryUtilities.internal.nativeId(this), injectionPoint.value());
    }
    
    private native void setInjectionPoint_native_QQuickWebEngineScript_InjectionPoint(long __this__nativeId, int injectionPoint);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#name-prop">QQuickWebEngineScript::<wbr/>setName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="name")
    public final void setName(java.lang.@NonNull String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#runOnSubframes-prop">QQuickWebEngineScript::<wbr/>setRunOnSubframes(bool)</a></code></p>
     */
    @QtPropertyWriter(name="runOnSubframes")
    public final void setRunOnSubframes(boolean on){
        setRunOnSubframes_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    private native void setRunOnSubframes_native_bool(long __this__nativeId, boolean on);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceCode-prop">QQuickWebEngineScript::<wbr/>setSourceCode(QString)</a></code></p>
     */
    @QtPropertyWriter(name="sourceCode")
    public final void setSourceCode(java.lang.@NonNull String code){
        setSourceCode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code);
    }
    
    private native void setSourceCode_native_cref_QString(long __this__nativeId, java.lang.String code);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceUrl-prop">QQuickWebEngineScript::<wbr/>setSourceUrl(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="sourceUrl")
    public final void setSourceUrl(io.qt.core.@NonNull QUrl url){
        setSourceUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void setSourceUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#worldId-prop">QQuickWebEngineScript::<wbr/>setWorldId(QQuickWebEngineScript::ScriptWorldId)</a></code></p>
     */
    @QtPropertyWriter(name="worldId")
    public final void setWorldId(io.qt.webengine.QQuickWebEngineScript.@NonNull ScriptWorldId scriptWorldId){
        setWorldId_native_QQuickWebEngineScript_ScriptWorldId(QtJambi_LibraryUtilities.internal.nativeId(this), scriptWorldId.value());
    }
    
    private native void setWorldId_native_QQuickWebEngineScript_ScriptWorldId(long __this__nativeId, int scriptWorldId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceCode-prop">QQuickWebEngineScript::<wbr/>sourceCode()const</a></code></p>
     */
    @QtPropertyReader(name="sourceCode")
    @QtUninvokable
    public final java.lang.@NonNull String sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceUrl-prop">QQuickWebEngineScript::<wbr/>sourceUrl()const</a></code></p>
     */
    @QtPropertyReader(name="sourceUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl sourceUrl(){
        return sourceUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl sourceUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#toString">QQuickWebEngineScript::<wbr/>toString()const</a></code></p>
     */
    public final java.lang.@NonNull String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#worldId-prop">QQuickWebEngineScript::<wbr/>worldId()const</a></code></p>
     */
    @QtPropertyReader(name="worldId")
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineScript.@NonNull ScriptWorldId worldId(){
        return io.qt.webengine.QQuickWebEngineScript.ScriptWorldId.resolve(worldId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int worldId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qobject.html#timerEvent">QObject::<wbr/>timerEvent(QTimerEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    protected void timerEvent(io.qt.core.@Nullable QTimerEvent e){
        timerEvent_native_QTimerEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void timerEvent_native_QTimerEvent_ptr(long __this__nativeId, long e);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QQuickWebEngineScript(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QQuickWebEngineScript(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QQuickWebEngineScript instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWebEngineScript(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWebEngineScript() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #injectionPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineScript.@NonNull InjectionPoint getInjectionPoint() {
        return injectionPoint();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #runOnSubframes()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRunOnSubframes() {
        return runOnSubframes();
    }
    
    /**
     * <p>Overloaded function for {@link #setSourceUrl(io.qt.core.QUrl)}.</p>
     */
    public final void setSourceUrl(java.lang.@NonNull String url) {
        setSourceUrl(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sourceCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSourceCode() {
        return sourceCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sourceUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSourceUrl() {
        return sourceUrl();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #worldId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.QQuickWebEngineScript.@NonNull ScriptWorldId getWorldId() {
        return worldId();
    }
}
