/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.lambda.deployment;

import io.quarkiverse.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkiverse.amazon.lambda.runtime.LambdaBuildTimeConfig;
import io.quarkiverse.amazon.lambda.runtime.LambdaRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;

public class LambdaProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sdk-lambda";
    LambdaBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "lambda";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)LambdaClient.class.getName());
    }

    protected Class<?> syncClientBuilderClass() {
        return LambdaClientBuilder.class;
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)LambdaAsyncClient.class.getName());
    }

    protected Class<?> asyncClientBuilderClass() {
        return LambdaAsyncClientBuilder.class;
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/lambda/execution.interceptors";
    }

    protected HasTransportBuildTimeConfig transportBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    protected HasSdkBuildTimeConfig sdkBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBuilders(LambdaRecorder recorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, BuildProducer<AmazonClientExtensionBuilderInstanceBuildItem> builderIstances) {
        this.createExtensionBuilders((AmazonClientRecorder)recorder, amazonClientInjections, builderIstances);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setup(LambdaRecorder recorder, BuildProducer<AmazonClientExtensionBuildItem> amazonExtensions) {
        this.setupExtension((AmazonClientRecorder)recorder, amazonExtensions);
    }
}

