/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.ArgoCDSpecBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.ApplicationSet;
import io.quarkiverse.argocd.v1beta1.argocdspec.Banner;
import io.quarkiverse.argocd.v1beta1.argocdspec.Controller;
import io.quarkiverse.argocd.v1beta1.argocdspec.Grafana;
import io.quarkiverse.argocd.v1beta1.argocdspec.Ha;
import io.quarkiverse.argocd.v1beta1.argocdspec.Import;
import io.quarkiverse.argocd.v1beta1.argocdspec.InitialSSHKnownHosts;
import io.quarkiverse.argocd.v1beta1.argocdspec.KustomizeVersions;
import io.quarkiverse.argocd.v1beta1.argocdspec.Monitoring;
import io.quarkiverse.argocd.v1beta1.argocdspec.NodePlacement;
import io.quarkiverse.argocd.v1beta1.argocdspec.Notifications;
import io.quarkiverse.argocd.v1beta1.argocdspec.Prometheus;
import io.quarkiverse.argocd.v1beta1.argocdspec.Rbac;
import io.quarkiverse.argocd.v1beta1.argocdspec.Redis;
import io.quarkiverse.argocd.v1beta1.argocdspec.Repo;
import io.quarkiverse.argocd.v1beta1.argocdspec.ResourceActions;
import io.quarkiverse.argocd.v1beta1.argocdspec.ResourceHealthChecks;
import io.quarkiverse.argocd.v1beta1.argocdspec.ResourceIgnoreDifferences;
import io.quarkiverse.argocd.v1beta1.argocdspec.Server;
import io.quarkiverse.argocd.v1beta1.argocdspec.Sso;
import io.quarkiverse.argocd.v1beta1.argocdspec.Tls;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"applicationInstanceLabelKey", "applicationSet", "banner", "configManagementPlugins", "controller", "defaultClusterScopedRoleDisabled", "disableAdmin", "extraConfig", "gaAnonymizeUsers", "gaTrackingID", "grafana", "ha", "helpChatText", "helpChatURL", "image", "import", "initialRepositories", "initialSSHKnownHosts", "kustomizeBuildOptions", "kustomizeVersions", "monitoring", "nodePlacement", "notifications", "oidcConfig", "prometheus", "rbac", "redis", "repo", "repositoryCredentials", "resourceActions", "resourceExclusions", "resourceHealthChecks", "resourceIgnoreDifferences", "resourceInclusions", "resourceTrackingMethod", "server", "sourceNamespaces", "sso", "statusBadgeEnabled", "tls", "usersAnonymousEnabled", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ArgoCDSpec
implements Editable<ArgoCDSpecBuilder>,
KubernetesResource {
    @JsonProperty(value="applicationInstanceLabelKey")
    @JsonPropertyDescription(value="ApplicationInstanceLabelKey is the key name where Argo CD injects the app name as a tracking label.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String applicationInstanceLabelKey;
    @JsonProperty(value="applicationSet")
    @JsonPropertyDescription(value="ArgoCDApplicationSet defines whether the Argo CD ApplicationSet controller should be installed.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ApplicationSet applicationSet;
    @JsonProperty(value="banner")
    @JsonPropertyDescription(value="Banner defines an additional banner to be displayed in Argo CD UI")
    @JsonSetter(nulls=Nulls.SKIP)
    private Banner banner;
    @JsonProperty(value="configManagementPlugins")
    @JsonPropertyDescription(value="ConfigManagementPlugins is used to specify additional config management plugins.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String configManagementPlugins;
    @JsonProperty(value="controller")
    @JsonPropertyDescription(value="Controller defines the Application Controller options for ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Controller controller;
    @JsonProperty(value="defaultClusterScopedRoleDisabled")
    @JsonPropertyDescription(value="DefaultClusterScopedRoleDisabled will disable creation of default ClusterRoles for a cluster scoped instance.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean defaultClusterScopedRoleDisabled;
    @JsonProperty(value="disableAdmin")
    @JsonPropertyDescription(value="DisableAdmin will disable the admin user.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean disableAdmin;
    @JsonProperty(value="extraConfig")
    @JsonPropertyDescription(value="ExtraConfig can be used to add fields to Argo CD configmap that are not supported by Argo CD CRD. \n Note: ExtraConfig takes precedence over Argo CD CRD. For example, A user sets `argocd.Spec.DisableAdmin` = true and also `a.Spec.ExtraConfig[\"admin.enabled\"]` = true. In this case, operator updates Argo CD Configmap as follows -> argocd-cm.Data[\"admin.enabled\"] = true.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> extraConfig;
    @JsonProperty(value="gaAnonymizeUsers")
    @JsonPropertyDescription(value="GAAnonymizeUsers toggles user IDs being hashed before sending to google analytics.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean gaAnonymizeUsers;
    @JsonProperty(value="gaTrackingID")
    @JsonPropertyDescription(value="GATrackingID is the google analytics tracking ID to use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String gaTrackingID;
    @JsonProperty(value="grafana")
    @JsonPropertyDescription(value="Deprecated: Grafana defines the Grafana server options for ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Grafana grafana;
    @JsonProperty(value="ha")
    @JsonPropertyDescription(value="HA options for High Availability support for the Redis component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Ha ha;
    @JsonProperty(value="helpChatText")
    @JsonPropertyDescription(value="HelpChatText is the text for getting chat help, defaults to \"Chat now!\"")
    @JsonSetter(nulls=Nulls.SKIP)
    private String helpChatText;
    @JsonProperty(value="helpChatURL")
    @JsonPropertyDescription(value="HelpChatURL is the URL for getting chat help, this will typically be your Slack channel for support.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String helpChatURL;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Image is the ArgoCD container image for all ArgoCD components.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="import")
    @JsonPropertyDescription(value="Import is the import/restore options for ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Import _import;
    @JsonProperty(value="initialRepositories")
    @JsonPropertyDescription(value="InitialRepositories to configure Argo CD with upon creation of the cluster.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String initialRepositories;
    @JsonProperty(value="initialSSHKnownHosts")
    @JsonPropertyDescription(value="InitialSSHKnownHosts defines the SSH known hosts data upon creation of the cluster for connecting Git repositories via SSH.")
    @JsonSetter(nulls=Nulls.SKIP)
    private InitialSSHKnownHosts initialSSHKnownHosts;
    @JsonProperty(value="kustomizeBuildOptions")
    @JsonPropertyDescription(value="KustomizeBuildOptions is used to specify build options/parameters to use with `kustomize build`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String kustomizeBuildOptions;
    @JsonProperty(value="kustomizeVersions")
    @JsonPropertyDescription(value="KustomizeVersions is a listing of configured versions of Kustomize to be made available within ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<KustomizeVersions> kustomizeVersions;
    @JsonProperty(value="monitoring")
    @JsonPropertyDescription(value="Monitoring defines whether workload status monitoring configuration for this instance.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Monitoring monitoring;
    @JsonProperty(value="nodePlacement")
    @JsonPropertyDescription(value="NodePlacement defines NodeSelectors and Taints for Argo CD workloads")
    @JsonSetter(nulls=Nulls.SKIP)
    private NodePlacement nodePlacement;
    @JsonProperty(value="notifications")
    @JsonPropertyDescription(value="Notifications defines whether the Argo CD Notifications controller should be installed.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Notifications notifications;
    @JsonProperty(value="oidcConfig")
    @JsonPropertyDescription(value="OIDCConfig is the OIDC configuration as an alternative to dex.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String oidcConfig;
    @JsonProperty(value="prometheus")
    @JsonPropertyDescription(value="Prometheus defines the Prometheus server options for ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Prometheus prometheus;
    @JsonProperty(value="rbac")
    @JsonPropertyDescription(value="RBAC defines the RBAC configuration for Argo CD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Rbac rbac;
    @JsonProperty(value="redis")
    @JsonPropertyDescription(value="Redis defines the Redis server options for ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Redis redis;
    @JsonProperty(value="repo")
    @JsonPropertyDescription(value="Repo defines the repo server options for Argo CD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Repo repo;
    @JsonProperty(value="repositoryCredentials")
    @JsonPropertyDescription(value="RepositoryCredentials are the Git pull credentials to configure Argo CD with upon creation of the cluster.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String repositoryCredentials;
    @JsonProperty(value="resourceActions")
    @JsonPropertyDescription(value="ResourceActions customizes resource action behavior.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<ResourceActions> resourceActions;
    @JsonProperty(value="resourceExclusions")
    @JsonPropertyDescription(value="ResourceExclusions is used to completely ignore entire classes of resource group/kinds.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String resourceExclusions;
    @JsonProperty(value="resourceHealthChecks")
    @JsonPropertyDescription(value="ResourceHealthChecks customizes resource health check behavior.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<ResourceHealthChecks> resourceHealthChecks;
    @JsonProperty(value="resourceIgnoreDifferences")
    @JsonPropertyDescription(value="ResourceIgnoreDifferences customizes resource ignore difference behavior.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ResourceIgnoreDifferences resourceIgnoreDifferences;
    @JsonProperty(value="resourceInclusions")
    @JsonPropertyDescription(value="ResourceInclusions is used to only include specific group/kinds in the reconciliation process.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String resourceInclusions;
    @JsonProperty(value="resourceTrackingMethod")
    @JsonPropertyDescription(value="ResourceTrackingMethod defines how Argo CD should track resources that it manages")
    @JsonSetter(nulls=Nulls.SKIP)
    private String resourceTrackingMethod;
    @JsonProperty(value="server")
    @JsonPropertyDescription(value="Server defines the options for the ArgoCD Server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Server server;
    @JsonProperty(value="sourceNamespaces")
    @JsonPropertyDescription(value="SourceNamespaces defines the namespaces application resources are allowed to be created in")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> sourceNamespaces;
    @JsonProperty(value="sso")
    @JsonPropertyDescription(value="SSO defines the Single Sign-on configuration for Argo CD")
    @JsonSetter(nulls=Nulls.SKIP)
    private Sso sso;
    @JsonProperty(value="statusBadgeEnabled")
    @JsonPropertyDescription(value="StatusBadgeEnabled toggles application status badge feature.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean statusBadgeEnabled;
    @JsonProperty(value="tls")
    @JsonPropertyDescription(value="TLS defines the TLS options for ArgoCD.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Tls tls;
    @JsonProperty(value="usersAnonymousEnabled")
    @JsonPropertyDescription(value="UsersAnonymousEnabled toggles anonymous user access. The anonymous users get default role permissions specified argocd-rbac-cm.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean usersAnonymousEnabled;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version is the tag to use with the ArgoCD container image for all ArgoCD components.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public ArgoCDSpecBuilder edit() {
        return new ArgoCDSpecBuilder(this);
    }

    public String getApplicationInstanceLabelKey() {
        return this.applicationInstanceLabelKey;
    }

    public void setApplicationInstanceLabelKey(String applicationInstanceLabelKey) {
        this.applicationInstanceLabelKey = applicationInstanceLabelKey;
    }

    public ApplicationSet getApplicationSet() {
        return this.applicationSet;
    }

    public void setApplicationSet(ApplicationSet applicationSet) {
        this.applicationSet = applicationSet;
    }

    public Banner getBanner() {
        return this.banner;
    }

    public void setBanner(Banner banner) {
        this.banner = banner;
    }

    public String getConfigManagementPlugins() {
        return this.configManagementPlugins;
    }

    public void setConfigManagementPlugins(String configManagementPlugins) {
        this.configManagementPlugins = configManagementPlugins;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Boolean getDefaultClusterScopedRoleDisabled() {
        return this.defaultClusterScopedRoleDisabled;
    }

    public void setDefaultClusterScopedRoleDisabled(Boolean defaultClusterScopedRoleDisabled) {
        this.defaultClusterScopedRoleDisabled = defaultClusterScopedRoleDisabled;
    }

    public Boolean getDisableAdmin() {
        return this.disableAdmin;
    }

    public void setDisableAdmin(Boolean disableAdmin) {
        this.disableAdmin = disableAdmin;
    }

    public Map<String, String> getExtraConfig() {
        return this.extraConfig;
    }

    public void setExtraConfig(Map<String, String> extraConfig) {
        this.extraConfig = extraConfig;
    }

    public Boolean getGaAnonymizeUsers() {
        return this.gaAnonymizeUsers;
    }

    public void setGaAnonymizeUsers(Boolean gaAnonymizeUsers) {
        this.gaAnonymizeUsers = gaAnonymizeUsers;
    }

    public String getGaTrackingID() {
        return this.gaTrackingID;
    }

    public void setGaTrackingID(String gaTrackingID) {
        this.gaTrackingID = gaTrackingID;
    }

    public Grafana getGrafana() {
        return this.grafana;
    }

    public void setGrafana(Grafana grafana) {
        this.grafana = grafana;
    }

    public Ha getHa() {
        return this.ha;
    }

    public void setHa(Ha ha) {
        this.ha = ha;
    }

    public String getHelpChatText() {
        return this.helpChatText;
    }

    public void setHelpChatText(String helpChatText) {
        this.helpChatText = helpChatText;
    }

    public String getHelpChatURL() {
        return this.helpChatURL;
    }

    public void setHelpChatURL(String helpChatURL) {
        this.helpChatURL = helpChatURL;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Import get_import() {
        return this._import;
    }

    public void set_import(Import _import) {
        this._import = _import;
    }

    public String getInitialRepositories() {
        return this.initialRepositories;
    }

    public void setInitialRepositories(String initialRepositories) {
        this.initialRepositories = initialRepositories;
    }

    public InitialSSHKnownHosts getInitialSSHKnownHosts() {
        return this.initialSSHKnownHosts;
    }

    public void setInitialSSHKnownHosts(InitialSSHKnownHosts initialSSHKnownHosts) {
        this.initialSSHKnownHosts = initialSSHKnownHosts;
    }

    public String getKustomizeBuildOptions() {
        return this.kustomizeBuildOptions;
    }

    public void setKustomizeBuildOptions(String kustomizeBuildOptions) {
        this.kustomizeBuildOptions = kustomizeBuildOptions;
    }

    public List<KustomizeVersions> getKustomizeVersions() {
        return this.kustomizeVersions;
    }

    public void setKustomizeVersions(List<KustomizeVersions> kustomizeVersions) {
        this.kustomizeVersions = kustomizeVersions;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public NodePlacement getNodePlacement() {
        return this.nodePlacement;
    }

    public void setNodePlacement(NodePlacement nodePlacement) {
        this.nodePlacement = nodePlacement;
    }

    public Notifications getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    public String getOidcConfig() {
        return this.oidcConfig;
    }

    public void setOidcConfig(String oidcConfig) {
        this.oidcConfig = oidcConfig;
    }

    public Prometheus getPrometheus() {
        return this.prometheus;
    }

    public void setPrometheus(Prometheus prometheus) {
        this.prometheus = prometheus;
    }

    public Rbac getRbac() {
        return this.rbac;
    }

    public void setRbac(Rbac rbac) {
        this.rbac = rbac;
    }

    public Redis getRedis() {
        return this.redis;
    }

    public void setRedis(Redis redis) {
        this.redis = redis;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public void setRepo(Repo repo) {
        this.repo = repo;
    }

    public String getRepositoryCredentials() {
        return this.repositoryCredentials;
    }

    public void setRepositoryCredentials(String repositoryCredentials) {
        this.repositoryCredentials = repositoryCredentials;
    }

    public List<ResourceActions> getResourceActions() {
        return this.resourceActions;
    }

    public void setResourceActions(List<ResourceActions> resourceActions) {
        this.resourceActions = resourceActions;
    }

    public String getResourceExclusions() {
        return this.resourceExclusions;
    }

    public void setResourceExclusions(String resourceExclusions) {
        this.resourceExclusions = resourceExclusions;
    }

    public List<ResourceHealthChecks> getResourceHealthChecks() {
        return this.resourceHealthChecks;
    }

    public void setResourceHealthChecks(List<ResourceHealthChecks> resourceHealthChecks) {
        this.resourceHealthChecks = resourceHealthChecks;
    }

    public ResourceIgnoreDifferences getResourceIgnoreDifferences() {
        return this.resourceIgnoreDifferences;
    }

    public void setResourceIgnoreDifferences(ResourceIgnoreDifferences resourceIgnoreDifferences) {
        this.resourceIgnoreDifferences = resourceIgnoreDifferences;
    }

    public String getResourceInclusions() {
        return this.resourceInclusions;
    }

    public void setResourceInclusions(String resourceInclusions) {
        this.resourceInclusions = resourceInclusions;
    }

    public String getResourceTrackingMethod() {
        return this.resourceTrackingMethod;
    }

    public void setResourceTrackingMethod(String resourceTrackingMethod) {
        this.resourceTrackingMethod = resourceTrackingMethod;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public List<String> getSourceNamespaces() {
        return this.sourceNamespaces;
    }

    public void setSourceNamespaces(List<String> sourceNamespaces) {
        this.sourceNamespaces = sourceNamespaces;
    }

    public Sso getSso() {
        return this.sso;
    }

    public void setSso(Sso sso) {
        this.sso = sso;
    }

    public Boolean getStatusBadgeEnabled() {
        return this.statusBadgeEnabled;
    }

    public void setStatusBadgeEnabled(Boolean statusBadgeEnabled) {
        this.statusBadgeEnabled = statusBadgeEnabled;
    }

    public Tls getTls() {
        return this.tls;
    }

    public void setTls(Tls tls) {
        this.tls = tls;
    }

    public Boolean getUsersAnonymousEnabled() {
        return this.usersAnonymousEnabled;
    }

    public void setUsersAnonymousEnabled(Boolean usersAnonymousEnabled) {
        this.usersAnonymousEnabled = usersAnonymousEnabled;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "ArgoCDSpec(applicationInstanceLabelKey=" + this.getApplicationInstanceLabelKey() + ", applicationSet=" + this.getApplicationSet() + ", banner=" + this.getBanner() + ", configManagementPlugins=" + this.getConfigManagementPlugins() + ", controller=" + this.getController() + ", defaultClusterScopedRoleDisabled=" + this.getDefaultClusterScopedRoleDisabled() + ", disableAdmin=" + this.getDisableAdmin() + ", extraConfig=" + this.getExtraConfig() + ", gaAnonymizeUsers=" + this.getGaAnonymizeUsers() + ", gaTrackingID=" + this.getGaTrackingID() + ", grafana=" + this.getGrafana() + ", ha=" + this.getHa() + ", helpChatText=" + this.getHelpChatText() + ", helpChatURL=" + this.getHelpChatURL() + ", image=" + this.getImage() + ", _import=" + this.get_import() + ", initialRepositories=" + this.getInitialRepositories() + ", initialSSHKnownHosts=" + this.getInitialSSHKnownHosts() + ", kustomizeBuildOptions=" + this.getKustomizeBuildOptions() + ", kustomizeVersions=" + this.getKustomizeVersions() + ", monitoring=" + this.getMonitoring() + ", nodePlacement=" + this.getNodePlacement() + ", notifications=" + this.getNotifications() + ", oidcConfig=" + this.getOidcConfig() + ", prometheus=" + this.getPrometheus() + ", rbac=" + this.getRbac() + ", redis=" + this.getRedis() + ", repo=" + this.getRepo() + ", repositoryCredentials=" + this.getRepositoryCredentials() + ", resourceActions=" + this.getResourceActions() + ", resourceExclusions=" + this.getResourceExclusions() + ", resourceHealthChecks=" + this.getResourceHealthChecks() + ", resourceIgnoreDifferences=" + this.getResourceIgnoreDifferences() + ", resourceInclusions=" + this.getResourceInclusions() + ", resourceTrackingMethod=" + this.getResourceTrackingMethod() + ", server=" + this.getServer() + ", sourceNamespaces=" + this.getSourceNamespaces() + ", sso=" + this.getSso() + ", statusBadgeEnabled=" + this.getStatusBadgeEnabled() + ", tls=" + this.getTls() + ", usersAnonymousEnabled=" + this.getUsersAnonymousEnabled() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgoCDSpec)) {
            return false;
        }
        ArgoCDSpec other = (ArgoCDSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$defaultClusterScopedRoleDisabled = this.getDefaultClusterScopedRoleDisabled();
        Boolean other$defaultClusterScopedRoleDisabled = other.getDefaultClusterScopedRoleDisabled();
        if (this$defaultClusterScopedRoleDisabled == null ? other$defaultClusterScopedRoleDisabled != null : !((Object)this$defaultClusterScopedRoleDisabled).equals(other$defaultClusterScopedRoleDisabled)) {
            return false;
        }
        Boolean this$disableAdmin = this.getDisableAdmin();
        Boolean other$disableAdmin = other.getDisableAdmin();
        if (this$disableAdmin == null ? other$disableAdmin != null : !((Object)this$disableAdmin).equals(other$disableAdmin)) {
            return false;
        }
        Boolean this$gaAnonymizeUsers = this.getGaAnonymizeUsers();
        Boolean other$gaAnonymizeUsers = other.getGaAnonymizeUsers();
        if (this$gaAnonymizeUsers == null ? other$gaAnonymizeUsers != null : !((Object)this$gaAnonymizeUsers).equals(other$gaAnonymizeUsers)) {
            return false;
        }
        Boolean this$statusBadgeEnabled = this.getStatusBadgeEnabled();
        Boolean other$statusBadgeEnabled = other.getStatusBadgeEnabled();
        if (this$statusBadgeEnabled == null ? other$statusBadgeEnabled != null : !((Object)this$statusBadgeEnabled).equals(other$statusBadgeEnabled)) {
            return false;
        }
        Boolean this$usersAnonymousEnabled = this.getUsersAnonymousEnabled();
        Boolean other$usersAnonymousEnabled = other.getUsersAnonymousEnabled();
        if (this$usersAnonymousEnabled == null ? other$usersAnonymousEnabled != null : !((Object)this$usersAnonymousEnabled).equals(other$usersAnonymousEnabled)) {
            return false;
        }
        String this$applicationInstanceLabelKey = this.getApplicationInstanceLabelKey();
        String other$applicationInstanceLabelKey = other.getApplicationInstanceLabelKey();
        if (this$applicationInstanceLabelKey == null ? other$applicationInstanceLabelKey != null : !this$applicationInstanceLabelKey.equals(other$applicationInstanceLabelKey)) {
            return false;
        }
        ApplicationSet this$applicationSet = this.getApplicationSet();
        ApplicationSet other$applicationSet = other.getApplicationSet();
        if (this$applicationSet == null ? other$applicationSet != null : !((Object)this$applicationSet).equals(other$applicationSet)) {
            return false;
        }
        Banner this$banner = this.getBanner();
        Banner other$banner = other.getBanner();
        if (this$banner == null ? other$banner != null : !((Object)this$banner).equals(other$banner)) {
            return false;
        }
        String this$configManagementPlugins = this.getConfigManagementPlugins();
        String other$configManagementPlugins = other.getConfigManagementPlugins();
        if (this$configManagementPlugins == null ? other$configManagementPlugins != null : !this$configManagementPlugins.equals(other$configManagementPlugins)) {
            return false;
        }
        Controller this$controller = this.getController();
        Controller other$controller = other.getController();
        if (this$controller == null ? other$controller != null : !((Object)this$controller).equals(other$controller)) {
            return false;
        }
        Map<String, String> this$extraConfig = this.getExtraConfig();
        Map<String, String> other$extraConfig = other.getExtraConfig();
        if (this$extraConfig == null ? other$extraConfig != null : !((Object)this$extraConfig).equals(other$extraConfig)) {
            return false;
        }
        String this$gaTrackingID = this.getGaTrackingID();
        String other$gaTrackingID = other.getGaTrackingID();
        if (this$gaTrackingID == null ? other$gaTrackingID != null : !this$gaTrackingID.equals(other$gaTrackingID)) {
            return false;
        }
        Grafana this$grafana = this.getGrafana();
        Grafana other$grafana = other.getGrafana();
        if (this$grafana == null ? other$grafana != null : !((Object)this$grafana).equals(other$grafana)) {
            return false;
        }
        Ha this$ha = this.getHa();
        Ha other$ha = other.getHa();
        if (this$ha == null ? other$ha != null : !((Object)this$ha).equals(other$ha)) {
            return false;
        }
        String this$helpChatText = this.getHelpChatText();
        String other$helpChatText = other.getHelpChatText();
        if (this$helpChatText == null ? other$helpChatText != null : !this$helpChatText.equals(other$helpChatText)) {
            return false;
        }
        String this$helpChatURL = this.getHelpChatURL();
        String other$helpChatURL = other.getHelpChatURL();
        if (this$helpChatURL == null ? other$helpChatURL != null : !this$helpChatURL.equals(other$helpChatURL)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Import this$_import = this.get_import();
        Import other$_import = other.get_import();
        if (this$_import == null ? other$_import != null : !((Object)this$_import).equals(other$_import)) {
            return false;
        }
        String this$initialRepositories = this.getInitialRepositories();
        String other$initialRepositories = other.getInitialRepositories();
        if (this$initialRepositories == null ? other$initialRepositories != null : !this$initialRepositories.equals(other$initialRepositories)) {
            return false;
        }
        InitialSSHKnownHosts this$initialSSHKnownHosts = this.getInitialSSHKnownHosts();
        InitialSSHKnownHosts other$initialSSHKnownHosts = other.getInitialSSHKnownHosts();
        if (this$initialSSHKnownHosts == null ? other$initialSSHKnownHosts != null : !((Object)this$initialSSHKnownHosts).equals(other$initialSSHKnownHosts)) {
            return false;
        }
        String this$kustomizeBuildOptions = this.getKustomizeBuildOptions();
        String other$kustomizeBuildOptions = other.getKustomizeBuildOptions();
        if (this$kustomizeBuildOptions == null ? other$kustomizeBuildOptions != null : !this$kustomizeBuildOptions.equals(other$kustomizeBuildOptions)) {
            return false;
        }
        List<KustomizeVersions> this$kustomizeVersions = this.getKustomizeVersions();
        List<KustomizeVersions> other$kustomizeVersions = other.getKustomizeVersions();
        if (this$kustomizeVersions == null ? other$kustomizeVersions != null : !((Object)this$kustomizeVersions).equals(other$kustomizeVersions)) {
            return false;
        }
        Monitoring this$monitoring = this.getMonitoring();
        Monitoring other$monitoring = other.getMonitoring();
        if (this$monitoring == null ? other$monitoring != null : !((Object)this$monitoring).equals(other$monitoring)) {
            return false;
        }
        NodePlacement this$nodePlacement = this.getNodePlacement();
        NodePlacement other$nodePlacement = other.getNodePlacement();
        if (this$nodePlacement == null ? other$nodePlacement != null : !((Object)this$nodePlacement).equals(other$nodePlacement)) {
            return false;
        }
        Notifications this$notifications = this.getNotifications();
        Notifications other$notifications = other.getNotifications();
        if (this$notifications == null ? other$notifications != null : !((Object)this$notifications).equals(other$notifications)) {
            return false;
        }
        String this$oidcConfig = this.getOidcConfig();
        String other$oidcConfig = other.getOidcConfig();
        if (this$oidcConfig == null ? other$oidcConfig != null : !this$oidcConfig.equals(other$oidcConfig)) {
            return false;
        }
        Prometheus this$prometheus = this.getPrometheus();
        Prometheus other$prometheus = other.getPrometheus();
        if (this$prometheus == null ? other$prometheus != null : !((Object)this$prometheus).equals(other$prometheus)) {
            return false;
        }
        Rbac this$rbac = this.getRbac();
        Rbac other$rbac = other.getRbac();
        if (this$rbac == null ? other$rbac != null : !((Object)this$rbac).equals(other$rbac)) {
            return false;
        }
        Redis this$redis = this.getRedis();
        Redis other$redis = other.getRedis();
        if (this$redis == null ? other$redis != null : !((Object)this$redis).equals(other$redis)) {
            return false;
        }
        Repo this$repo = this.getRepo();
        Repo other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !((Object)this$repo).equals(other$repo)) {
            return false;
        }
        String this$repositoryCredentials = this.getRepositoryCredentials();
        String other$repositoryCredentials = other.getRepositoryCredentials();
        if (this$repositoryCredentials == null ? other$repositoryCredentials != null : !this$repositoryCredentials.equals(other$repositoryCredentials)) {
            return false;
        }
        List<ResourceActions> this$resourceActions = this.getResourceActions();
        List<ResourceActions> other$resourceActions = other.getResourceActions();
        if (this$resourceActions == null ? other$resourceActions != null : !((Object)this$resourceActions).equals(other$resourceActions)) {
            return false;
        }
        String this$resourceExclusions = this.getResourceExclusions();
        String other$resourceExclusions = other.getResourceExclusions();
        if (this$resourceExclusions == null ? other$resourceExclusions != null : !this$resourceExclusions.equals(other$resourceExclusions)) {
            return false;
        }
        List<ResourceHealthChecks> this$resourceHealthChecks = this.getResourceHealthChecks();
        List<ResourceHealthChecks> other$resourceHealthChecks = other.getResourceHealthChecks();
        if (this$resourceHealthChecks == null ? other$resourceHealthChecks != null : !((Object)this$resourceHealthChecks).equals(other$resourceHealthChecks)) {
            return false;
        }
        ResourceIgnoreDifferences this$resourceIgnoreDifferences = this.getResourceIgnoreDifferences();
        ResourceIgnoreDifferences other$resourceIgnoreDifferences = other.getResourceIgnoreDifferences();
        if (this$resourceIgnoreDifferences == null ? other$resourceIgnoreDifferences != null : !((Object)this$resourceIgnoreDifferences).equals(other$resourceIgnoreDifferences)) {
            return false;
        }
        String this$resourceInclusions = this.getResourceInclusions();
        String other$resourceInclusions = other.getResourceInclusions();
        if (this$resourceInclusions == null ? other$resourceInclusions != null : !this$resourceInclusions.equals(other$resourceInclusions)) {
            return false;
        }
        String this$resourceTrackingMethod = this.getResourceTrackingMethod();
        String other$resourceTrackingMethod = other.getResourceTrackingMethod();
        if (this$resourceTrackingMethod == null ? other$resourceTrackingMethod != null : !this$resourceTrackingMethod.equals(other$resourceTrackingMethod)) {
            return false;
        }
        Server this$server = this.getServer();
        Server other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        List<String> this$sourceNamespaces = this.getSourceNamespaces();
        List<String> other$sourceNamespaces = other.getSourceNamespaces();
        if (this$sourceNamespaces == null ? other$sourceNamespaces != null : !((Object)this$sourceNamespaces).equals(other$sourceNamespaces)) {
            return false;
        }
        Sso this$sso = this.getSso();
        Sso other$sso = other.getSso();
        if (this$sso == null ? other$sso != null : !((Object)this$sso).equals(other$sso)) {
            return false;
        }
        Tls this$tls = this.getTls();
        Tls other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArgoCDSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $defaultClusterScopedRoleDisabled = this.getDefaultClusterScopedRoleDisabled();
        result = result * 59 + ($defaultClusterScopedRoleDisabled == null ? 43 : ((Object)$defaultClusterScopedRoleDisabled).hashCode());
        Boolean $disableAdmin = this.getDisableAdmin();
        result = result * 59 + ($disableAdmin == null ? 43 : ((Object)$disableAdmin).hashCode());
        Boolean $gaAnonymizeUsers = this.getGaAnonymizeUsers();
        result = result * 59 + ($gaAnonymizeUsers == null ? 43 : ((Object)$gaAnonymizeUsers).hashCode());
        Boolean $statusBadgeEnabled = this.getStatusBadgeEnabled();
        result = result * 59 + ($statusBadgeEnabled == null ? 43 : ((Object)$statusBadgeEnabled).hashCode());
        Boolean $usersAnonymousEnabled = this.getUsersAnonymousEnabled();
        result = result * 59 + ($usersAnonymousEnabled == null ? 43 : ((Object)$usersAnonymousEnabled).hashCode());
        String $applicationInstanceLabelKey = this.getApplicationInstanceLabelKey();
        result = result * 59 + ($applicationInstanceLabelKey == null ? 43 : $applicationInstanceLabelKey.hashCode());
        ApplicationSet $applicationSet = this.getApplicationSet();
        result = result * 59 + ($applicationSet == null ? 43 : ((Object)$applicationSet).hashCode());
        Banner $banner = this.getBanner();
        result = result * 59 + ($banner == null ? 43 : ((Object)$banner).hashCode());
        String $configManagementPlugins = this.getConfigManagementPlugins();
        result = result * 59 + ($configManagementPlugins == null ? 43 : $configManagementPlugins.hashCode());
        Controller $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : ((Object)$controller).hashCode());
        Map<String, String> $extraConfig = this.getExtraConfig();
        result = result * 59 + ($extraConfig == null ? 43 : ((Object)$extraConfig).hashCode());
        String $gaTrackingID = this.getGaTrackingID();
        result = result * 59 + ($gaTrackingID == null ? 43 : $gaTrackingID.hashCode());
        Grafana $grafana = this.getGrafana();
        result = result * 59 + ($grafana == null ? 43 : ((Object)$grafana).hashCode());
        Ha $ha = this.getHa();
        result = result * 59 + ($ha == null ? 43 : ((Object)$ha).hashCode());
        String $helpChatText = this.getHelpChatText();
        result = result * 59 + ($helpChatText == null ? 43 : $helpChatText.hashCode());
        String $helpChatURL = this.getHelpChatURL();
        result = result * 59 + ($helpChatURL == null ? 43 : $helpChatURL.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Import $_import = this.get_import();
        result = result * 59 + ($_import == null ? 43 : ((Object)$_import).hashCode());
        String $initialRepositories = this.getInitialRepositories();
        result = result * 59 + ($initialRepositories == null ? 43 : $initialRepositories.hashCode());
        InitialSSHKnownHosts $initialSSHKnownHosts = this.getInitialSSHKnownHosts();
        result = result * 59 + ($initialSSHKnownHosts == null ? 43 : ((Object)$initialSSHKnownHosts).hashCode());
        String $kustomizeBuildOptions = this.getKustomizeBuildOptions();
        result = result * 59 + ($kustomizeBuildOptions == null ? 43 : $kustomizeBuildOptions.hashCode());
        List<KustomizeVersions> $kustomizeVersions = this.getKustomizeVersions();
        result = result * 59 + ($kustomizeVersions == null ? 43 : ((Object)$kustomizeVersions).hashCode());
        Monitoring $monitoring = this.getMonitoring();
        result = result * 59 + ($monitoring == null ? 43 : ((Object)$monitoring).hashCode());
        NodePlacement $nodePlacement = this.getNodePlacement();
        result = result * 59 + ($nodePlacement == null ? 43 : ((Object)$nodePlacement).hashCode());
        Notifications $notifications = this.getNotifications();
        result = result * 59 + ($notifications == null ? 43 : ((Object)$notifications).hashCode());
        String $oidcConfig = this.getOidcConfig();
        result = result * 59 + ($oidcConfig == null ? 43 : $oidcConfig.hashCode());
        Prometheus $prometheus = this.getPrometheus();
        result = result * 59 + ($prometheus == null ? 43 : ((Object)$prometheus).hashCode());
        Rbac $rbac = this.getRbac();
        result = result * 59 + ($rbac == null ? 43 : ((Object)$rbac).hashCode());
        Redis $redis = this.getRedis();
        result = result * 59 + ($redis == null ? 43 : ((Object)$redis).hashCode());
        Repo $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : ((Object)$repo).hashCode());
        String $repositoryCredentials = this.getRepositoryCredentials();
        result = result * 59 + ($repositoryCredentials == null ? 43 : $repositoryCredentials.hashCode());
        List<ResourceActions> $resourceActions = this.getResourceActions();
        result = result * 59 + ($resourceActions == null ? 43 : ((Object)$resourceActions).hashCode());
        String $resourceExclusions = this.getResourceExclusions();
        result = result * 59 + ($resourceExclusions == null ? 43 : $resourceExclusions.hashCode());
        List<ResourceHealthChecks> $resourceHealthChecks = this.getResourceHealthChecks();
        result = result * 59 + ($resourceHealthChecks == null ? 43 : ((Object)$resourceHealthChecks).hashCode());
        ResourceIgnoreDifferences $resourceIgnoreDifferences = this.getResourceIgnoreDifferences();
        result = result * 59 + ($resourceIgnoreDifferences == null ? 43 : ((Object)$resourceIgnoreDifferences).hashCode());
        String $resourceInclusions = this.getResourceInclusions();
        result = result * 59 + ($resourceInclusions == null ? 43 : $resourceInclusions.hashCode());
        String $resourceTrackingMethod = this.getResourceTrackingMethod();
        result = result * 59 + ($resourceTrackingMethod == null ? 43 : $resourceTrackingMethod.hashCode());
        Server $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        List<String> $sourceNamespaces = this.getSourceNamespaces();
        result = result * 59 + ($sourceNamespaces == null ? 43 : ((Object)$sourceNamespaces).hashCode());
        Sso $sso = this.getSso();
        result = result * 59 + ($sso == null ? 43 : ((Object)$sso).hashCode());
        Tls $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

