/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.ArgoCDStatusBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"applicationController", "applicationSetController", "host", "notificationsController", "phase", "redis", "redisTLSChecksum", "repo", "repoTLSChecksum", "server", "sso"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ArgoCDStatus
implements Editable<ArgoCDStatusBuilder>,
KubernetesResource {
    @JsonProperty(value="applicationController")
    @JsonPropertyDescription(value="ApplicationController is a simple, high-level summary of where the Argo CD application controller component is in its lifecycle. There are four possible ApplicationController values: Pending: The Argo CD application controller component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD application controller component are in a Ready state. Failed: At least one of the  Argo CD application controller component Pods had a failure. Unknown: The state of the Argo CD application controller component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String applicationController;
    @JsonProperty(value="applicationSetController")
    @JsonPropertyDescription(value="ApplicationSetController is a simple, high-level summary of where the Argo CD applicationSet controller component is in its lifecycle. There are four possible ApplicationSetController values: Pending: The Argo CD applicationSet controller component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD applicationSet controller component are in a Ready state. Failed: At least one of the  Argo CD applicationSet controller component Pods had a failure. Unknown: The state of the Argo CD applicationSet controller component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String applicationSetController;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="Host is the hostname of the Ingress.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="notificationsController")
    @JsonPropertyDescription(value="NotificationsController is a simple, high-level summary of where the Argo CD notifications controller component is in its lifecycle. There are four possible NotificationsController values: Pending: The Argo CD notifications controller component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD notifications controller component are in a Ready state. Failed: At least one of the  Argo CD notifications controller component Pods had a failure. Unknown: The state of the Argo CD notifications controller component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String notificationsController;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="Phase is a simple, high-level summary of where the ArgoCD is in its lifecycle. There are four possible phase values: Pending: The ArgoCD has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Available: All of the resources for the ArgoCD are ready. Failed: At least one resource has experienced a failure. Unknown: The state of the ArgoCD phase could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="redis")
    @JsonPropertyDescription(value="Redis is a simple, high-level summary of where the Argo CD Redis component is in its lifecycle. There are four possible redis values: Pending: The Argo CD Redis component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD Redis component are in a Ready state. Failed: At least one of the  Argo CD Redis component Pods had a failure. Unknown: The state of the Argo CD Redis component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String redis;
    @JsonProperty(value="redisTLSChecksum")
    @JsonPropertyDescription(value="RedisTLSChecksum contains the SHA256 checksum of the latest known state of tls.crt and tls.key in the argocd-operator-redis-tls secret.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String redisTLSChecksum;
    @JsonProperty(value="repo")
    @JsonPropertyDescription(value="Repo is a simple, high-level summary of where the Argo CD Repo component is in its lifecycle. There are four possible repo values: Pending: The Argo CD Repo component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD Repo component are in a Ready state. Failed: At least one of the  Argo CD Repo component Pods had a failure. Unknown: The state of the Argo CD Repo component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String repo;
    @JsonProperty(value="repoTLSChecksum")
    @JsonPropertyDescription(value="RepoTLSChecksum contains the SHA256 checksum of the latest known state of tls.crt and tls.key in the argocd-repo-server-tls secret.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String repoTLSChecksum;
    @JsonProperty(value="server")
    @JsonPropertyDescription(value="Server is a simple, high-level summary of where the Argo CD server component is in its lifecycle. There are four possible server values: Pending: The Argo CD server component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD server component are in a Ready state. Failed: At least one of the  Argo CD server component Pods had a failure. Unknown: The state of the Argo CD server component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String server;
    @JsonProperty(value="sso")
    @JsonPropertyDescription(value="SSO is a simple, high-level summary of where the Argo CD SSO(Dex/Keycloak) component is in its lifecycle. There are four possible sso values: Pending: The Argo CD SSO component has been accepted by the Kubernetes system, but one or more of the required resources have not been created. Running: All of the required Pods for the Argo CD SSO component are in a Ready state. Failed: At least one of the  Argo CD SSO component Pods had a failure. Unknown: The state of the Argo CD SSO component could not be obtained.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String sso;

    public ArgoCDStatusBuilder edit() {
        return new ArgoCDStatusBuilder(this);
    }

    public String getApplicationController() {
        return this.applicationController;
    }

    public void setApplicationController(String applicationController) {
        this.applicationController = applicationController;
    }

    public String getApplicationSetController() {
        return this.applicationSetController;
    }

    public void setApplicationSetController(String applicationSetController) {
        this.applicationSetController = applicationSetController;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getNotificationsController() {
        return this.notificationsController;
    }

    public void setNotificationsController(String notificationsController) {
        this.notificationsController = notificationsController;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getRedis() {
        return this.redis;
    }

    public void setRedis(String redis) {
        this.redis = redis;
    }

    public String getRedisTLSChecksum() {
        return this.redisTLSChecksum;
    }

    public void setRedisTLSChecksum(String redisTLSChecksum) {
        this.redisTLSChecksum = redisTLSChecksum;
    }

    public String getRepo() {
        return this.repo;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public String getRepoTLSChecksum() {
        return this.repoTLSChecksum;
    }

    public void setRepoTLSChecksum(String repoTLSChecksum) {
        this.repoTLSChecksum = repoTLSChecksum;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getSso() {
        return this.sso;
    }

    public void setSso(String sso) {
        this.sso = sso;
    }

    public String toString() {
        return "ArgoCDStatus(applicationController=" + this.getApplicationController() + ", applicationSetController=" + this.getApplicationSetController() + ", host=" + this.getHost() + ", notificationsController=" + this.getNotificationsController() + ", phase=" + this.getPhase() + ", redis=" + this.getRedis() + ", redisTLSChecksum=" + this.getRedisTLSChecksum() + ", repo=" + this.getRepo() + ", repoTLSChecksum=" + this.getRepoTLSChecksum() + ", server=" + this.getServer() + ", sso=" + this.getSso() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgoCDStatus)) {
            return false;
        }
        ArgoCDStatus other = (ArgoCDStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationController = this.getApplicationController();
        String other$applicationController = other.getApplicationController();
        if (this$applicationController == null ? other$applicationController != null : !this$applicationController.equals(other$applicationController)) {
            return false;
        }
        String this$applicationSetController = this.getApplicationSetController();
        String other$applicationSetController = other.getApplicationSetController();
        if (this$applicationSetController == null ? other$applicationSetController != null : !this$applicationSetController.equals(other$applicationSetController)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$notificationsController = this.getNotificationsController();
        String other$notificationsController = other.getNotificationsController();
        if (this$notificationsController == null ? other$notificationsController != null : !this$notificationsController.equals(other$notificationsController)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$redis = this.getRedis();
        String other$redis = other.getRedis();
        if (this$redis == null ? other$redis != null : !this$redis.equals(other$redis)) {
            return false;
        }
        String this$redisTLSChecksum = this.getRedisTLSChecksum();
        String other$redisTLSChecksum = other.getRedisTLSChecksum();
        if (this$redisTLSChecksum == null ? other$redisTLSChecksum != null : !this$redisTLSChecksum.equals(other$redisTLSChecksum)) {
            return false;
        }
        String this$repo = this.getRepo();
        String other$repo = other.getRepo();
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        String this$repoTLSChecksum = this.getRepoTLSChecksum();
        String other$repoTLSChecksum = other.getRepoTLSChecksum();
        if (this$repoTLSChecksum == null ? other$repoTLSChecksum != null : !this$repoTLSChecksum.equals(other$repoTLSChecksum)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$sso = this.getSso();
        String other$sso = other.getSso();
        return !(this$sso == null ? other$sso != null : !this$sso.equals(other$sso));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArgoCDStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationController = this.getApplicationController();
        result = result * 59 + ($applicationController == null ? 43 : $applicationController.hashCode());
        String $applicationSetController = this.getApplicationSetController();
        result = result * 59 + ($applicationSetController == null ? 43 : $applicationSetController.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $notificationsController = this.getNotificationsController();
        result = result * 59 + ($notificationsController == null ? 43 : $notificationsController.hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $redis = this.getRedis();
        result = result * 59 + ($redis == null ? 43 : $redis.hashCode());
        String $redisTLSChecksum = this.getRedisTLSChecksum();
        result = result * 59 + ($redisTLSChecksum == null ? 43 : $redisTLSChecksum.hashCode());
        String $repo = this.getRepo();
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        String $repoTLSChecksum = this.getRepoTLSChecksum();
        result = result * 59 + ($repoTLSChecksum == null ? 43 : $repoTLSChecksum.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $sso = this.getSso();
        result = result * 59 + ($sso == null ? 43 : $sso.hashCode());
        return result;
    }
}

