/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.ApplicationSetBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.WebhookServer;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "env", "extraCommandArgs", "image", "logLevel", "resources", "scmProviders", "scmRootCAConfigMap", "sourceNamespaces", "version", "webhookServer"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ApplicationSet
implements Editable<ApplicationSetBuilder>,
KubernetesResource {
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Enabled is the flag to enable the Application Set Controller during ArgoCD installation. (optional, default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="Env lets you specify environment for applicationSet controller pods")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Env> env;
    @JsonProperty(value="extraCommandArgs")
    @JsonPropertyDescription(value="ExtraCommandArgs allows users to pass command line arguments to ApplicationSet controller. They get added to default command line arguments provided by the operator. Please note that the command line arguments provided as part of ExtraCommandArgs will not overwrite the default command line arguments.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> extraCommandArgs;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Image is the Argo CD ApplicationSet image (optional)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="logLevel")
    @JsonPropertyDescription(value="LogLevel describes the log level that should be used by the ApplicationSet controller. Defaults to ArgoCDDefaultLogLevel if not set.  Valid options are debug,info, error, and warn.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logLevel;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources defines the Compute Resources required by the container for ApplicationSet.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="scmProviders")
    @JsonPropertyDescription(value="SCMProviders defines the list of allowed custom SCM provider API URLs")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> scmProviders;
    @JsonProperty(value="scmRootCAConfigMap")
    @JsonPropertyDescription(value="SCMRootCAConfigMap is the name of the config map that stores the Gitlab SCM Provider's TLS certificate which will be mounted on the ApplicationSet Controller (optional).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String scmRootCAConfigMap;
    @JsonProperty(value="sourceNamespaces")
    @JsonPropertyDescription(value="SourceNamespaces defines the namespaces applicationset resources are allowed to be created in")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> sourceNamespaces;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version is the Argo CD ApplicationSet image tag. (optional)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;
    @JsonProperty(value="webhookServer")
    @JsonPropertyDescription(value="WebhookServerSpec defines the options for the ApplicationSet Webhook Server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private WebhookServer webhookServer;

    public ApplicationSetBuilder edit() {
        return new ApplicationSetBuilder(this);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<Env> getEnv() {
        return this.env;
    }

    public void setEnv(List<Env> env) {
        this.env = env;
    }

    public List<String> getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public void setExtraCommandArgs(List<String> extraCommandArgs) {
        this.extraCommandArgs = extraCommandArgs;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public List<String> getScmProviders() {
        return this.scmProviders;
    }

    public void setScmProviders(List<String> scmProviders) {
        this.scmProviders = scmProviders;
    }

    public String getScmRootCAConfigMap() {
        return this.scmRootCAConfigMap;
    }

    public void setScmRootCAConfigMap(String scmRootCAConfigMap) {
        this.scmRootCAConfigMap = scmRootCAConfigMap;
    }

    public List<String> getSourceNamespaces() {
        return this.sourceNamespaces;
    }

    public void setSourceNamespaces(List<String> sourceNamespaces) {
        this.sourceNamespaces = sourceNamespaces;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public WebhookServer getWebhookServer() {
        return this.webhookServer;
    }

    public void setWebhookServer(WebhookServer webhookServer) {
        this.webhookServer = webhookServer;
    }

    public String toString() {
        return "ApplicationSet(enabled=" + this.getEnabled() + ", env=" + this.getEnv() + ", extraCommandArgs=" + this.getExtraCommandArgs() + ", image=" + this.getImage() + ", logLevel=" + this.getLogLevel() + ", resources=" + this.getResources() + ", scmProviders=" + this.getScmProviders() + ", scmRootCAConfigMap=" + this.getScmRootCAConfigMap() + ", sourceNamespaces=" + this.getSourceNamespaces() + ", version=" + this.getVersion() + ", webhookServer=" + this.getWebhookServer() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationSet)) {
            return false;
        }
        ApplicationSet other = (ApplicationSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        List<Env> this$env = this.getEnv();
        List<Env> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<String> this$extraCommandArgs = this.getExtraCommandArgs();
        List<String> other$extraCommandArgs = other.getExtraCommandArgs();
        if (this$extraCommandArgs == null ? other$extraCommandArgs != null : !((Object)this$extraCommandArgs).equals(other$extraCommandArgs)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        List<String> this$scmProviders = this.getScmProviders();
        List<String> other$scmProviders = other.getScmProviders();
        if (this$scmProviders == null ? other$scmProviders != null : !((Object)this$scmProviders).equals(other$scmProviders)) {
            return false;
        }
        String this$scmRootCAConfigMap = this.getScmRootCAConfigMap();
        String other$scmRootCAConfigMap = other.getScmRootCAConfigMap();
        if (this$scmRootCAConfigMap == null ? other$scmRootCAConfigMap != null : !this$scmRootCAConfigMap.equals(other$scmRootCAConfigMap)) {
            return false;
        }
        List<String> this$sourceNamespaces = this.getSourceNamespaces();
        List<String> other$sourceNamespaces = other.getSourceNamespaces();
        if (this$sourceNamespaces == null ? other$sourceNamespaces != null : !((Object)this$sourceNamespaces).equals(other$sourceNamespaces)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        WebhookServer this$webhookServer = this.getWebhookServer();
        WebhookServer other$webhookServer = other.getWebhookServer();
        return !(this$webhookServer == null ? other$webhookServer != null : !((Object)this$webhookServer).equals(other$webhookServer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        List<Env> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<String> $extraCommandArgs = this.getExtraCommandArgs();
        result = result * 59 + ($extraCommandArgs == null ? 43 : ((Object)$extraCommandArgs).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        List<String> $scmProviders = this.getScmProviders();
        result = result * 59 + ($scmProviders == null ? 43 : ((Object)$scmProviders).hashCode());
        String $scmRootCAConfigMap = this.getScmRootCAConfigMap();
        result = result * 59 + ($scmRootCAConfigMap == null ? 43 : $scmRootCAConfigMap.hashCode());
        List<String> $sourceNamespaces = this.getSourceNamespaces();
        result = result * 59 + ($sourceNamespaces == null ? 43 : ((Object)$sourceNamespaces).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        WebhookServer $webhookServer = this.getWebhookServer();
        result = result * 59 + ($webhookServer == null ? 43 : ((Object)$webhookServer).hashCode());
        return result;
    }
}

