/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.ApplicationSet;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.EnvBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.EnvFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.ResourcesFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.WebhookServer;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.WebhookServerBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.WebhookServerFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ApplicationSetFluent<A extends ApplicationSetFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private ArrayList<EnvBuilder> env;
    private List<String> extraCommandArgs;
    private String image;
    private String logLevel;
    private ResourcesBuilder resources;
    private List<String> scmProviders;
    private String scmRootCAConfigMap;
    private List<String> sourceNamespaces;
    private String version;
    private WebhookServerBuilder webhookServer;

    public ApplicationSetFluent() {
    }

    public ApplicationSetFluent(ApplicationSet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ApplicationSet instance) {
        ApplicationSet applicationSet = instance = instance != null ? instance : new ApplicationSet();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withEnv(instance.getEnv());
            this.withExtraCommandArgs(instance.getExtraCommandArgs());
            this.withImage(instance.getImage());
            this.withLogLevel(instance.getLogLevel());
            this.withResources(instance.getResources());
            this.withScmProviders(instance.getScmProviders());
            this.withScmRootCAConfigMap(instance.getScmRootCAConfigMap());
            this.withSourceNamespaces(instance.getSourceNamespaces());
            this.withVersion(instance.getVersion());
            this.withWebhookServer(instance.getWebhookServer());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(Env ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<Env> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(Env ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<Env> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Env> buildEnv() {
        return this.env != null ? ApplicationSetFluent.build(this.env) : null;
    }

    public Env buildEnv(int index) {
        return this.env.get(index).build();
    }

    public Env buildFirstEnv() {
        return this.env.get(0).build();
    }

    public Env buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<Env> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (Env item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(Env ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (Env item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(Env item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, Env item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public A addToExtraCommandArgs(int index, String item) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        this.extraCommandArgs.add(index, item);
        return (A)((Object)this);
    }

    public A setToExtraCommandArgs(int index, String item) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        this.extraCommandArgs.set(index, item);
        return (A)((Object)this);
    }

    public A addToExtraCommandArgs(String ... items) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraCommandArgs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExtraCommandArgs(Collection<String> items) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraCommandArgs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExtraCommandArgs(String ... items) {
        if (this.extraCommandArgs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extraCommandArgs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtraCommandArgs(Collection<String> items) {
        if (this.extraCommandArgs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extraCommandArgs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public String getExtraCommandArg(int index) {
        return this.extraCommandArgs.get(index);
    }

    public String getFirstExtraCommandArg() {
        return this.extraCommandArgs.get(0);
    }

    public String getLastExtraCommandArg() {
        return this.extraCommandArgs.get(this.extraCommandArgs.size() - 1);
    }

    public String getMatchingExtraCommandArg(Predicate<String> predicate) {
        for (String item : this.extraCommandArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExtraCommandArg(Predicate<String> predicate) {
        for (String item : this.extraCommandArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtraCommandArgs(List<String> extraCommandArgs) {
        if (extraCommandArgs != null) {
            this.extraCommandArgs = new ArrayList<String>();
            for (String item : extraCommandArgs) {
                this.addToExtraCommandArgs(item);
            }
        } else {
            this.extraCommandArgs = null;
        }
        return (A)((Object)this);
    }

    public A withExtraCommandArgs(String ... extraCommandArgs) {
        if (this.extraCommandArgs != null) {
            this.extraCommandArgs.clear();
            this._visitables.remove((Object)"extraCommandArgs");
        }
        if (extraCommandArgs != null) {
            for (String item : extraCommandArgs) {
                this.addToExtraCommandArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtraCommandArgs() {
        return this.extraCommandArgs != null && !this.extraCommandArgs.isEmpty();
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public A addToScmProviders(int index, String item) {
        if (this.scmProviders == null) {
            this.scmProviders = new ArrayList<String>();
        }
        this.scmProviders.add(index, item);
        return (A)((Object)this);
    }

    public A setToScmProviders(int index, String item) {
        if (this.scmProviders == null) {
            this.scmProviders = new ArrayList<String>();
        }
        this.scmProviders.set(index, item);
        return (A)((Object)this);
    }

    public A addToScmProviders(String ... items) {
        if (this.scmProviders == null) {
            this.scmProviders = new ArrayList<String>();
        }
        for (String item : items) {
            this.scmProviders.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToScmProviders(Collection<String> items) {
        if (this.scmProviders == null) {
            this.scmProviders = new ArrayList<String>();
        }
        for (String item : items) {
            this.scmProviders.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromScmProviders(String ... items) {
        if (this.scmProviders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scmProviders.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromScmProviders(Collection<String> items) {
        if (this.scmProviders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scmProviders.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getScmProviders() {
        return this.scmProviders;
    }

    public String getScmProvider(int index) {
        return this.scmProviders.get(index);
    }

    public String getFirstScmProvider() {
        return this.scmProviders.get(0);
    }

    public String getLastScmProvider() {
        return this.scmProviders.get(this.scmProviders.size() - 1);
    }

    public String getMatchingScmProvider(Predicate<String> predicate) {
        for (String item : this.scmProviders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingScmProvider(Predicate<String> predicate) {
        for (String item : this.scmProviders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScmProviders(List<String> scmProviders) {
        if (scmProviders != null) {
            this.scmProviders = new ArrayList<String>();
            for (String item : scmProviders) {
                this.addToScmProviders(item);
            }
        } else {
            this.scmProviders = null;
        }
        return (A)((Object)this);
    }

    public A withScmProviders(String ... scmProviders) {
        if (this.scmProviders != null) {
            this.scmProviders.clear();
            this._visitables.remove((Object)"scmProviders");
        }
        if (scmProviders != null) {
            for (String item : scmProviders) {
                this.addToScmProviders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasScmProviders() {
        return this.scmProviders != null && !this.scmProviders.isEmpty();
    }

    public String getScmRootCAConfigMap() {
        return this.scmRootCAConfigMap;
    }

    public A withScmRootCAConfigMap(String scmRootCAConfigMap) {
        this.scmRootCAConfigMap = scmRootCAConfigMap;
        return (A)((Object)this);
    }

    public boolean hasScmRootCAConfigMap() {
        return this.scmRootCAConfigMap != null;
    }

    public A addToSourceNamespaces(int index, String item) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        this.sourceNamespaces.add(index, item);
        return (A)((Object)this);
    }

    public A setToSourceNamespaces(int index, String item) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        this.sourceNamespaces.set(index, item);
        return (A)((Object)this);
    }

    public A addToSourceNamespaces(String ... items) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceNamespaces.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSourceNamespaces(Collection<String> items) {
        if (this.sourceNamespaces == null) {
            this.sourceNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.sourceNamespaces.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSourceNamespaces(String ... items) {
        if (this.sourceNamespaces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sourceNamespaces.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSourceNamespaces(Collection<String> items) {
        if (this.sourceNamespaces == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sourceNamespaces.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSourceNamespaces() {
        return this.sourceNamespaces;
    }

    public String getSourceNamespace(int index) {
        return this.sourceNamespaces.get(index);
    }

    public String getFirstSourceNamespace() {
        return this.sourceNamespaces.get(0);
    }

    public String getLastSourceNamespace() {
        return this.sourceNamespaces.get(this.sourceNamespaces.size() - 1);
    }

    public String getMatchingSourceNamespace(Predicate<String> predicate) {
        for (String item : this.sourceNamespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSourceNamespace(Predicate<String> predicate) {
        for (String item : this.sourceNamespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSourceNamespaces(List<String> sourceNamespaces) {
        if (sourceNamespaces != null) {
            this.sourceNamespaces = new ArrayList<String>();
            for (String item : sourceNamespaces) {
                this.addToSourceNamespaces(item);
            }
        } else {
            this.sourceNamespaces = null;
        }
        return (A)((Object)this);
    }

    public A withSourceNamespaces(String ... sourceNamespaces) {
        if (this.sourceNamespaces != null) {
            this.sourceNamespaces.clear();
            this._visitables.remove((Object)"sourceNamespaces");
        }
        if (sourceNamespaces != null) {
            for (String item : sourceNamespaces) {
                this.addToSourceNamespaces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSourceNamespaces() {
        return this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public WebhookServer buildWebhookServer() {
        return this.webhookServer != null ? this.webhookServer.build() : null;
    }

    public A withWebhookServer(WebhookServer webhookServer) {
        this._visitables.remove((Object)"webhookServer");
        if (webhookServer != null) {
            this.webhookServer = new WebhookServerBuilder(webhookServer);
            this._visitables.get((Object)"webhookServer").add(this.webhookServer);
        } else {
            this.webhookServer = null;
            this._visitables.get((Object)"webhookServer").remove((Object)this.webhookServer);
        }
        return (A)((Object)this);
    }

    public boolean hasWebhookServer() {
        return this.webhookServer != null;
    }

    public WebhookServerNested<A> withNewWebhookServer() {
        return new WebhookServerNested(null);
    }

    public WebhookServerNested<A> withNewWebhookServerLike(WebhookServer item) {
        return new WebhookServerNested(item);
    }

    public WebhookServerNested<A> editWebhookServer() {
        return this.withNewWebhookServerLike(Optional.ofNullable(this.buildWebhookServer()).orElse(null));
    }

    public WebhookServerNested<A> editOrNewWebhookServer() {
        return this.withNewWebhookServerLike(Optional.ofNullable(this.buildWebhookServer()).orElse(new WebhookServerBuilder().build()));
    }

    public WebhookServerNested<A> editOrNewWebhookServerLike(WebhookServer item) {
        return this.withNewWebhookServerLike(Optional.ofNullable(this.buildWebhookServer()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationSetFluent that = (ApplicationSetFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.extraCommandArgs, that.extraCommandArgs)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.scmProviders, that.scmProviders)) {
            return false;
        }
        if (!Objects.equals(this.scmRootCAConfigMap, that.scmRootCAConfigMap)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespaces, that.sourceNamespaces)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals((Object)this.webhookServer, (Object)that.webhookServer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.env, this.extraCommandArgs, this.image, this.logLevel, this.resources, this.scmProviders, this.scmRootCAConfigMap, this.sourceNamespaces, this.version, this.webhookServer, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.extraCommandArgs != null && !this.extraCommandArgs.isEmpty()) {
            sb.append("extraCommandArgs:");
            sb.append(this.extraCommandArgs + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.scmProviders != null && !this.scmProviders.isEmpty()) {
            sb.append("scmProviders:");
            sb.append(this.scmProviders + ",");
        }
        if (this.scmRootCAConfigMap != null) {
            sb.append("scmRootCAConfigMap:");
            sb.append(this.scmRootCAConfigMap + ",");
        }
        if (this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty()) {
            sb.append("sourceNamespaces:");
            sb.append(this.sourceNamespaces + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.webhookServer != null) {
            sb.append("webhookServer:");
            sb.append((Object)this.webhookServer);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class EnvNested<N>
    extends EnvFluent<EnvNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)ApplicationSetFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)ApplicationSetFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class WebhookServerNested<N>
    extends WebhookServerFluent<WebhookServerNested<N>>
    implements Nested<N> {
        WebhookServerBuilder builder;

        WebhookServerNested(WebhookServer item) {
            this.builder = new WebhookServerBuilder(this, item);
        }

        public N and() {
            return (N)ApplicationSetFluent.this.withWebhookServer(this.builder.build());
        }

        public N endWebhookServer() {
            return this.and();
        }
    }
}

