/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.ControllerBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Processors;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Sharding;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"appSync", "enabled", "env", "logFormat", "logLevel", "parallelismLimit", "processors", "resources", "sharding"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Controller
implements Editable<ControllerBuilder>,
KubernetesResource {
    @JsonProperty(value="appSync")
    @JsonPropertyDescription(value="AppSync is used to control the sync frequency, by default the ArgoCD controller polls Git every 3m. \n Set this to a duration, e.g. 10m or 600s to control the synchronisation frequency.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String appSync;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Enabled is the flag to enable the Application Controller during ArgoCD installation. (optional, default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="Env lets you specify environment for application controller pods")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Env> env;
    @JsonProperty(value="logFormat")
    @JsonPropertyDescription(value="LogFormat refers to the log format used by the Application Controller component. Defaults to ArgoCDDefaultLogFormat if not configured. Valid options are text or json.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logFormat;
    @JsonProperty(value="logLevel")
    @JsonPropertyDescription(value="LogLevel refers to the log level used by the Application Controller component. Defaults to ArgoCDDefaultLogLevel if not configured. Valid options are debug, info, error, and warn.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logLevel;
    @JsonProperty(value="parallelismLimit")
    @JsonPropertyDescription(value="ParallelismLimit defines the limit for parallel kubectl operations")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer parallelismLimit;
    @JsonProperty(value="processors")
    @JsonPropertyDescription(value="Processors contains the options for the Application Controller processors.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Processors processors;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources defines the Compute Resources required by the container for the Application Controller.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="sharding")
    @JsonPropertyDescription(value="Sharding contains the options for the Application Controller sharding configuration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Sharding sharding;

    public ControllerBuilder edit() {
        return new ControllerBuilder(this);
    }

    public String getAppSync() {
        return this.appSync;
    }

    public void setAppSync(String appSync) {
        this.appSync = appSync;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<Env> getEnv() {
        return this.env;
    }

    public void setEnv(List<Env> env) {
        this.env = env;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public Integer getParallelismLimit() {
        return this.parallelismLimit;
    }

    public void setParallelismLimit(Integer parallelismLimit) {
        this.parallelismLimit = parallelismLimit;
    }

    public Processors getProcessors() {
        return this.processors;
    }

    public void setProcessors(Processors processors) {
        this.processors = processors;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Sharding getSharding() {
        return this.sharding;
    }

    public void setSharding(Sharding sharding) {
        this.sharding = sharding;
    }

    public String toString() {
        return "Controller(appSync=" + this.getAppSync() + ", enabled=" + this.getEnabled() + ", env=" + this.getEnv() + ", logFormat=" + this.getLogFormat() + ", logLevel=" + this.getLogLevel() + ", parallelismLimit=" + this.getParallelismLimit() + ", processors=" + this.getProcessors() + ", resources=" + this.getResources() + ", sharding=" + this.getSharding() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Controller)) {
            return false;
        }
        Controller other = (Controller)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$parallelismLimit = this.getParallelismLimit();
        Integer other$parallelismLimit = other.getParallelismLimit();
        if (this$parallelismLimit == null ? other$parallelismLimit != null : !((Object)this$parallelismLimit).equals(other$parallelismLimit)) {
            return false;
        }
        String this$appSync = this.getAppSync();
        String other$appSync = other.getAppSync();
        if (this$appSync == null ? other$appSync != null : !this$appSync.equals(other$appSync)) {
            return false;
        }
        List<Env> this$env = this.getEnv();
        List<Env> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$logFormat = this.getLogFormat();
        String other$logFormat = other.getLogFormat();
        if (this$logFormat == null ? other$logFormat != null : !this$logFormat.equals(other$logFormat)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        Processors this$processors = this.getProcessors();
        Processors other$processors = other.getProcessors();
        if (this$processors == null ? other$processors != null : !((Object)this$processors).equals(other$processors)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Sharding this$sharding = this.getSharding();
        Sharding other$sharding = other.getSharding();
        return !(this$sharding == null ? other$sharding != null : !((Object)this$sharding).equals(other$sharding));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Controller;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $parallelismLimit = this.getParallelismLimit();
        result = result * 59 + ($parallelismLimit == null ? 43 : ((Object)$parallelismLimit).hashCode());
        String $appSync = this.getAppSync();
        result = result * 59 + ($appSync == null ? 43 : $appSync.hashCode());
        List<Env> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $logFormat = this.getLogFormat();
        result = result * 59 + ($logFormat == null ? 43 : $logFormat.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        Processors $processors = this.getProcessors();
        result = result * 59 + ($processors == null ? 43 : ((Object)$processors).hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Sharding $sharding = this.getSharding();
        result = result * 59 + ($sharding == null ? 43 : ((Object)$sharding).hashCode());
        return result;
    }
}

