/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Controller;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.EnvBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.EnvFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Processors;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.ProcessorsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.ProcessorsFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.ResourcesFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Sharding;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.ShardingBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.ShardingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ControllerFluent<A extends ControllerFluent<A>>
extends BaseFluent<A> {
    private String appSync;
    private Boolean enabled;
    private ArrayList<EnvBuilder> env;
    private String logFormat;
    private String logLevel;
    private Integer parallelismLimit;
    private ProcessorsBuilder processors;
    private ResourcesBuilder resources;
    private ShardingBuilder sharding;

    public ControllerFluent() {
    }

    public ControllerFluent(Controller instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Controller instance) {
        Controller controller = instance = instance != null ? instance : new Controller();
        if (instance != null) {
            this.withAppSync(instance.getAppSync());
            this.withEnabled(instance.getEnabled());
            this.withEnv(instance.getEnv());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withParallelismLimit(instance.getParallelismLimit());
            this.withProcessors(instance.getProcessors());
            this.withResources(instance.getResources());
            this.withSharding(instance.getSharding());
        }
    }

    public String getAppSync() {
        return this.appSync;
    }

    public A withAppSync(String appSync) {
        this.appSync = appSync;
        return (A)((Object)this);
    }

    public boolean hasAppSync() {
        return this.appSync != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(Env ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToControllerEnv(Collection<Env> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(Env ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromControllerEnv(Collection<Env> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromControllerEnv(Predicate<EnvBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Env> buildEnv() {
        return this.env != null ? ControllerFluent.build(this.env) : null;
    }

    public Env buildEnv(int index) {
        return this.env.get(index).build();
    }

    public Env buildFirstEnv() {
        return this.env.get(0).build();
    }

    public Env buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<Env> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (Env item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(Env ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (Env item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(Env item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, Env item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)((Object)this);
    }

    public boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Integer getParallelismLimit() {
        return this.parallelismLimit;
    }

    public A withParallelismLimit(Integer parallelismLimit) {
        this.parallelismLimit = parallelismLimit;
        return (A)((Object)this);
    }

    public boolean hasParallelismLimit() {
        return this.parallelismLimit != null;
    }

    public Processors buildProcessors() {
        return this.processors != null ? this.processors.build() : null;
    }

    public A withProcessors(Processors processors) {
        this._visitables.remove((Object)"processors");
        if (processors != null) {
            this.processors = new ProcessorsBuilder(processors);
            this._visitables.get((Object)"processors").add(this.processors);
        } else {
            this.processors = null;
            this._visitables.get((Object)"processors").remove((Object)this.processors);
        }
        return (A)((Object)this);
    }

    public boolean hasProcessors() {
        return this.processors != null;
    }

    public ProcessorsNested<A> withNewProcessors() {
        return new ProcessorsNested(null);
    }

    public ProcessorsNested<A> withNewProcessorsLike(Processors item) {
        return new ProcessorsNested(item);
    }

    public ProcessorsNested<A> editProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(null));
    }

    public ProcessorsNested<A> editOrNewProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(new ProcessorsBuilder().build()));
    }

    public ProcessorsNested<A> editOrNewProcessorsLike(Processors item) {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(item));
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editControllerResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Sharding buildSharding() {
        return this.sharding != null ? this.sharding.build() : null;
    }

    public A withSharding(Sharding sharding) {
        this._visitables.remove((Object)"sharding");
        if (sharding != null) {
            this.sharding = new ShardingBuilder(sharding);
            this._visitables.get((Object)"sharding").add(this.sharding);
        } else {
            this.sharding = null;
            this._visitables.get((Object)"sharding").remove((Object)this.sharding);
        }
        return (A)((Object)this);
    }

    public boolean hasSharding() {
        return this.sharding != null;
    }

    public ShardingNested<A> withNewSharding() {
        return new ShardingNested(null);
    }

    public ShardingNested<A> withNewShardingLike(Sharding item) {
        return new ShardingNested(item);
    }

    public ShardingNested<A> editSharding() {
        return this.withNewShardingLike(Optional.ofNullable(this.buildSharding()).orElse(null));
    }

    public ShardingNested<A> editOrNewSharding() {
        return this.withNewShardingLike(Optional.ofNullable(this.buildSharding()).orElse(new ShardingBuilder().build()));
    }

    public ShardingNested<A> editOrNewShardingLike(Sharding item) {
        return this.withNewShardingLike(Optional.ofNullable(this.buildSharding()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ControllerFluent that = (ControllerFluent)((Object)o);
        if (!Objects.equals(this.appSync, that.appSync)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.parallelismLimit, that.parallelismLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.processors, (Object)that.processors)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        return Objects.equals((Object)this.sharding, (Object)that.sharding);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appSync, this.enabled, this.env, this.logFormat, this.logLevel, this.parallelismLimit, this.processors, this.resources, this.sharding, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appSync != null) {
            sb.append("appSync:");
            sb.append(this.appSync + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.parallelismLimit != null) {
            sb.append("parallelismLimit:");
            sb.append(this.parallelismLimit + ",");
        }
        if (this.processors != null) {
            sb.append("processors:");
            sb.append(this.processors + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.sharding != null) {
            sb.append("sharding:");
            sb.append((Object)this.sharding);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class EnvNested<N>
    extends EnvFluent<EnvNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)ControllerFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endControllerEnv() {
            return this.and();
        }
    }

    public class ProcessorsNested<N>
    extends ProcessorsFluent<ProcessorsNested<N>>
    implements Nested<N> {
        ProcessorsBuilder builder;

        ProcessorsNested(Processors item) {
            this.builder = new ProcessorsBuilder(this, item);
        }

        public N and() {
            return (N)ControllerFluent.this.withProcessors(this.builder.build());
        }

        public N endProcessors() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)ControllerFluent.this.withResources(this.builder.build());
        }

        public N endControllerResources() {
            return this.and();
        }
    }

    public class ShardingNested<N>
    extends ShardingFluent<ShardingNested<N>>
    implements Nested<N> {
        ShardingBuilder builder;

        ShardingNested(Sharding item) {
            this.builder = new ShardingBuilder(this, item);
        }

        public N and() {
            return (N)ControllerFluent.this.withSharding(this.builder.build());
        }

        public N endSharding() {
            return this.and();
        }
    }
}

