/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Grafana;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.Ingress;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.IngressBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.IngressFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.ResourcesFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.Route;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.RouteBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.grafana.RouteFluent;
import java.util.Objects;
import java.util.Optional;

public class GrafanaFluent<A extends GrafanaFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private String host;
    private String image;
    private IngressBuilder ingress;
    private ResourcesBuilder resources;
    private RouteBuilder route;
    private Integer size;
    private String version;

    public GrafanaFluent() {
    }

    public GrafanaFluent(Grafana instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Grafana instance) {
        Grafana grafana = instance = instance != null ? instance : new Grafana();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withHost(instance.getHost());
            this.withImage(instance.getImage());
            this.withIngress(instance.getIngress());
            this.withResources(instance.getResources());
            this.withRoute(instance.getRoute());
            this.withSize(instance.getSize());
            this.withVersion(instance.getVersion());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Ingress buildIngress() {
        return this.ingress != null ? this.ingress.build() : null;
    }

    public A withIngress(Ingress ingress) {
        this._visitables.remove((Object)"ingress");
        if (ingress != null) {
            this.ingress = new IngressBuilder(ingress);
            this._visitables.get((Object)"ingress").add(this.ingress);
        } else {
            this.ingress = null;
            this._visitables.get((Object)"ingress").remove((Object)this.ingress);
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null;
    }

    public IngressNested<A> withNewIngress() {
        return new IngressNested(null);
    }

    public IngressNested<A> withNewIngressLike(Ingress item) {
        return new IngressNested(item);
    }

    public IngressNested<A> editGrafanaIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(null));
    }

    public IngressNested<A> editOrNewIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(new IngressBuilder().build()));
    }

    public IngressNested<A> editOrNewIngressLike(Ingress item) {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(item));
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editGrafanaResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Route buildRoute() {
        return this.route != null ? this.route.build() : null;
    }

    public A withRoute(Route route) {
        this._visitables.remove((Object)"route");
        if (route != null) {
            this.route = new RouteBuilder(route);
            this._visitables.get((Object)"route").add(this.route);
        } else {
            this.route = null;
            this._visitables.get((Object)"route").remove((Object)this.route);
        }
        return (A)((Object)this);
    }

    public boolean hasRoute() {
        return this.route != null;
    }

    public RouteNested<A> withNewRoute() {
        return new RouteNested(null);
    }

    public RouteNested<A> withNewRouteLike(Route item) {
        return new RouteNested(item);
    }

    public RouteNested<A> editGrafanaRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(null));
    }

    public RouteNested<A> editOrNewRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(new RouteBuilder().build()));
    }

    public RouteNested<A> editOrNewRouteLike(Route item) {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(item));
    }

    public Integer getSize() {
        return this.size;
    }

    public A withSize(Integer size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GrafanaFluent that = (GrafanaFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.ingress, (Object)that.ingress)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.route, (Object)that.route)) {
            return false;
        }
        if (!Objects.equals(this.size, that.size)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.host, this.image, this.ingress, this.resources, this.route, this.size, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.route != null) {
            sb.append("route:");
            sb.append(this.route + ",");
        }
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class IngressNested<N>
    extends IngressFluent<IngressNested<N>>
    implements Nested<N> {
        IngressBuilder builder;

        IngressNested(Ingress item) {
            this.builder = new IngressBuilder(this, item);
        }

        public N and() {
            return (N)GrafanaFluent.this.withIngress(this.builder.build());
        }

        public N endGrafanaIngress() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)GrafanaFluent.this.withResources(this.builder.build());
        }

        public N endGrafanaResources() {
            return this.and();
        }
    }

    public class RouteNested<N>
    extends RouteFluent<RouteNested<N>>
    implements Nested<N> {
        RouteBuilder builder;

        RouteNested(Route item) {
            this.builder = new RouteBuilder(this, item);
        }

        public N and() {
            return (N)GrafanaFluent.this.withRoute(this.builder.build());
        }

        public N endGrafanaRoute() {
            return this.and();
        }
    }
}

