/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.NodePlacement;
import io.quarkiverse.argocd.v1beta1.argocdspec.nodeplacement.Tolerations;
import io.quarkiverse.argocd.v1beta1.argocdspec.nodeplacement.TolerationsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.nodeplacement.TolerationsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodePlacementFluent<A extends NodePlacementFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> nodeSelector;
    private ArrayList<TolerationsBuilder> tolerations;

    public NodePlacementFluent() {
    }

    public NodePlacementFluent(NodePlacement instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodePlacement instance) {
        NodePlacement nodePlacement = instance = instance != null ? instance : new NodePlacement();
        if (instance != null) {
            this.withNodeSelector(instance.getNodeSelector());
            this.withTolerations(instance.getTolerations());
        }
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToTolerations(int index, Tolerations item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        TolerationsBuilder builder = new TolerationsBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get((Object)"tolerations").add(index, builder);
            this.tolerations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Tolerations item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        TolerationsBuilder builder = new TolerationsBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get((Object)"tolerations").set(index, builder);
            this.tolerations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTolerations(Tolerations ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (Tolerations item : items) {
            TolerationsBuilder builder = new TolerationsBuilder(item);
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Tolerations> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (Tolerations item : items) {
            TolerationsBuilder builder = new TolerationsBuilder(item);
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Tolerations ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Tolerations item : items) {
            TolerationsBuilder builder = new TolerationsBuilder(item);
            this._visitables.get((Object)"tolerations").remove((Object)builder);
            this.tolerations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Tolerations> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Tolerations item : items) {
            TolerationsBuilder builder = new TolerationsBuilder(item);
            this._visitables.get((Object)"tolerations").remove((Object)builder);
            this.tolerations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTolerations(Predicate<TolerationsBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        Iterator<TolerationsBuilder> each = this.tolerations.iterator();
        List visitables = this._visitables.get((Object)"tolerations");
        while (each.hasNext()) {
            TolerationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Tolerations> buildTolerations() {
        return this.tolerations != null ? NodePlacementFluent.build(this.tolerations) : null;
    }

    public Tolerations buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public Tolerations buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public Tolerations buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public Tolerations buildMatchingToleration(Predicate<TolerationsBuilder> predicate) {
        for (TolerationsBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<TolerationsBuilder> predicate) {
        for (TolerationsBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Tolerations> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get((Object)"tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (Tolerations item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Tolerations ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Tolerations item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public TolerationsNested<A> addNewTolerationLike(Tolerations item) {
        return new TolerationsNested(-1, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, Tolerations item) {
        return new TolerationsNested(index, item);
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<TolerationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodePlacementFluent that = (NodePlacementFluent)((Object)o);
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        return Objects.equals(this.tolerations, that.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector, this.tolerations, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TolerationsNested<N>
    extends TolerationsFluent<TolerationsNested<N>>
    implements Nested<N> {
        TolerationsBuilder builder;
        int index;

        TolerationsNested(int index, Tolerations item) {
            this.index = index;
            this.builder = new TolerationsBuilder(this, item);
        }

        public N and() {
            return (N)NodePlacementFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }
}

