/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Notifications;
import io.quarkiverse.argocd.v1beta1.argocdspec.notifications.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.notifications.EnvBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.notifications.EnvFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.notifications.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.notifications.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.notifications.ResourcesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NotificationsFluent<A extends NotificationsFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private ArrayList<EnvBuilder> env;
    private String image;
    private String logLevel;
    private Integer replicas;
    private ResourcesBuilder resources;
    private String version;

    public NotificationsFluent() {
    }

    public NotificationsFluent(Notifications instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Notifications instance) {
        Notifications notifications = instance = instance != null ? instance : new Notifications();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withEnv(instance.getEnv());
            this.withImage(instance.getImage());
            this.withLogLevel(instance.getLogLevel());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withVersion(instance.getVersion());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(Env ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToNotificationsEnv(Collection<Env> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(Env ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNotificationsEnv(Collection<Env> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromNotificationsEnv(Predicate<EnvBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Env> buildEnv() {
        return this.env != null ? NotificationsFluent.build(this.env) : null;
    }

    public Env buildEnv(int index) {
        return this.env.get(index).build();
    }

    public Env buildFirstEnv() {
        return this.env.get(0).build();
    }

    public Env buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<Env> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (Env item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(Env ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (Env item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(Env item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, Env item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editNotificationsResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotificationsFluent that = (NotificationsFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.env, this.image, this.logLevel, this.replicas, this.resources, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class EnvNested<N>
    extends EnvFluent<EnvNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)NotificationsFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endNotificationsEnv() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)NotificationsFluent.this.withResources(this.builder.build());
        }

        public N endNotificationsResources() {
            return this.and();
        }
    }
}

