/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Prometheus;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.Ingress;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.IngressBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.IngressFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.Route;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.RouteBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.RouteFluent;
import java.util.Objects;
import java.util.Optional;

public class PrometheusFluent<A extends PrometheusFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private String host;
    private IngressBuilder ingress;
    private RouteBuilder route;
    private Integer size;

    public PrometheusFluent() {
    }

    public PrometheusFluent(Prometheus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Prometheus instance) {
        Prometheus prometheus = instance = instance != null ? instance : new Prometheus();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withHost(instance.getHost());
            this.withIngress(instance.getIngress());
            this.withRoute(instance.getRoute());
            this.withSize(instance.getSize());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public Ingress buildIngress() {
        return this.ingress != null ? this.ingress.build() : null;
    }

    public A withIngress(Ingress ingress) {
        this._visitables.remove((Object)"ingress");
        if (ingress != null) {
            this.ingress = new IngressBuilder(ingress);
            this._visitables.get((Object)"ingress").add(this.ingress);
        } else {
            this.ingress = null;
            this._visitables.get((Object)"ingress").remove((Object)this.ingress);
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null;
    }

    public IngressNested<A> withNewIngress() {
        return new IngressNested(null);
    }

    public IngressNested<A> withNewIngressLike(Ingress item) {
        return new IngressNested(item);
    }

    public IngressNested<A> editPrometheusIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(null));
    }

    public IngressNested<A> editOrNewIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(new IngressBuilder().build()));
    }

    public IngressNested<A> editOrNewIngressLike(Ingress item) {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(item));
    }

    public Route buildRoute() {
        return this.route != null ? this.route.build() : null;
    }

    public A withRoute(Route route) {
        this._visitables.remove((Object)"route");
        if (route != null) {
            this.route = new RouteBuilder(route);
            this._visitables.get((Object)"route").add(this.route);
        } else {
            this.route = null;
            this._visitables.get((Object)"route").remove((Object)this.route);
        }
        return (A)((Object)this);
    }

    public boolean hasRoute() {
        return this.route != null;
    }

    public RouteNested<A> withNewRoute() {
        return new RouteNested(null);
    }

    public RouteNested<A> withNewRouteLike(Route item) {
        return new RouteNested(item);
    }

    public RouteNested<A> editPrometheusRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(null));
    }

    public RouteNested<A> editOrNewRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(new RouteBuilder().build()));
    }

    public RouteNested<A> editOrNewRouteLike(Route item) {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(item));
    }

    public Integer getSize() {
        return this.size;
    }

    public A withSize(Integer size) {
        this.size = size;
        return (A)((Object)this);
    }

    public boolean hasSize() {
        return this.size != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrometheusFluent that = (PrometheusFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals((Object)this.ingress, (Object)that.ingress)) {
            return false;
        }
        if (!Objects.equals((Object)this.route, (Object)that.route)) {
            return false;
        }
        return Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.host, this.ingress, this.route, this.size, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.route != null) {
            sb.append("route:");
            sb.append(this.route + ",");
        }
        if (this.size != null) {
            sb.append("size:");
            sb.append(this.size);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class IngressNested<N>
    extends IngressFluent<IngressNested<N>>
    implements Nested<N> {
        IngressBuilder builder;

        IngressNested(Ingress item) {
            this.builder = new IngressBuilder(this, item);
        }

        public N and() {
            return (N)PrometheusFluent.this.withIngress(this.builder.build());
        }

        public N endPrometheusIngress() {
            return this.and();
        }
    }

    public class RouteNested<N>
    extends RouteFluent<RouteNested<N>>
    implements Nested<N> {
        RouteBuilder builder;

        RouteNested(Route item) {
            this.builder = new RouteBuilder(this, item);
        }

        public N and() {
            return (N)PrometheusFluent.this.withRoute(this.builder.build());
        }

        public N endPrometheusRoute() {
            return this.and();
        }
    }
}

