/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.RbacBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"defaultPolicy", "policy", "policyMatcherMode", "scopes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Rbac
implements Editable<RbacBuilder>,
KubernetesResource {
    @JsonProperty(value="defaultPolicy")
    @JsonPropertyDescription(value="DefaultPolicy is the name of the default role which Argo CD will falls back to, when authorizing API requests (optional). If omitted or empty, users may be still be able to login, but will see no apps, projects, etc...")
    @JsonSetter(nulls=Nulls.SKIP)
    private String defaultPolicy;
    @JsonProperty(value="policy")
    @JsonPropertyDescription(value="Policy is CSV containing user-defined RBAC policies and role definitions. Policy rules are in the form:   p, subject, resource, action, object, effect Role definitions and bindings are in the form:   g, subject, inherited-subject See https://github.com/argoproj/argo-cd/blob/master/docs/operator-manual/rbac.md for additional information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String policy;
    @JsonProperty(value="policyMatcherMode")
    @JsonPropertyDescription(value="PolicyMatcherMode configures the matchers function mode for casbin. There are two options for this, 'glob' for glob matcher or 'regex' for regex matcher.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String policyMatcherMode;
    @JsonProperty(value="scopes")
    @JsonPropertyDescription(value="Scopes controls which OIDC scopes to examine during rbac enforcement (in addition to `sub` scope). If omitted, defaults to: '[groups]'.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String scopes;

    public RbacBuilder edit() {
        return new RbacBuilder(this);
    }

    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getPolicyMatcherMode() {
        return this.policyMatcherMode;
    }

    public void setPolicyMatcherMode(String policyMatcherMode) {
        this.policyMatcherMode = policyMatcherMode;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String toString() {
        return "Rbac(defaultPolicy=" + this.getDefaultPolicy() + ", policy=" + this.getPolicy() + ", policyMatcherMode=" + this.getPolicyMatcherMode() + ", scopes=" + this.getScopes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rbac)) {
            return false;
        }
        Rbac other = (Rbac)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$defaultPolicy = this.getDefaultPolicy();
        String other$defaultPolicy = other.getDefaultPolicy();
        if (this$defaultPolicy == null ? other$defaultPolicy != null : !this$defaultPolicy.equals(other$defaultPolicy)) {
            return false;
        }
        String this$policy = this.getPolicy();
        String other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !this$policy.equals(other$policy)) {
            return false;
        }
        String this$policyMatcherMode = this.getPolicyMatcherMode();
        String other$policyMatcherMode = other.getPolicyMatcherMode();
        if (this$policyMatcherMode == null ? other$policyMatcherMode != null : !this$policyMatcherMode.equals(other$policyMatcherMode)) {
            return false;
        }
        String this$scopes = this.getScopes();
        String other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !this$scopes.equals(other$scopes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rbac;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $defaultPolicy = this.getDefaultPolicy();
        result = result * 59 + ($defaultPolicy == null ? 43 : $defaultPolicy.hashCode());
        String $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : $policy.hashCode());
        String $policyMatcherMode = this.getPolicyMatcherMode();
        result = result * 59 + ($policyMatcherMode == null ? 43 : $policyMatcherMode.hashCode());
        String $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : $scopes.hashCode());
        return result;
    }
}

