/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Redis;
import io.quarkiverse.argocd.v1beta1.argocdspec.redis.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.redis.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.redis.ResourcesFluent;
import java.util.Objects;
import java.util.Optional;

public class RedisFluent<A extends RedisFluent<A>>
extends BaseFluent<A> {
    private String autotls;
    private Boolean disableTLSVerification;
    private Boolean enabled;
    private String image;
    private String remote;
    private ResourcesBuilder resources;
    private String version;

    public RedisFluent() {
    }

    public RedisFluent(Redis instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Redis instance) {
        Redis redis = instance = instance != null ? instance : new Redis();
        if (instance != null) {
            this.withAutotls(instance.getAutotls());
            this.withDisableTLSVerification(instance.getDisableTLSVerification());
            this.withEnabled(instance.getEnabled());
            this.withImage(instance.getImage());
            this.withRemote(instance.getRemote());
            this.withResources(instance.getResources());
            this.withVersion(instance.getVersion());
        }
    }

    public String getAutotls() {
        return this.autotls;
    }

    public A withAutotls(String autotls) {
        this.autotls = autotls;
        return (A)((Object)this);
    }

    public boolean hasAutotls() {
        return this.autotls != null;
    }

    public Boolean getDisableTLSVerification() {
        return this.disableTLSVerification;
    }

    public A withDisableTLSVerification(Boolean disableTLSVerification) {
        this.disableTLSVerification = disableTLSVerification;
        return (A)((Object)this);
    }

    public boolean hasDisableTLSVerification() {
        return this.disableTLSVerification != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getRemote() {
        return this.remote;
    }

    public A withRemote(String remote) {
        this.remote = remote;
        return (A)((Object)this);
    }

    public boolean hasRemote() {
        return this.remote != null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editRedisResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedisFluent that = (RedisFluent)((Object)o);
        if (!Objects.equals(this.autotls, that.autotls)) {
            return false;
        }
        if (!Objects.equals(this.disableTLSVerification, that.disableTLSVerification)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.remote, that.remote)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autotls, this.disableTLSVerification, this.enabled, this.image, this.remote, this.resources, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autotls != null) {
            sb.append("autotls:");
            sb.append(this.autotls + ",");
        }
        if (this.disableTLSVerification != null) {
            sb.append("disableTLSVerification:");
            sb.append(this.disableTLSVerification + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.remote != null) {
            sb.append("remote:");
            sb.append(this.remote + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableTLSVerification() {
        return this.withDisableTLSVerification(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)RedisFluent.this.withResources(this.builder.build());
        }

        public N endRedisResources() {
            return this.and();
        }
    }
}

