/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.RepoBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.InitContainers;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.SidecarContainers;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.VolumeMounts;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.Volumes;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"autotls", "enabled", "env", "execTimeout", "extraRepoCommandArgs", "image", "initContainers", "logFormat", "logLevel", "mountsatoken", "remote", "replicas", "resources", "serviceaccount", "sidecarContainers", "verifytls", "version", "volumeMounts", "volumes"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Repo
implements Editable<RepoBuilder>,
KubernetesResource {
    @JsonProperty(value="autotls")
    @JsonPropertyDescription(value="AutoTLS specifies the method to use for automatic TLS configuration for the repo server The value specified here can currently be: - openshift - Use the OpenShift service CA to request TLS config")
    @JsonSetter(nulls=Nulls.SKIP)
    private String autotls;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Enabled is the flag to enable Repo Server during ArgoCD installation. (optional, default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="Env lets you specify environment for repo server pods")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Env> env;
    @JsonProperty(value="execTimeout")
    @JsonPropertyDescription(value="ExecTimeout specifies the timeout in seconds for tool execution")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long execTimeout;
    @JsonProperty(value="extraRepoCommandArgs")
    @JsonPropertyDescription(value="Extra Command arguments allows users to pass command line arguments to repo server workload. They get added to default command line arguments provided by the operator. Please note that the command line arguments provided as part of ExtraRepoCommandArgs will not overwrite the default command line arguments.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> extraRepoCommandArgs;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Image is the ArgoCD Repo Server container image.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="initContainers")
    @JsonPropertyDescription(value="InitContainers defines the list of initialization containers for the repo server deployment")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<InitContainers> initContainers;
    @JsonProperty(value="logFormat")
    @JsonPropertyDescription(value="LogFormat describes the log format that should be used by the Repo Server. Defaults to ArgoCDDefaultLogFormat if not configured. Valid options are text or json.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logFormat;
    @JsonProperty(value="logLevel")
    @JsonPropertyDescription(value="LogLevel describes the log level that should be used by the Repo Server. Defaults to ArgoCDDefaultLogLevel if not set.  Valid options are debug, info, error, and warn.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logLevel;
    @JsonProperty(value="mountsatoken")
    @JsonPropertyDescription(value="MountSAToken describes whether you would like to have the Repo server mount the service account token")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean mountsatoken;
    @JsonProperty(value="remote")
    @JsonPropertyDescription(value="Remote specifies the remote URL of the Repo Server container. (optional, by default, a local instance managed by the operator is used.)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String remote;
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="Replicas defines the number of replicas for argocd-repo-server. Value should be greater than or equal to 0. Default is nil.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer replicas;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources defines the Compute Resources required by the container for Redis.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="serviceaccount")
    @JsonPropertyDescription(value="ServiceAccount defines the ServiceAccount user that you would like the Repo server to use")
    @JsonSetter(nulls=Nulls.SKIP)
    private String serviceaccount;
    @JsonProperty(value="sidecarContainers")
    @JsonPropertyDescription(value="SidecarContainers defines the list of sidecar containers for the repo server deployment")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<SidecarContainers> sidecarContainers;
    @JsonProperty(value="verifytls")
    @JsonPropertyDescription(value="VerifyTLS defines whether repo server API should be accessed using strict TLS validation")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean verifytls;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version is the ArgoCD Repo Server container image tag.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;
    @JsonProperty(value="volumeMounts")
    @JsonPropertyDescription(value="VolumeMounts adds volumeMounts to the repo server container")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<VolumeMounts> volumeMounts;
    @JsonProperty(value="volumes")
    @JsonPropertyDescription(value="Volumes adds volumes to the repo server deployment")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Volumes> volumes;

    public RepoBuilder edit() {
        return new RepoBuilder(this);
    }

    public String getAutotls() {
        return this.autotls;
    }

    public void setAutotls(String autotls) {
        this.autotls = autotls;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<Env> getEnv() {
        return this.env;
    }

    public void setEnv(List<Env> env) {
        this.env = env;
    }

    public Long getExecTimeout() {
        return this.execTimeout;
    }

    public void setExecTimeout(Long execTimeout) {
        this.execTimeout = execTimeout;
    }

    public List<String> getExtraRepoCommandArgs() {
        return this.extraRepoCommandArgs;
    }

    public void setExtraRepoCommandArgs(List<String> extraRepoCommandArgs) {
        this.extraRepoCommandArgs = extraRepoCommandArgs;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public List<InitContainers> getInitContainers() {
        return this.initContainers;
    }

    public void setInitContainers(List<InitContainers> initContainers) {
        this.initContainers = initContainers;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public Boolean getMountsatoken() {
        return this.mountsatoken;
    }

    public void setMountsatoken(Boolean mountsatoken) {
        this.mountsatoken = mountsatoken;
    }

    public String getRemote() {
        return this.remote;
    }

    public void setRemote(String remote) {
        this.remote = remote;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public String getServiceaccount() {
        return this.serviceaccount;
    }

    public void setServiceaccount(String serviceaccount) {
        this.serviceaccount = serviceaccount;
    }

    public List<SidecarContainers> getSidecarContainers() {
        return this.sidecarContainers;
    }

    public void setSidecarContainers(List<SidecarContainers> sidecarContainers) {
        this.sidecarContainers = sidecarContainers;
    }

    public Boolean getVerifytls() {
        return this.verifytls;
    }

    public void setVerifytls(Boolean verifytls) {
        this.verifytls = verifytls;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<VolumeMounts> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMounts> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public List<Volumes> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<Volumes> volumes) {
        this.volumes = volumes;
    }

    public String toString() {
        return "Repo(autotls=" + this.getAutotls() + ", enabled=" + this.getEnabled() + ", env=" + this.getEnv() + ", execTimeout=" + this.getExecTimeout() + ", extraRepoCommandArgs=" + this.getExtraRepoCommandArgs() + ", image=" + this.getImage() + ", initContainers=" + this.getInitContainers() + ", logFormat=" + this.getLogFormat() + ", logLevel=" + this.getLogLevel() + ", mountsatoken=" + this.getMountsatoken() + ", remote=" + this.getRemote() + ", replicas=" + this.getReplicas() + ", resources=" + this.getResources() + ", serviceaccount=" + this.getServiceaccount() + ", sidecarContainers=" + this.getSidecarContainers() + ", verifytls=" + this.getVerifytls() + ", version=" + this.getVersion() + ", volumeMounts=" + this.getVolumeMounts() + ", volumes=" + this.getVolumes() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Repo)) {
            return false;
        }
        Repo other = (Repo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Long this$execTimeout = this.getExecTimeout();
        Long other$execTimeout = other.getExecTimeout();
        if (this$execTimeout == null ? other$execTimeout != null : !((Object)this$execTimeout).equals(other$execTimeout)) {
            return false;
        }
        Boolean this$mountsatoken = this.getMountsatoken();
        Boolean other$mountsatoken = other.getMountsatoken();
        if (this$mountsatoken == null ? other$mountsatoken != null : !((Object)this$mountsatoken).equals(other$mountsatoken)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Boolean this$verifytls = this.getVerifytls();
        Boolean other$verifytls = other.getVerifytls();
        if (this$verifytls == null ? other$verifytls != null : !((Object)this$verifytls).equals(other$verifytls)) {
            return false;
        }
        String this$autotls = this.getAutotls();
        String other$autotls = other.getAutotls();
        if (this$autotls == null ? other$autotls != null : !this$autotls.equals(other$autotls)) {
            return false;
        }
        List<Env> this$env = this.getEnv();
        List<Env> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<String> this$extraRepoCommandArgs = this.getExtraRepoCommandArgs();
        List<String> other$extraRepoCommandArgs = other.getExtraRepoCommandArgs();
        if (this$extraRepoCommandArgs == null ? other$extraRepoCommandArgs != null : !((Object)this$extraRepoCommandArgs).equals(other$extraRepoCommandArgs)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<InitContainers> this$initContainers = this.getInitContainers();
        List<InitContainers> other$initContainers = other.getInitContainers();
        if (this$initContainers == null ? other$initContainers != null : !((Object)this$initContainers).equals(other$initContainers)) {
            return false;
        }
        String this$logFormat = this.getLogFormat();
        String other$logFormat = other.getLogFormat();
        if (this$logFormat == null ? other$logFormat != null : !this$logFormat.equals(other$logFormat)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        String this$remote = this.getRemote();
        String other$remote = other.getRemote();
        if (this$remote == null ? other$remote != null : !this$remote.equals(other$remote)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$serviceaccount = this.getServiceaccount();
        String other$serviceaccount = other.getServiceaccount();
        if (this$serviceaccount == null ? other$serviceaccount != null : !this$serviceaccount.equals(other$serviceaccount)) {
            return false;
        }
        List<SidecarContainers> this$sidecarContainers = this.getSidecarContainers();
        List<SidecarContainers> other$sidecarContainers = other.getSidecarContainers();
        if (this$sidecarContainers == null ? other$sidecarContainers != null : !((Object)this$sidecarContainers).equals(other$sidecarContainers)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<VolumeMounts> this$volumeMounts = this.getVolumeMounts();
        List<VolumeMounts> other$volumeMounts = other.getVolumeMounts();
        if (this$volumeMounts == null ? other$volumeMounts != null : !((Object)this$volumeMounts).equals(other$volumeMounts)) {
            return false;
        }
        List<Volumes> this$volumes = this.getVolumes();
        List<Volumes> other$volumes = other.getVolumes();
        return !(this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Repo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Long $execTimeout = this.getExecTimeout();
        result = result * 59 + ($execTimeout == null ? 43 : ((Object)$execTimeout).hashCode());
        Boolean $mountsatoken = this.getMountsatoken();
        result = result * 59 + ($mountsatoken == null ? 43 : ((Object)$mountsatoken).hashCode());
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        Boolean $verifytls = this.getVerifytls();
        result = result * 59 + ($verifytls == null ? 43 : ((Object)$verifytls).hashCode());
        String $autotls = this.getAutotls();
        result = result * 59 + ($autotls == null ? 43 : $autotls.hashCode());
        List<Env> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<String> $extraRepoCommandArgs = this.getExtraRepoCommandArgs();
        result = result * 59 + ($extraRepoCommandArgs == null ? 43 : ((Object)$extraRepoCommandArgs).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<InitContainers> $initContainers = this.getInitContainers();
        result = result * 59 + ($initContainers == null ? 43 : ((Object)$initContainers).hashCode());
        String $logFormat = this.getLogFormat();
        result = result * 59 + ($logFormat == null ? 43 : $logFormat.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        String $remote = this.getRemote();
        result = result * 59 + ($remote == null ? 43 : $remote.hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $serviceaccount = this.getServiceaccount();
        result = result * 59 + ($serviceaccount == null ? 43 : $serviceaccount.hashCode());
        List<SidecarContainers> $sidecarContainers = this.getSidecarContainers();
        result = result * 59 + ($sidecarContainers == null ? 43 : ((Object)$sidecarContainers).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<VolumeMounts> $volumeMounts = this.getVolumeMounts();
        result = result * 59 + ($volumeMounts == null ? 43 : ((Object)$volumeMounts).hashCode());
        List<Volumes> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        return result;
    }
}

