/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Repo;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.EnvBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.EnvFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.InitContainers;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.InitContainersBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.InitContainersFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.ResourcesFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.SidecarContainers;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.SidecarContainersBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.SidecarContainersFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.VolumeMounts;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.VolumeMountsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.VolumeMountsFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.Volumes;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.VolumesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.VolumesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RepoFluent<A extends RepoFluent<A>>
extends BaseFluent<A> {
    private String autotls;
    private Boolean enabled;
    private ArrayList<EnvBuilder> env;
    private Long execTimeout;
    private List<String> extraRepoCommandArgs;
    private String image;
    private ArrayList<InitContainersBuilder> initContainers;
    private String logFormat;
    private String logLevel;
    private Boolean mountsatoken;
    private String remote;
    private Integer replicas;
    private ResourcesBuilder resources;
    private String serviceaccount;
    private ArrayList<SidecarContainersBuilder> sidecarContainers;
    private Boolean verifytls;
    private String version;
    private ArrayList<VolumeMountsBuilder> volumeMounts;
    private ArrayList<VolumesBuilder> volumes;

    public RepoFluent() {
    }

    public RepoFluent(Repo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Repo instance) {
        Repo repo = instance = instance != null ? instance : new Repo();
        if (instance != null) {
            this.withAutotls(instance.getAutotls());
            this.withEnabled(instance.getEnabled());
            this.withEnv(instance.getEnv());
            this.withExecTimeout(instance.getExecTimeout());
            this.withExtraRepoCommandArgs(instance.getExtraRepoCommandArgs());
            this.withImage(instance.getImage());
            this.withInitContainers(instance.getInitContainers());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withMountsatoken(instance.getMountsatoken());
            this.withRemote(instance.getRemote());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withServiceaccount(instance.getServiceaccount());
            this.withSidecarContainers(instance.getSidecarContainers());
            this.withVerifytls(instance.getVerifytls());
            this.withVersion(instance.getVersion());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withVolumes(instance.getVolumes());
        }
    }

    public String getAutotls() {
        return this.autotls;
    }

    public A withAutotls(String autotls) {
        this.autotls = autotls;
        return (A)((Object)this);
    }

    public boolean hasAutotls() {
        return this.autotls != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(Env ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRepoEnv(Collection<Env> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(Env ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRepoEnv(Collection<Env> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRepoEnv(Predicate<EnvBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Env> buildEnv() {
        return this.env != null ? RepoFluent.build(this.env) : null;
    }

    public Env buildEnv(int index) {
        return this.env.get(index).build();
    }

    public Env buildFirstEnv() {
        return this.env.get(0).build();
    }

    public Env buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<Env> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (Env item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(Env ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (Env item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(Env item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, Env item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public Long getExecTimeout() {
        return this.execTimeout;
    }

    public A withExecTimeout(Long execTimeout) {
        this.execTimeout = execTimeout;
        return (A)((Object)this);
    }

    public boolean hasExecTimeout() {
        return this.execTimeout != null;
    }

    public A addToExtraRepoCommandArgs(int index, String item) {
        if (this.extraRepoCommandArgs == null) {
            this.extraRepoCommandArgs = new ArrayList<String>();
        }
        this.extraRepoCommandArgs.add(index, item);
        return (A)((Object)this);
    }

    public A setToExtraRepoCommandArgs(int index, String item) {
        if (this.extraRepoCommandArgs == null) {
            this.extraRepoCommandArgs = new ArrayList<String>();
        }
        this.extraRepoCommandArgs.set(index, item);
        return (A)((Object)this);
    }

    public A addToExtraRepoCommandArgs(String ... items) {
        if (this.extraRepoCommandArgs == null) {
            this.extraRepoCommandArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraRepoCommandArgs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExtraRepoCommandArgs(Collection<String> items) {
        if (this.extraRepoCommandArgs == null) {
            this.extraRepoCommandArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraRepoCommandArgs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExtraRepoCommandArgs(String ... items) {
        if (this.extraRepoCommandArgs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extraRepoCommandArgs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtraRepoCommandArgs(Collection<String> items) {
        if (this.extraRepoCommandArgs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extraRepoCommandArgs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExtraRepoCommandArgs() {
        return this.extraRepoCommandArgs;
    }

    public String getExtraRepoCommandArg(int index) {
        return this.extraRepoCommandArgs.get(index);
    }

    public String getFirstExtraRepoCommandArg() {
        return this.extraRepoCommandArgs.get(0);
    }

    public String getLastExtraRepoCommandArg() {
        return this.extraRepoCommandArgs.get(this.extraRepoCommandArgs.size() - 1);
    }

    public String getMatchingExtraRepoCommandArg(Predicate<String> predicate) {
        for (String item : this.extraRepoCommandArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExtraRepoCommandArg(Predicate<String> predicate) {
        for (String item : this.extraRepoCommandArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtraRepoCommandArgs(List<String> extraRepoCommandArgs) {
        if (extraRepoCommandArgs != null) {
            this.extraRepoCommandArgs = new ArrayList<String>();
            for (String item : extraRepoCommandArgs) {
                this.addToExtraRepoCommandArgs(item);
            }
        } else {
            this.extraRepoCommandArgs = null;
        }
        return (A)((Object)this);
    }

    public A withExtraRepoCommandArgs(String ... extraRepoCommandArgs) {
        if (this.extraRepoCommandArgs != null) {
            this.extraRepoCommandArgs.clear();
            this._visitables.remove((Object)"extraRepoCommandArgs");
        }
        if (extraRepoCommandArgs != null) {
            for (String item : extraRepoCommandArgs) {
                this.addToExtraRepoCommandArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtraRepoCommandArgs() {
        return this.extraRepoCommandArgs != null && !this.extraRepoCommandArgs.isEmpty();
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A addToInitContainers(int index, InitContainers item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        InitContainersBuilder builder = new InitContainersBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInitContainers(int index, InitContainers item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        InitContainersBuilder builder = new InitContainersBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInitContainers(InitContainers ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInitContainers(Collection<InitContainers> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInitContainers(InitContainers ... items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").remove((Object)builder);
            this.initContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInitContainers(Collection<InitContainers> items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").remove((Object)builder);
            this.initContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInitContainers(Predicate<InitContainersBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        Iterator<InitContainersBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            InitContainersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<InitContainers> buildInitContainers() {
        return this.initContainers != null ? RepoFluent.build(this.initContainers) : null;
    }

    public InitContainers buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public InitContainers buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public InitContainers buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public InitContainers buildMatchingInitContainer(Predicate<InitContainersBuilder> predicate) {
        for (InitContainersBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<InitContainersBuilder> predicate) {
        for (InitContainersBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainers(List<InitContainers> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (InitContainers item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)((Object)this);
    }

    public A withInitContainers(InitContainers ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove((Object)"initContainers");
        }
        if (initContainers != null) {
            for (InitContainers item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(InitContainers item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, InitContainers item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<InitContainersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)((Object)this);
    }

    public boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Boolean getMountsatoken() {
        return this.mountsatoken;
    }

    public A withMountsatoken(Boolean mountsatoken) {
        this.mountsatoken = mountsatoken;
        return (A)((Object)this);
    }

    public boolean hasMountsatoken() {
        return this.mountsatoken != null;
    }

    public String getRemote() {
        return this.remote;
    }

    public A withRemote(String remote) {
        this.remote = remote;
        return (A)((Object)this);
    }

    public boolean hasRemote() {
        return this.remote != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editRepoResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getServiceaccount() {
        return this.serviceaccount;
    }

    public A withServiceaccount(String serviceaccount) {
        this.serviceaccount = serviceaccount;
        return (A)((Object)this);
    }

    public boolean hasServiceaccount() {
        return this.serviceaccount != null;
    }

    public A addToSidecarContainers(int index, SidecarContainers item) {
        if (this.sidecarContainers == null) {
            this.sidecarContainers = new ArrayList();
        }
        SidecarContainersBuilder builder = new SidecarContainersBuilder(item);
        if (index < 0 || index >= this.sidecarContainers.size()) {
            this._visitables.get((Object)"sidecarContainers").add(builder);
            this.sidecarContainers.add(builder);
        } else {
            this._visitables.get((Object)"sidecarContainers").add(index, builder);
            this.sidecarContainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSidecarContainers(int index, SidecarContainers item) {
        if (this.sidecarContainers == null) {
            this.sidecarContainers = new ArrayList();
        }
        SidecarContainersBuilder builder = new SidecarContainersBuilder(item);
        if (index < 0 || index >= this.sidecarContainers.size()) {
            this._visitables.get((Object)"sidecarContainers").add(builder);
            this.sidecarContainers.add(builder);
        } else {
            this._visitables.get((Object)"sidecarContainers").set(index, builder);
            this.sidecarContainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecarContainers(SidecarContainers ... items) {
        if (this.sidecarContainers == null) {
            this.sidecarContainers = new ArrayList();
        }
        for (SidecarContainers item : items) {
            SidecarContainersBuilder builder = new SidecarContainersBuilder(item);
            this._visitables.get((Object)"sidecarContainers").add(builder);
            this.sidecarContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSidecarContainers(Collection<SidecarContainers> items) {
        if (this.sidecarContainers == null) {
            this.sidecarContainers = new ArrayList();
        }
        for (SidecarContainers item : items) {
            SidecarContainersBuilder builder = new SidecarContainersBuilder(item);
            this._visitables.get((Object)"sidecarContainers").add(builder);
            this.sidecarContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSidecarContainers(SidecarContainers ... items) {
        if (this.sidecarContainers == null) {
            return (A)((Object)this);
        }
        for (SidecarContainers item : items) {
            SidecarContainersBuilder builder = new SidecarContainersBuilder(item);
            this._visitables.get((Object)"sidecarContainers").remove((Object)builder);
            this.sidecarContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSidecarContainers(Collection<SidecarContainers> items) {
        if (this.sidecarContainers == null) {
            return (A)((Object)this);
        }
        for (SidecarContainers item : items) {
            SidecarContainersBuilder builder = new SidecarContainersBuilder(item);
            this._visitables.get((Object)"sidecarContainers").remove((Object)builder);
            this.sidecarContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecarContainers(Predicate<SidecarContainersBuilder> predicate) {
        if (this.sidecarContainers == null) {
            return (A)((Object)this);
        }
        Iterator<SidecarContainersBuilder> each = this.sidecarContainers.iterator();
        List visitables = this._visitables.get((Object)"sidecarContainers");
        while (each.hasNext()) {
            SidecarContainersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SidecarContainers> buildSidecarContainers() {
        return this.sidecarContainers != null ? RepoFluent.build(this.sidecarContainers) : null;
    }

    public SidecarContainers buildSidecarContainer(int index) {
        return this.sidecarContainers.get(index).build();
    }

    public SidecarContainers buildFirstSidecarContainer() {
        return this.sidecarContainers.get(0).build();
    }

    public SidecarContainers buildLastSidecarContainer() {
        return this.sidecarContainers.get(this.sidecarContainers.size() - 1).build();
    }

    public SidecarContainers buildMatchingSidecarContainer(Predicate<SidecarContainersBuilder> predicate) {
        for (SidecarContainersBuilder item : this.sidecarContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSidecarContainer(Predicate<SidecarContainersBuilder> predicate) {
        for (SidecarContainersBuilder item : this.sidecarContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSidecarContainers(List<SidecarContainers> sidecarContainers) {
        if (this.sidecarContainers != null) {
            this._visitables.get((Object)"sidecarContainers").clear();
        }
        if (sidecarContainers != null) {
            this.sidecarContainers = new ArrayList();
            for (SidecarContainers item : sidecarContainers) {
                this.addToSidecarContainers(item);
            }
        } else {
            this.sidecarContainers = null;
        }
        return (A)((Object)this);
    }

    public A withSidecarContainers(SidecarContainers ... sidecarContainers) {
        if (this.sidecarContainers != null) {
            this.sidecarContainers.clear();
            this._visitables.remove((Object)"sidecarContainers");
        }
        if (sidecarContainers != null) {
            for (SidecarContainers item : sidecarContainers) {
                this.addToSidecarContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSidecarContainers() {
        return this.sidecarContainers != null && !this.sidecarContainers.isEmpty();
    }

    public SidecarContainersNested<A> addNewSidecarContainer() {
        return new SidecarContainersNested(-1, null);
    }

    public SidecarContainersNested<A> addNewSidecarContainerLike(SidecarContainers item) {
        return new SidecarContainersNested(-1, item);
    }

    public SidecarContainersNested<A> setNewSidecarContainerLike(int index, SidecarContainers item) {
        return new SidecarContainersNested(index, item);
    }

    public SidecarContainersNested<A> editSidecarContainer(int index) {
        if (this.sidecarContainers.size() <= index) {
            throw new RuntimeException("Can't edit sidecarContainers. Index exceeds size.");
        }
        return this.setNewSidecarContainerLike(index, this.buildSidecarContainer(index));
    }

    public SidecarContainersNested<A> editFirstSidecarContainer() {
        if (this.sidecarContainers.size() == 0) {
            throw new RuntimeException("Can't edit first sidecarContainers. The list is empty.");
        }
        return this.setNewSidecarContainerLike(0, this.buildSidecarContainer(0));
    }

    public SidecarContainersNested<A> editLastSidecarContainer() {
        int index = this.sidecarContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecarContainers. The list is empty.");
        }
        return this.setNewSidecarContainerLike(index, this.buildSidecarContainer(index));
    }

    public SidecarContainersNested<A> editMatchingSidecarContainer(Predicate<SidecarContainersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecarContainers.size(); ++i) {
            if (!predicate.test(this.sidecarContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecarContainers. No match found.");
        }
        return this.setNewSidecarContainerLike(index, this.buildSidecarContainer(index));
    }

    public Boolean getVerifytls() {
        return this.verifytls;
    }

    public A withVerifytls(Boolean verifytls) {
        this.verifytls = verifytls;
        return (A)((Object)this);
    }

    public boolean hasVerifytls() {
        return this.verifytls != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToVolumeMounts(int index, VolumeMounts item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountsBuilder builder = new VolumeMountsBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(index, builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeMounts(int index, VolumeMounts item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountsBuilder builder = new VolumeMountsBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").set(index, builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeMounts(VolumeMounts ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMounts item : items) {
            VolumeMountsBuilder builder = new VolumeMountsBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeMounts(Collection<VolumeMounts> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMounts item : items) {
            VolumeMountsBuilder builder = new VolumeMountsBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeMounts(VolumeMounts ... items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMounts item : items) {
            VolumeMountsBuilder builder = new VolumeMountsBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMounts> items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMounts item : items) {
            VolumeMountsBuilder builder = new VolumeMountsBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountsBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeMountsBuilder> each = this.volumeMounts.iterator();
        List visitables = this._visitables.get((Object)"volumeMounts");
        while (each.hasNext()) {
            VolumeMountsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VolumeMounts> buildVolumeMounts() {
        return this.volumeMounts != null ? RepoFluent.build(this.volumeMounts) : null;
    }

    public VolumeMounts buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public VolumeMounts buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public VolumeMounts buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public VolumeMounts buildMatchingVolumeMount(Predicate<VolumeMountsBuilder> predicate) {
        for (VolumeMountsBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMountsBuilder> predicate) {
        for (VolumeMountsBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<VolumeMounts> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get((Object)"volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (VolumeMounts item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(VolumeMounts ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMounts item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMounts item) {
        return new VolumeMountsNested(-1, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMounts item) {
        return new VolumeMountsNested(index, item);
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public A addToVolumes(int index, Volumes item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumesBuilder builder = new VolumesBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, Volumes item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumesBuilder builder = new VolumesBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(Volumes ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<Volumes> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(Volumes ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<Volumes> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumes(Predicate<VolumesBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VolumesBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Volumes> buildVolumes() {
        return this.volumes != null ? RepoFluent.build(this.volumes) : null;
    }

    public Volumes buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volumes buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volumes buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volumes buildMatchingVolume(Predicate<VolumesBuilder> predicate) {
        for (VolumesBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumesBuilder> predicate) {
        for (VolumesBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volumes> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volumes item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(Volumes ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volumes item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volumes item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volumes item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepoFluent that = (RepoFluent)((Object)o);
        if (!Objects.equals(this.autotls, that.autotls)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.execTimeout, that.execTimeout)) {
            return false;
        }
        if (!Objects.equals(this.extraRepoCommandArgs, that.extraRepoCommandArgs)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.mountsatoken, that.mountsatoken)) {
            return false;
        }
        if (!Objects.equals(this.remote, that.remote)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.serviceaccount, that.serviceaccount)) {
            return false;
        }
        if (!Objects.equals(this.sidecarContainers, that.sidecarContainers)) {
            return false;
        }
        if (!Objects.equals(this.verifytls, that.verifytls)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autotls, this.enabled, this.env, this.execTimeout, this.extraRepoCommandArgs, this.image, this.initContainers, this.logFormat, this.logLevel, this.mountsatoken, this.remote, this.replicas, this.resources, this.serviceaccount, this.sidecarContainers, this.verifytls, this.version, this.volumeMounts, this.volumes, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autotls != null) {
            sb.append("autotls:");
            sb.append(this.autotls + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.execTimeout != null) {
            sb.append("execTimeout:");
            sb.append(this.execTimeout + ",");
        }
        if (this.extraRepoCommandArgs != null && !this.extraRepoCommandArgs.isEmpty()) {
            sb.append("extraRepoCommandArgs:");
            sb.append(this.extraRepoCommandArgs + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.mountsatoken != null) {
            sb.append("mountsatoken:");
            sb.append(this.mountsatoken + ",");
        }
        if (this.remote != null) {
            sb.append("remote:");
            sb.append(this.remote + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.serviceaccount != null) {
            sb.append("serviceaccount:");
            sb.append(this.serviceaccount + ",");
        }
        if (this.sidecarContainers != null && !this.sidecarContainers.isEmpty()) {
            sb.append("sidecarContainers:");
            sb.append(this.sidecarContainers + ",");
        }
        if (this.verifytls != null) {
            sb.append("verifytls:");
            sb.append(this.verifytls + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withMountsatoken() {
        return this.withMountsatoken(true);
    }

    public A withVerifytls() {
        return this.withVerifytls(true);
    }

    public class EnvNested<N>
    extends EnvFluent<EnvNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)RepoFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endRepoEnv() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends InitContainersFluent<InitContainersNested<N>>
    implements Nested<N> {
        InitContainersBuilder builder;
        int index;

        InitContainersNested(int index, InitContainers item) {
            this.index = index;
            this.builder = new InitContainersBuilder(this, item);
        }

        public N and() {
            return (N)RepoFluent.this.setToInitContainers(this.index, this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)RepoFluent.this.withResources(this.builder.build());
        }

        public N endRepoResources() {
            return this.and();
        }
    }

    public class SidecarContainersNested<N>
    extends SidecarContainersFluent<SidecarContainersNested<N>>
    implements Nested<N> {
        SidecarContainersBuilder builder;
        int index;

        SidecarContainersNested(int index, SidecarContainers item) {
            this.index = index;
            this.builder = new SidecarContainersBuilder(this, item);
        }

        public N and() {
            return (N)RepoFluent.this.setToSidecarContainers(this.index, this.builder.build());
        }

        public N endSidecarContainer() {
            return this.and();
        }
    }

    public class VolumeMountsNested<N>
    extends VolumeMountsFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        VolumeMountsBuilder builder;
        int index;

        VolumeMountsNested(int index, VolumeMounts item) {
            this.index = index;
            this.builder = new VolumeMountsBuilder(this, item);
        }

        public N and() {
            return (N)RepoFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class VolumesNested<N>
    extends VolumesFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumesBuilder builder;
        int index;

        VolumesNested(int index, Volumes item) {
            this.index = index;
            this.builder = new VolumesBuilder(this, item);
        }

        public N and() {
            return (N)RepoFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }
}

