/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.ResourceIgnoreDifferences;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.All;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.AllBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.AllFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.ResourceIdentifiers;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.ResourceIdentifiersBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.ResourceIdentifiersFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceIgnoreDifferencesFluent<A extends ResourceIgnoreDifferencesFluent<A>>
extends BaseFluent<A> {
    private AllBuilder all;
    private ArrayList<ResourceIdentifiersBuilder> resourceIdentifiers;

    public ResourceIgnoreDifferencesFluent() {
    }

    public ResourceIgnoreDifferencesFluent(ResourceIgnoreDifferences instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceIgnoreDifferences instance) {
        ResourceIgnoreDifferences resourceIgnoreDifferences = instance = instance != null ? instance : new ResourceIgnoreDifferences();
        if (instance != null) {
            this.withAll(instance.getAll());
            this.withResourceIdentifiers(instance.getResourceIdentifiers());
        }
    }

    public All buildAll() {
        return this.all != null ? this.all.build() : null;
    }

    public A withAll(All all) {
        this._visitables.remove((Object)"all");
        if (all != null) {
            this.all = new AllBuilder(all);
            this._visitables.get((Object)"all").add(this.all);
        } else {
            this.all = null;
            this._visitables.get((Object)"all").remove((Object)this.all);
        }
        return (A)((Object)this);
    }

    public boolean hasAll() {
        return this.all != null;
    }

    public AllNested<A> withNewAll() {
        return new AllNested(null);
    }

    public AllNested<A> withNewAllLike(All item) {
        return new AllNested(item);
    }

    public AllNested<A> editAll() {
        return this.withNewAllLike(Optional.ofNullable(this.buildAll()).orElse(null));
    }

    public AllNested<A> editOrNewAll() {
        return this.withNewAllLike(Optional.ofNullable(this.buildAll()).orElse(new AllBuilder().build()));
    }

    public AllNested<A> editOrNewAllLike(All item) {
        return this.withNewAllLike(Optional.ofNullable(this.buildAll()).orElse(item));
    }

    public A addToResourceIdentifiers(int index, ResourceIdentifiers item) {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new ArrayList();
        }
        ResourceIdentifiersBuilder builder = new ResourceIdentifiersBuilder(item);
        if (index < 0 || index >= this.resourceIdentifiers.size()) {
            this._visitables.get((Object)"resourceIdentifiers").add(builder);
            this.resourceIdentifiers.add(builder);
        } else {
            this._visitables.get((Object)"resourceIdentifiers").add(index, builder);
            this.resourceIdentifiers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResourceIdentifiers(int index, ResourceIdentifiers item) {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new ArrayList();
        }
        ResourceIdentifiersBuilder builder = new ResourceIdentifiersBuilder(item);
        if (index < 0 || index >= this.resourceIdentifiers.size()) {
            this._visitables.get((Object)"resourceIdentifiers").add(builder);
            this.resourceIdentifiers.add(builder);
        } else {
            this._visitables.get((Object)"resourceIdentifiers").set(index, builder);
            this.resourceIdentifiers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResourceIdentifiers(ResourceIdentifiers ... items) {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new ArrayList();
        }
        for (ResourceIdentifiers item : items) {
            ResourceIdentifiersBuilder builder = new ResourceIdentifiersBuilder(item);
            this._visitables.get((Object)"resourceIdentifiers").add(builder);
            this.resourceIdentifiers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResourceIdentifiers(Collection<ResourceIdentifiers> items) {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new ArrayList();
        }
        for (ResourceIdentifiers item : items) {
            ResourceIdentifiersBuilder builder = new ResourceIdentifiersBuilder(item);
            this._visitables.get((Object)"resourceIdentifiers").add(builder);
            this.resourceIdentifiers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResourceIdentifiers(ResourceIdentifiers ... items) {
        if (this.resourceIdentifiers == null) {
            return (A)((Object)this);
        }
        for (ResourceIdentifiers item : items) {
            ResourceIdentifiersBuilder builder = new ResourceIdentifiersBuilder(item);
            this._visitables.get((Object)"resourceIdentifiers").remove((Object)builder);
            this.resourceIdentifiers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourceIdentifiers(Collection<ResourceIdentifiers> items) {
        if (this.resourceIdentifiers == null) {
            return (A)((Object)this);
        }
        for (ResourceIdentifiers item : items) {
            ResourceIdentifiersBuilder builder = new ResourceIdentifiersBuilder(item);
            this._visitables.get((Object)"resourceIdentifiers").remove((Object)builder);
            this.resourceIdentifiers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResourceIdentifiers(Predicate<ResourceIdentifiersBuilder> predicate) {
        if (this.resourceIdentifiers == null) {
            return (A)((Object)this);
        }
        Iterator<ResourceIdentifiersBuilder> each = this.resourceIdentifiers.iterator();
        List visitables = this._visitables.get((Object)"resourceIdentifiers");
        while (each.hasNext()) {
            ResourceIdentifiersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ResourceIdentifiers> buildResourceIdentifiers() {
        return this.resourceIdentifiers != null ? ResourceIgnoreDifferencesFluent.build(this.resourceIdentifiers) : null;
    }

    public ResourceIdentifiers buildResourceIdentifier(int index) {
        return this.resourceIdentifiers.get(index).build();
    }

    public ResourceIdentifiers buildFirstResourceIdentifier() {
        return this.resourceIdentifiers.get(0).build();
    }

    public ResourceIdentifiers buildLastResourceIdentifier() {
        return this.resourceIdentifiers.get(this.resourceIdentifiers.size() - 1).build();
    }

    public ResourceIdentifiers buildMatchingResourceIdentifier(Predicate<ResourceIdentifiersBuilder> predicate) {
        for (ResourceIdentifiersBuilder item : this.resourceIdentifiers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceIdentifier(Predicate<ResourceIdentifiersBuilder> predicate) {
        for (ResourceIdentifiersBuilder item : this.resourceIdentifiers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceIdentifiers(List<ResourceIdentifiers> resourceIdentifiers) {
        if (this.resourceIdentifiers != null) {
            this._visitables.get((Object)"resourceIdentifiers").clear();
        }
        if (resourceIdentifiers != null) {
            this.resourceIdentifiers = new ArrayList();
            for (ResourceIdentifiers item : resourceIdentifiers) {
                this.addToResourceIdentifiers(item);
            }
        } else {
            this.resourceIdentifiers = null;
        }
        return (A)((Object)this);
    }

    public A withResourceIdentifiers(ResourceIdentifiers ... resourceIdentifiers) {
        if (this.resourceIdentifiers != null) {
            this.resourceIdentifiers.clear();
            this._visitables.remove((Object)"resourceIdentifiers");
        }
        if (resourceIdentifiers != null) {
            for (ResourceIdentifiers item : resourceIdentifiers) {
                this.addToResourceIdentifiers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !this.resourceIdentifiers.isEmpty();
    }

    public ResourceIdentifiersNested<A> addNewResourceIdentifier() {
        return new ResourceIdentifiersNested(-1, null);
    }

    public ResourceIdentifiersNested<A> addNewResourceIdentifierLike(ResourceIdentifiers item) {
        return new ResourceIdentifiersNested(-1, item);
    }

    public ResourceIdentifiersNested<A> setNewResourceIdentifierLike(int index, ResourceIdentifiers item) {
        return new ResourceIdentifiersNested(index, item);
    }

    public ResourceIdentifiersNested<A> editResourceIdentifier(int index) {
        if (this.resourceIdentifiers.size() <= index) {
            throw new RuntimeException("Can't edit resourceIdentifiers. Index exceeds size.");
        }
        return this.setNewResourceIdentifierLike(index, this.buildResourceIdentifier(index));
    }

    public ResourceIdentifiersNested<A> editFirstResourceIdentifier() {
        if (this.resourceIdentifiers.size() == 0) {
            throw new RuntimeException("Can't edit first resourceIdentifiers. The list is empty.");
        }
        return this.setNewResourceIdentifierLike(0, this.buildResourceIdentifier(0));
    }

    public ResourceIdentifiersNested<A> editLastResourceIdentifier() {
        int index = this.resourceIdentifiers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceIdentifiers. The list is empty.");
        }
        return this.setNewResourceIdentifierLike(index, this.buildResourceIdentifier(index));
    }

    public ResourceIdentifiersNested<A> editMatchingResourceIdentifier(Predicate<ResourceIdentifiersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceIdentifiers.size(); ++i) {
            if (!predicate.test(this.resourceIdentifiers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceIdentifiers. No match found.");
        }
        return this.setNewResourceIdentifierLike(index, this.buildResourceIdentifier(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceIgnoreDifferencesFluent that = (ResourceIgnoreDifferencesFluent)((Object)o);
        if (!Objects.equals((Object)this.all, (Object)that.all)) {
            return false;
        }
        return Objects.equals(this.resourceIdentifiers, that.resourceIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.all, this.resourceIdentifiers, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.all != null) {
            sb.append("all:");
            sb.append(this.all + ",");
        }
        if (this.resourceIdentifiers != null && !this.resourceIdentifiers.isEmpty()) {
            sb.append("resourceIdentifiers:");
            sb.append(this.resourceIdentifiers);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AllNested<N>
    extends AllFluent<AllNested<N>>
    implements Nested<N> {
        AllBuilder builder;

        AllNested(All item) {
            this.builder = new AllBuilder(this, item);
        }

        public N and() {
            return (N)ResourceIgnoreDifferencesFluent.this.withAll(this.builder.build());
        }

        public N endAll() {
            return this.and();
        }
    }

    public class ResourceIdentifiersNested<N>
    extends ResourceIdentifiersFluent<ResourceIdentifiersNested<N>>
    implements Nested<N> {
        ResourceIdentifiersBuilder builder;
        int index;

        ResourceIdentifiersNested(int index, ResourceIdentifiers item) {
            this.index = index;
            this.builder = new ResourceIdentifiersBuilder(this, item);
        }

        public N and() {
            return (N)ResourceIgnoreDifferencesFluent.this.setToResourceIdentifiers(this.index, this.builder.build());
        }

        public N endResourceIdentifier() {
            return this.and();
        }
    }
}

