/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.ServerBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Autoscale;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Grpc;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Ingress;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Route;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Service;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"autoscale", "enabled", "env", "extraCommandArgs", "grpc", "host", "ingress", "insecure", "logFormat", "logLevel", "replicas", "resources", "route", "service"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Server
implements Editable<ServerBuilder>,
KubernetesResource {
    @JsonProperty(value="autoscale")
    @JsonPropertyDescription(value="Autoscale defines the autoscale options for the Argo CD Server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Autoscale autoscale;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Enabled is the flag to enable ArgoCD Server during ArgoCD installation. (optional, default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="Env lets you specify environment for API server pods")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Env> env;
    @JsonProperty(value="extraCommandArgs")
    @JsonPropertyDescription(value="Extra Command arguments that would append to the Argo CD server command. ExtraCommandArgs will not be added, if one of these commands is already part of the server command with same or different value.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> extraCommandArgs;
    @JsonProperty(value="grpc")
    @JsonPropertyDescription(value="GRPC defines the state for the Argo CD Server GRPC options.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Grpc grpc;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="Host is the hostname to use for Ingress/Route resources.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="ingress")
    @JsonPropertyDescription(value="Ingress defines the desired state for an Ingress for the Argo CD Server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Ingress ingress;
    @JsonProperty(value="insecure")
    @JsonPropertyDescription(value="Insecure toggles the insecure flag.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean insecure;
    @JsonProperty(value="logFormat")
    @JsonPropertyDescription(value="LogFormat refers to the log level to be used by the ArgoCD Server component. Defaults to ArgoCDDefaultLogFormat if not configured. Valid options are text or json.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logFormat;
    @JsonProperty(value="logLevel")
    @JsonPropertyDescription(value="LogLevel refers to the log level to be used by the ArgoCD Server component. Defaults to ArgoCDDefaultLogLevel if not set.  Valid options are debug, info, error, and warn.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String logLevel;
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="Replicas defines the number of replicas for argocd-server. Default is nil. Value should be greater than or equal to 0. Value will be ignored if Autoscaler is enabled.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer replicas;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources defines the Compute Resources required by the container for the Argo CD server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="route")
    @JsonPropertyDescription(value="Route defines the desired state for an OpenShift Route for the Argo CD Server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Route route;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="Service defines the options for the Service backing the ArgoCD Server component.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Service service;

    public ServerBuilder edit() {
        return new ServerBuilder(this);
    }

    public Autoscale getAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(Autoscale autoscale) {
        this.autoscale = autoscale;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<Env> getEnv() {
        return this.env;
    }

    public void setEnv(List<Env> env) {
        this.env = env;
    }

    public List<String> getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public void setExtraCommandArgs(List<String> extraCommandArgs) {
        this.extraCommandArgs = extraCommandArgs;
    }

    public Grpc getGrpc() {
        return this.grpc;
    }

    public void setGrpc(Grpc grpc) {
        this.grpc = grpc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Ingress getIngress() {
        return this.ingress;
    }

    public void setIngress(Ingress ingress) {
        this.ingress = ingress;
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public void setInsecure(Boolean insecure) {
        this.insecure = insecure;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public String toString() {
        return "Server(autoscale=" + this.getAutoscale() + ", enabled=" + this.getEnabled() + ", env=" + this.getEnv() + ", extraCommandArgs=" + this.getExtraCommandArgs() + ", grpc=" + this.getGrpc() + ", host=" + this.getHost() + ", ingress=" + this.getIngress() + ", insecure=" + this.getInsecure() + ", logFormat=" + this.getLogFormat() + ", logLevel=" + this.getLogLevel() + ", replicas=" + this.getReplicas() + ", resources=" + this.getResources() + ", route=" + this.getRoute() + ", service=" + this.getService() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$insecure = this.getInsecure();
        Boolean other$insecure = other.getInsecure();
        if (this$insecure == null ? other$insecure != null : !((Object)this$insecure).equals(other$insecure)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Autoscale this$autoscale = this.getAutoscale();
        Autoscale other$autoscale = other.getAutoscale();
        if (this$autoscale == null ? other$autoscale != null : !((Object)this$autoscale).equals(other$autoscale)) {
            return false;
        }
        List<Env> this$env = this.getEnv();
        List<Env> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<String> this$extraCommandArgs = this.getExtraCommandArgs();
        List<String> other$extraCommandArgs = other.getExtraCommandArgs();
        if (this$extraCommandArgs == null ? other$extraCommandArgs != null : !((Object)this$extraCommandArgs).equals(other$extraCommandArgs)) {
            return false;
        }
        Grpc this$grpc = this.getGrpc();
        Grpc other$grpc = other.getGrpc();
        if (this$grpc == null ? other$grpc != null : !((Object)this$grpc).equals(other$grpc)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Ingress this$ingress = this.getIngress();
        Ingress other$ingress = other.getIngress();
        if (this$ingress == null ? other$ingress != null : !((Object)this$ingress).equals(other$ingress)) {
            return false;
        }
        String this$logFormat = this.getLogFormat();
        String other$logFormat = other.getLogFormat();
        if (this$logFormat == null ? other$logFormat != null : !this$logFormat.equals(other$logFormat)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Route this$route = this.getRoute();
        Route other$route = other.getRoute();
        if (this$route == null ? other$route != null : !((Object)this$route).equals(other$route)) {
            return false;
        }
        Service this$service = this.getService();
        Service other$service = other.getService();
        return !(this$service == null ? other$service != null : !((Object)this$service).equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $insecure = this.getInsecure();
        result = result * 59 + ($insecure == null ? 43 : ((Object)$insecure).hashCode());
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        Autoscale $autoscale = this.getAutoscale();
        result = result * 59 + ($autoscale == null ? 43 : ((Object)$autoscale).hashCode());
        List<Env> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<String> $extraCommandArgs = this.getExtraCommandArgs();
        result = result * 59 + ($extraCommandArgs == null ? 43 : ((Object)$extraCommandArgs).hashCode());
        Grpc $grpc = this.getGrpc();
        result = result * 59 + ($grpc == null ? 43 : ((Object)$grpc).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Ingress $ingress = this.getIngress();
        result = result * 59 + ($ingress == null ? 43 : ((Object)$ingress).hashCode());
        String $logFormat = this.getLogFormat();
        result = result * 59 + ($logFormat == null ? 43 : $logFormat.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Route $route = this.getRoute();
        result = result * 59 + ($route == null ? 43 : ((Object)$route).hashCode());
        Service $service = this.getService();
        result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
        return result;
    }
}

