/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Server;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Autoscale;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.AutoscaleBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.AutoscaleFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Env;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.EnvBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.EnvFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Grpc;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.GrpcBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.GrpcFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Ingress;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.IngressBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.IngressFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ResourcesFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Route;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.RouteBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.RouteFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Service;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ServiceBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ServiceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServerFluent<A extends ServerFluent<A>>
extends BaseFluent<A> {
    private AutoscaleBuilder autoscale;
    private Boolean enabled;
    private ArrayList<EnvBuilder> env;
    private List<String> extraCommandArgs;
    private GrpcBuilder grpc;
    private String host;
    private IngressBuilder ingress;
    private Boolean insecure;
    private String logFormat;
    private String logLevel;
    private Integer replicas;
    private ResourcesBuilder resources;
    private RouteBuilder route;
    private ServiceBuilder service;

    public ServerFluent() {
    }

    public ServerFluent(Server instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Server instance) {
        Server server = instance = instance != null ? instance : new Server();
        if (instance != null) {
            this.withAutoscale(instance.getAutoscale());
            this.withEnabled(instance.getEnabled());
            this.withEnv(instance.getEnv());
            this.withExtraCommandArgs(instance.getExtraCommandArgs());
            this.withGrpc(instance.getGrpc());
            this.withHost(instance.getHost());
            this.withIngress(instance.getIngress());
            this.withInsecure(instance.getInsecure());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withRoute(instance.getRoute());
            this.withService(instance.getService());
        }
    }

    public Autoscale buildAutoscale() {
        return this.autoscale != null ? this.autoscale.build() : null;
    }

    public A withAutoscale(Autoscale autoscale) {
        this._visitables.remove((Object)"autoscale");
        if (autoscale != null) {
            this.autoscale = new AutoscaleBuilder(autoscale);
            this._visitables.get((Object)"autoscale").add(this.autoscale);
        } else {
            this.autoscale = null;
            this._visitables.get((Object)"autoscale").remove((Object)this.autoscale);
        }
        return (A)((Object)this);
    }

    public boolean hasAutoscale() {
        return this.autoscale != null;
    }

    public AutoscaleNested<A> withNewAutoscale() {
        return new AutoscaleNested(null);
    }

    public AutoscaleNested<A> withNewAutoscaleLike(Autoscale item) {
        return new AutoscaleNested(item);
    }

    public AutoscaleNested<A> editAutoscale() {
        return this.withNewAutoscaleLike(Optional.ofNullable(this.buildAutoscale()).orElse(null));
    }

    public AutoscaleNested<A> editOrNewAutoscale() {
        return this.withNewAutoscaleLike(Optional.ofNullable(this.buildAutoscale()).orElse(new AutoscaleBuilder().build()));
    }

    public AutoscaleNested<A> editOrNewAutoscaleLike(Autoscale item) {
        return this.withNewAutoscaleLike(Optional.ofNullable(this.buildAutoscale()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, Env item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(Env ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServerEnv(Collection<Env> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(Env ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServerEnv(Collection<Env> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServerEnv(Predicate<EnvBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Env> buildEnv() {
        return this.env != null ? ServerFluent.build(this.env) : null;
    }

    public Env buildEnv(int index) {
        return this.env.get(index).build();
    }

    public Env buildFirstEnv() {
        return this.env.get(0).build();
    }

    public Env buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public Env buildMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<Env> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (Env item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(Env ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (Env item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(Env item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, Env item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public A addToExtraCommandArgs(int index, String item) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        this.extraCommandArgs.add(index, item);
        return (A)((Object)this);
    }

    public A setToExtraCommandArgs(int index, String item) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        this.extraCommandArgs.set(index, item);
        return (A)((Object)this);
    }

    public A addToExtraCommandArgs(String ... items) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraCommandArgs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExtraCommandArgs(Collection<String> items) {
        if (this.extraCommandArgs == null) {
            this.extraCommandArgs = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraCommandArgs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExtraCommandArgs(String ... items) {
        if (this.extraCommandArgs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extraCommandArgs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExtraCommandArgs(Collection<String> items) {
        if (this.extraCommandArgs == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.extraCommandArgs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public String getExtraCommandArg(int index) {
        return this.extraCommandArgs.get(index);
    }

    public String getFirstExtraCommandArg() {
        return this.extraCommandArgs.get(0);
    }

    public String getLastExtraCommandArg() {
        return this.extraCommandArgs.get(this.extraCommandArgs.size() - 1);
    }

    public String getMatchingExtraCommandArg(Predicate<String> predicate) {
        for (String item : this.extraCommandArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExtraCommandArg(Predicate<String> predicate) {
        for (String item : this.extraCommandArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExtraCommandArgs(List<String> extraCommandArgs) {
        if (extraCommandArgs != null) {
            this.extraCommandArgs = new ArrayList<String>();
            for (String item : extraCommandArgs) {
                this.addToExtraCommandArgs(item);
            }
        } else {
            this.extraCommandArgs = null;
        }
        return (A)((Object)this);
    }

    public A withExtraCommandArgs(String ... extraCommandArgs) {
        if (this.extraCommandArgs != null) {
            this.extraCommandArgs.clear();
            this._visitables.remove((Object)"extraCommandArgs");
        }
        if (extraCommandArgs != null) {
            for (String item : extraCommandArgs) {
                this.addToExtraCommandArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExtraCommandArgs() {
        return this.extraCommandArgs != null && !this.extraCommandArgs.isEmpty();
    }

    public Grpc buildGrpc() {
        return this.grpc != null ? this.grpc.build() : null;
    }

    public A withGrpc(Grpc grpc) {
        this._visitables.remove((Object)"grpc");
        if (grpc != null) {
            this.grpc = new GrpcBuilder(grpc);
            this._visitables.get((Object)"grpc").add(this.grpc);
        } else {
            this.grpc = null;
            this._visitables.get((Object)"grpc").remove((Object)this.grpc);
        }
        return (A)((Object)this);
    }

    public boolean hasGrpc() {
        return this.grpc != null;
    }

    public GrpcNested<A> withNewGrpc() {
        return new GrpcNested(null);
    }

    public GrpcNested<A> withNewGrpcLike(Grpc item) {
        return new GrpcNested(item);
    }

    public GrpcNested<A> editServerGrpc() {
        return this.withNewGrpcLike(Optional.ofNullable(this.buildGrpc()).orElse(null));
    }

    public GrpcNested<A> editOrNewGrpc() {
        return this.withNewGrpcLike(Optional.ofNullable(this.buildGrpc()).orElse(new GrpcBuilder().build()));
    }

    public GrpcNested<A> editOrNewGrpcLike(Grpc item) {
        return this.withNewGrpcLike(Optional.ofNullable(this.buildGrpc()).orElse(item));
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public Ingress buildIngress() {
        return this.ingress != null ? this.ingress.build() : null;
    }

    public A withIngress(Ingress ingress) {
        this._visitables.remove((Object)"ingress");
        if (ingress != null) {
            this.ingress = new IngressBuilder(ingress);
            this._visitables.get((Object)"ingress").add(this.ingress);
        } else {
            this.ingress = null;
            this._visitables.get((Object)"ingress").remove((Object)this.ingress);
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null;
    }

    public IngressNested<A> withNewIngress() {
        return new IngressNested(null);
    }

    public IngressNested<A> withNewIngressLike(Ingress item) {
        return new IngressNested(item);
    }

    public IngressNested<A> editServerIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(null));
    }

    public IngressNested<A> editOrNewIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(new IngressBuilder().build()));
    }

    public IngressNested<A> editOrNewIngressLike(Ingress item) {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(item));
    }

    public Boolean getInsecure() {
        return this.insecure;
    }

    public A withInsecure(Boolean insecure) {
        this.insecure = insecure;
        return (A)((Object)this);
    }

    public boolean hasInsecure() {
        return this.insecure != null;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)((Object)this);
    }

    public boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)((Object)this);
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editServerResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Route buildRoute() {
        return this.route != null ? this.route.build() : null;
    }

    public A withRoute(Route route) {
        this._visitables.remove((Object)"route");
        if (route != null) {
            this.route = new RouteBuilder(route);
            this._visitables.get((Object)"route").add(this.route);
        } else {
            this.route = null;
            this._visitables.get((Object)"route").remove((Object)this.route);
        }
        return (A)((Object)this);
    }

    public boolean hasRoute() {
        return this.route != null;
    }

    public RouteNested<A> withNewRoute() {
        return new RouteNested(null);
    }

    public RouteNested<A> withNewRouteLike(Route item) {
        return new RouteNested(item);
    }

    public RouteNested<A> editServerRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(null));
    }

    public RouteNested<A> editOrNewRoute() {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(new RouteBuilder().build()));
    }

    public RouteNested<A> editOrNewRouteLike(Route item) {
        return this.withNewRouteLike(Optional.ofNullable(this.buildRoute()).orElse(item));
    }

    public Service buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(Service service) {
        this._visitables.remove((Object)"service");
        if (service != null) {
            this.service = new ServiceBuilder(service);
            this._visitables.get((Object)"service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get((Object)"service").remove((Object)this.service);
        }
        return (A)((Object)this);
    }

    public boolean hasService() {
        return this.service != null;
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(Service item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new ServiceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(Service item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerFluent that = (ServerFluent)((Object)o);
        if (!Objects.equals((Object)this.autoscale, (Object)that.autoscale)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.extraCommandArgs, that.extraCommandArgs)) {
            return false;
        }
        if (!Objects.equals((Object)this.grpc, (Object)that.grpc)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals((Object)this.ingress, (Object)that.ingress)) {
            return false;
        }
        if (!Objects.equals(this.insecure, that.insecure)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals((Object)this.route, (Object)that.route)) {
            return false;
        }
        return Objects.equals((Object)this.service, (Object)that.service);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoscale, this.enabled, this.env, this.extraCommandArgs, this.grpc, this.host, this.ingress, this.insecure, this.logFormat, this.logLevel, this.replicas, this.resources, this.route, this.service, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoscale != null) {
            sb.append("autoscale:");
            sb.append(this.autoscale + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.extraCommandArgs != null && !this.extraCommandArgs.isEmpty()) {
            sb.append("extraCommandArgs:");
            sb.append(this.extraCommandArgs + ",");
        }
        if (this.grpc != null) {
            sb.append("grpc:");
            sb.append(this.grpc + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.insecure != null) {
            sb.append("insecure:");
            sb.append(this.insecure + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.route != null) {
            sb.append("route:");
            sb.append(this.route + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append((Object)this.service);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withInsecure() {
        return this.withInsecure(true);
    }

    public class AutoscaleNested<N>
    extends AutoscaleFluent<AutoscaleNested<N>>
    implements Nested<N> {
        AutoscaleBuilder builder;

        AutoscaleNested(Autoscale item) {
            this.builder = new AutoscaleBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withAutoscale(this.builder.build());
        }

        public N endAutoscale() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvFluent<EnvNested<N>>
    implements Nested<N> {
        EnvBuilder builder;
        int index;

        EnvNested(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endServerEnv() {
            return this.and();
        }
    }

    public class GrpcNested<N>
    extends GrpcFluent<GrpcNested<N>>
    implements Nested<N> {
        GrpcBuilder builder;

        GrpcNested(Grpc item) {
            this.builder = new GrpcBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withGrpc(this.builder.build());
        }

        public N endServerGrpc() {
            return this.and();
        }
    }

    public class IngressNested<N>
    extends IngressFluent<IngressNested<N>>
    implements Nested<N> {
        IngressBuilder builder;

        IngressNested(Ingress item) {
            this.builder = new IngressBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withIngress(this.builder.build());
        }

        public N endServerIngress() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withResources(this.builder.build());
        }

        public N endServerResources() {
            return this.and();
        }
    }

    public class RouteNested<N>
    extends RouteFluent<RouteNested<N>>
    implements Nested<N> {
        RouteBuilder builder;

        RouteNested(Route item) {
            this.builder = new RouteBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withRoute(this.builder.build());
        }

        public N endServerRoute() {
            return this.and();
        }
    }

    public class ServiceNested<N>
    extends ServiceFluent<ServiceNested<N>>
    implements Nested<N> {
        ServiceBuilder builder;

        ServiceNested(Service item) {
            this.builder = new ServiceBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

