/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.Tls;
import io.quarkiverse.argocd.v1beta1.argocdspec.tls.Ca;
import io.quarkiverse.argocd.v1beta1.argocdspec.tls.CaBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.tls.CaFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TlsFluent<A extends TlsFluent<A>>
extends BaseFluent<A> {
    private CaBuilder ca;
    private Map<String, String> initialCerts;

    public TlsFluent() {
    }

    public TlsFluent(Tls instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Tls instance) {
        Tls tls = instance = instance != null ? instance : new Tls();
        if (instance != null) {
            this.withCa(instance.getCa());
            this.withInitialCerts(instance.getInitialCerts());
        }
    }

    public Ca buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(Ca ca) {
        this._visitables.remove((Object)"ca");
        if (ca != null) {
            this.ca = new CaBuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove((Object)this.ca);
        }
        return (A)((Object)this);
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(Ca item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new CaBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(Ca item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public A addToInitialCerts(String key, String value) {
        if (this.initialCerts == null && key != null && value != null) {
            this.initialCerts = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.initialCerts.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToInitialCerts(Map<String, String> map) {
        if (this.initialCerts == null && map != null) {
            this.initialCerts = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.initialCerts.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromInitialCerts(String key) {
        if (this.initialCerts == null) {
            return (A)((Object)this);
        }
        if (key != null && this.initialCerts != null) {
            this.initialCerts.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromInitialCerts(Map<String, String> map) {
        if (this.initialCerts == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.initialCerts == null) continue;
                this.initialCerts.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getInitialCerts() {
        return this.initialCerts;
    }

    public <K, V> A withInitialCerts(Map<String, String> initialCerts) {
        this.initialCerts = initialCerts == null ? null : new LinkedHashMap<String, String>(initialCerts);
        return (A)((Object)this);
    }

    public boolean hasInitialCerts() {
        return this.initialCerts != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TlsFluent that = (TlsFluent)((Object)o);
        if (!Objects.equals((Object)this.ca, (Object)that.ca)) {
            return false;
        }
        return Objects.equals(this.initialCerts, that.initialCerts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ca, this.initialCerts, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ca != null) {
            sb.append("ca:");
            sb.append(this.ca + ",");
        }
        if (this.initialCerts != null && !this.initialCerts.isEmpty()) {
            sb.append("initialCerts:");
            sb.append(this.initialCerts);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CaNested<N>
    extends CaFluent<CaNested<N>>
    implements Nested<N> {
        CaBuilder builder;

        CaNested(Ca item) {
            this.builder = new CaBuilder(this, item);
        }

        public N and() {
            return (N)TlsFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }
}

