/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver.Route;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver.route.Tls;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver.route.TlsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver.route.TlsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RouteFluent<A extends RouteFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private Boolean enabled;
    private Map<String, String> labels;
    private String path;
    private TlsBuilder tls;
    private String wildcardPolicy;

    public RouteFluent() {
    }

    public RouteFluent(Route instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Route instance) {
        Route route = instance = instance != null ? instance : new Route();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withEnabled(instance.getEnabled());
            this.withLabels(instance.getLabels());
            this.withPath(instance.getPath());
            this.withTls(instance.getTls());
            this.withWildcardPolicy(instance.getWildcardPolicy());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Tls buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(Tls tls) {
        this._visitables.remove((Object)"tls");
        if (tls != null) {
            this.tls = new TlsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(Tls item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editRouteTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new TlsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(Tls item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)((Object)this);
    }

    public boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteFluent that = (RouteFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        return Objects.equals(this.wildcardPolicy, that.wildcardPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.enabled, this.labels, this.path, this.tls, this.wildcardPolicy, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.wildcardPolicy != null) {
            sb.append("wildcardPolicy:");
            sb.append(this.wildcardPolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class TlsNested<N>
    extends TlsFluent<TlsNested<N>>
    implements Nested<N> {
        TlsBuilder builder;

        TlsNested(Tls item) {
            this.builder = new TlsBuilder(this, item);
        }

        public N and() {
            return (N)RouteFluent.this.withTls(this.builder.build());
        }

        public N endRouteTls() {
            return this.and();
        }
    }
}

