/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver.ingress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.applicationset.webhookserver.ingress.TlsBuilder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"hosts", "secretName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Tls
implements Editable<TlsBuilder>,
KubernetesResource {
    @JsonProperty(value="hosts")
    @JsonPropertyDescription(value="hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> hosts;
    @JsonProperty(value="secretName")
    @JsonPropertyDescription(value="secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the \"Host\" header field used by an IngressRule, the SNI host is used for termination and value of the \"Host\" header is used for routing.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String secretName;

    public TlsBuilder edit() {
        return new TlsBuilder(this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public String toString() {
        return "Tls(hosts=" + this.getHosts() + ", secretName=" + this.getSecretName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tls)) {
            return false;
        }
        Tls other = (Tls)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        String this$secretName = this.getSecretName();
        String other$secretName = other.getSecretName();
        return !(this$secretName == null ? other$secretName != null : !this$secretName.equals(other$secretName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Tls;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        String $secretName = this.getSecretName();
        result = result * 59 + ($secretName == null ? 43 : $secretName.hashCode());
        return result;
    }
}

