/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.controller;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.controller.Sharding;
import java.util.Objects;

public class ShardingFluent<A extends ShardingFluent<A>>
extends BaseFluent<A> {
    private Integer clustersPerShard;
    private Boolean dynamicScalingEnabled;
    private Boolean enabled;
    private Integer maxShards;
    private Integer minShards;
    private Integer replicas;

    public ShardingFluent() {
    }

    public ShardingFluent(Sharding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Sharding instance) {
        Sharding sharding = instance = instance != null ? instance : new Sharding();
        if (instance != null) {
            this.withClustersPerShard(instance.getClustersPerShard());
            this.withDynamicScalingEnabled(instance.getDynamicScalingEnabled());
            this.withEnabled(instance.getEnabled());
            this.withMaxShards(instance.getMaxShards());
            this.withMinShards(instance.getMinShards());
            this.withReplicas(instance.getReplicas());
        }
    }

    public Integer getClustersPerShard() {
        return this.clustersPerShard;
    }

    public A withClustersPerShard(Integer clustersPerShard) {
        this.clustersPerShard = clustersPerShard;
        return (A)((Object)this);
    }

    public boolean hasClustersPerShard() {
        return this.clustersPerShard != null;
    }

    public Boolean getDynamicScalingEnabled() {
        return this.dynamicScalingEnabled;
    }

    public A withDynamicScalingEnabled(Boolean dynamicScalingEnabled) {
        this.dynamicScalingEnabled = dynamicScalingEnabled;
        return (A)((Object)this);
    }

    public boolean hasDynamicScalingEnabled() {
        return this.dynamicScalingEnabled != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Integer getMaxShards() {
        return this.maxShards;
    }

    public A withMaxShards(Integer maxShards) {
        this.maxShards = maxShards;
        return (A)((Object)this);
    }

    public boolean hasMaxShards() {
        return this.maxShards != null;
    }

    public Integer getMinShards() {
        return this.minShards;
    }

    public A withMinShards(Integer minShards) {
        this.minShards = minShards;
        return (A)((Object)this);
    }

    public boolean hasMinShards() {
        return this.minShards != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShardingFluent that = (ShardingFluent)((Object)o);
        if (!Objects.equals(this.clustersPerShard, that.clustersPerShard)) {
            return false;
        }
        if (!Objects.equals(this.dynamicScalingEnabled, that.dynamicScalingEnabled)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.maxShards, that.maxShards)) {
            return false;
        }
        if (!Objects.equals(this.minShards, that.minShards)) {
            return false;
        }
        return Objects.equals(this.replicas, that.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.clustersPerShard, this.dynamicScalingEnabled, this.enabled, this.maxShards, this.minShards, this.replicas, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clustersPerShard != null) {
            sb.append("clustersPerShard:");
            sb.append(this.clustersPerShard + ",");
        }
        if (this.dynamicScalingEnabled != null) {
            sb.append("dynamicScalingEnabled:");
            sb.append(this.dynamicScalingEnabled + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.maxShards != null) {
            sb.append("maxShards:");
            sb.append(this.maxShards + ",");
        }
        if (this.minShards != null) {
            sb.append("minShards:");
            sb.append(this.minShards + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDynamicScalingEnabled() {
        return this.withDynamicScalingEnabled(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }
}

