/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.prometheus;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.IngressBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.prometheus.ingress.Tls;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "enabled", "ingressClassName", "path", "tls"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Ingress
implements Editable<IngressBuilder>,
KubernetesResource {
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="Annotations is the map of annotations to apply to the Ingress.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="enabled")
    @Required
    @JsonPropertyDescription(value="Enabled will toggle the creation of the Ingress.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="ingressClassName")
    @JsonPropertyDescription(value="IngressClassName for the Ingress resource.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String ingressClassName;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="Path used for the Ingress resource.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String path;
    @JsonProperty(value="tls")
    @JsonPropertyDescription(value="TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Tls> tls;

    public IngressBuilder edit() {
        return new IngressBuilder(this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public void setIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<Tls> getTls() {
        return this.tls;
    }

    public void setTls(List<Tls> tls) {
        this.tls = tls;
    }

    public String toString() {
        return "Ingress(annotations=" + this.getAnnotations() + ", enabled=" + this.getEnabled() + ", ingressClassName=" + this.getIngressClassName() + ", path=" + this.getPath() + ", tls=" + this.getTls() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ingress)) {
            return false;
        }
        Ingress other = (Ingress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$ingressClassName = this.getIngressClassName();
        String other$ingressClassName = other.getIngressClassName();
        if (this$ingressClassName == null ? other$ingressClassName != null : !this$ingressClassName.equals(other$ingressClassName)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<Tls> this$tls = this.getTls();
        List<Tls> other$tls = other.getTls();
        return !(this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ingress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $ingressClassName = this.getIngressClassName();
        result = result * 59 + ($ingressClassName == null ? 43 : $ingressClassName.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<Tls> $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        return result;
    }
}

