/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.initcontainers.livenessprobe;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.initcontainers.livenessprobe.Exec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ExecFluent<A extends ExecFluent<A>>
extends BaseFluent<A> {
    private List<String> command;

    public ExecFluent() {
    }

    public ExecFluent(Exec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Exec instance) {
        Exec exec = instance = instance != null ? instance : new Exec();
        if (instance != null) {
            this.withCommand(instance.getCommand());
        }
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)((Object)this);
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecFluent that = (ExecFluent)((Object)o);
        return Objects.equals(this.command, that.command);
    }

    public int hashCode() {
        return Objects.hash(this.command, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command);
        }
        sb.append("}");
        return sb.toString();
    }
}

