/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.sidecarcontainers;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.sidecarcontainers.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.sidecarcontainers.resources.Claims;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.sidecarcontainers.resources.ClaimsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.sidecarcontainers.resources.ClaimsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourcesFluent<A extends ResourcesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ClaimsBuilder> claims;
    private Map<String, IntOrString> limits;
    private Map<String, IntOrString> requests;

    public ResourcesFluent() {
    }

    public ResourcesFluent(Resources instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Resources instance) {
        Resources resources = instance = instance != null ? instance : new Resources();
        if (instance != null) {
            this.withClaims(instance.getClaims());
            this.withLimits(instance.getLimits());
            this.withRequests(instance.getRequests());
        }
    }

    public A addToClaims(int index, Claims item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        ClaimsBuilder builder = new ClaimsBuilder(item);
        if (index < 0 || index >= this.claims.size()) {
            this._visitables.get((Object)"claims").add(builder);
            this.claims.add(builder);
        } else {
            this._visitables.get((Object)"claims").add(index, builder);
            this.claims.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToClaims(int index, Claims item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        ClaimsBuilder builder = new ClaimsBuilder(item);
        if (index < 0 || index >= this.claims.size()) {
            this._visitables.get((Object)"claims").add(builder);
            this.claims.add(builder);
        } else {
            this._visitables.get((Object)"claims").set(index, builder);
            this.claims.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToClaims(Claims ... items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (Claims item : items) {
            ClaimsBuilder builder = new ClaimsBuilder(item);
            this._visitables.get((Object)"claims").add(builder);
            this.claims.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSidecarcontainersClaims(Collection<Claims> items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (Claims item : items) {
            ClaimsBuilder builder = new ClaimsBuilder(item);
            this._visitables.get((Object)"claims").add(builder);
            this.claims.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromClaims(Claims ... items) {
        if (this.claims == null) {
            return (A)((Object)this);
        }
        for (Claims item : items) {
            ClaimsBuilder builder = new ClaimsBuilder(item);
            this._visitables.get((Object)"claims").remove((Object)builder);
            this.claims.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSidecarcontainersClaims(Collection<Claims> items) {
        if (this.claims == null) {
            return (A)((Object)this);
        }
        for (Claims item : items) {
            ClaimsBuilder builder = new ClaimsBuilder(item);
            this._visitables.get((Object)"claims").remove((Object)builder);
            this.claims.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecarcontainersClaims(Predicate<ClaimsBuilder> predicate) {
        if (this.claims == null) {
            return (A)((Object)this);
        }
        Iterator<ClaimsBuilder> each = this.claims.iterator();
        List visitables = this._visitables.get((Object)"claims");
        while (each.hasNext()) {
            ClaimsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Claims> buildClaims() {
        return this.claims != null ? ResourcesFluent.build(this.claims) : null;
    }

    public Claims buildClaim(int index) {
        return this.claims.get(index).build();
    }

    public Claims buildFirstClaim() {
        return this.claims.get(0).build();
    }

    public Claims buildLastClaim() {
        return this.claims.get(this.claims.size() - 1).build();
    }

    public Claims buildMatchingClaim(Predicate<ClaimsBuilder> predicate) {
        for (ClaimsBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingClaim(Predicate<ClaimsBuilder> predicate) {
        for (ClaimsBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withClaims(List<Claims> claims) {
        if (this.claims != null) {
            this._visitables.get((Object)"claims").clear();
        }
        if (claims != null) {
            this.claims = new ArrayList();
            for (Claims item : claims) {
                this.addToClaims(item);
            }
        } else {
            this.claims = null;
        }
        return (A)((Object)this);
    }

    public A withClaims(Claims ... claims) {
        if (this.claims != null) {
            this.claims.clear();
            this._visitables.remove((Object)"claims");
        }
        if (claims != null) {
            for (Claims item : claims) {
                this.addToClaims(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasClaims() {
        return this.claims != null && !this.claims.isEmpty();
    }

    public ClaimsNested<A> addNewClaim() {
        return new ClaimsNested(-1, null);
    }

    public ClaimsNested<A> addNewClaimLike(Claims item) {
        return new ClaimsNested(-1, item);
    }

    public ClaimsNested<A> setNewClaimLike(int index, Claims item) {
        return new ClaimsNested(index, item);
    }

    public ClaimsNested<A> editClaim(int index) {
        if (this.claims.size() <= index) {
            throw new RuntimeException("Can't edit claims. Index exceeds size.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    public ClaimsNested<A> editFirstClaim() {
        if (this.claims.size() == 0) {
            throw new RuntimeException("Can't edit first claims. The list is empty.");
        }
        return this.setNewClaimLike(0, this.buildClaim(0));
    }

    public ClaimsNested<A> editLastClaim() {
        int index = this.claims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last claims. The list is empty.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    public ClaimsNested<A> editMatchingClaim(Predicate<ClaimsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.claims.size(); ++i) {
            if (!predicate.test(this.claims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching claims. No match found.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    public A addToLimits(String key, IntOrString value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, IntOrString>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLimits(Map<String, IntOrString> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, IntOrString>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)((Object)this);
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLimits(Map<String, IntOrString> map) {
        if (this.limits == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, IntOrString> getLimits() {
        return this.limits;
    }

    public <K, V> A withLimits(Map<String, IntOrString> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, IntOrString>(limits);
        return (A)((Object)this);
    }

    public boolean hasLimits() {
        return this.limits != null;
    }

    public A addToRequests(String key, IntOrString value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, IntOrString>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRequests(Map<String, IntOrString> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, IntOrString>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)((Object)this);
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromRequests(Map<String, IntOrString> map) {
        if (this.requests == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, IntOrString> getRequests() {
        return this.requests;
    }

    public <K, V> A withRequests(Map<String, IntOrString> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, IntOrString>(requests);
        return (A)((Object)this);
    }

    public boolean hasRequests() {
        return this.requests != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourcesFluent that = (ResourcesFluent)((Object)o);
        if (!Objects.equals(this.claims, that.claims)) {
            return false;
        }
        if (!Objects.equals(this.limits, that.limits)) {
            return false;
        }
        return Objects.equals(this.requests, that.requests);
    }

    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claims != null && !this.claims.isEmpty()) {
            sb.append("claims:");
            sb.append(this.claims + ",");
        }
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClaimsNested<N>
    extends ClaimsFluent<ClaimsNested<N>>
    implements Nested<N> {
        ClaimsBuilder builder;
        int index;

        ClaimsNested(int index, Claims item) {
            this.index = index;
            this.builder = new ClaimsBuilder(this, item);
        }

        public N and() {
            return (N)ResourcesFluent.this.setToClaims(this.index, this.builder.build());
        }

        public N endSidecarcontainersClaim() {
            return this.and();
        }
    }
}

