/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.ConfigMap;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.configmap.Items;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.configmap.ItemsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.configmap.ItemsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigMapFluent<A extends ConfigMapFluent<A>>
extends BaseFluent<A> {
    private Integer defaultMode;
    private ArrayList<ItemsBuilder> items;
    private String name;
    private Boolean optional;

    public ConfigMapFluent() {
    }

    public ConfigMapFluent(ConfigMap instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConfigMap instance) {
        ConfigMap configMap = instance = instance != null ? instance : new ConfigMap();
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withItems(instance.getItems());
            this.withName(instance.getName());
            this.withOptional(instance.getOptional());
        }
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)((Object)this);
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToItems(int index, Items item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ItemsBuilder builder = new ItemsBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToItems(int index, Items item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ItemsBuilder builder = new ItemsBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToItems(Items ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Items item : items) {
            ItemsBuilder builder = new ItemsBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToItems(Collection<Items> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Items item : items) {
            ItemsBuilder builder = new ItemsBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromItems(Items ... items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Items item : items) {
            ItemsBuilder builder = new ItemsBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromItems(Collection<Items> items) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        for (Items item : items) {
            ItemsBuilder builder = new ItemsBuilder(item);
            this._visitables.get((Object)"items").remove((Object)builder);
            this.items.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromItems(Predicate<ItemsBuilder> predicate) {
        if (this.items == null) {
            return (A)((Object)this);
        }
        Iterator<ItemsBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ItemsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Items> buildItems() {
        return this.items != null ? ConfigMapFluent.build(this.items) : null;
    }

    public Items buildItem(int index) {
        return this.items.get(index).build();
    }

    public Items buildFirstItem() {
        return this.items.get(0).build();
    }

    public Items buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public Items buildMatchingItem(Predicate<ItemsBuilder> predicate) {
        for (ItemsBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<ItemsBuilder> predicate) {
        for (ItemsBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<Items> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (Items item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)((Object)this);
    }

    public A withItems(Items ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove((Object)"items");
        }
        if (items != null) {
            for (Items item : items) {
                this.addToItems(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(Items item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, Items item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<ItemsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)((Object)this);
    }

    public boolean hasOptional() {
        return this.optional != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapFluent that = (ConfigMapFluent)((Object)o);
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.optional, that.optional);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.name, this.optional, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withOptional() {
        return this.withOptional(true);
    }

    public class ItemsNested<N>
    extends ItemsFluent<ItemsNested<N>>
    implements Nested<N> {
        ItemsBuilder builder;
        int index;

        ItemsNested(int index, Items item) {
            this.index = index;
            this.builder = new ItemsBuilder(this, item);
        }

        public N and() {
            return (N)ConfigMapFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

