/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Pattern;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.EmptyDirBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"medium", "sizeLimit"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class EmptyDir
implements Editable<EmptyDirBuilder>,
KubernetesResource {
    @JsonProperty(value="medium")
    @JsonPropertyDescription(value="medium represents what type of storage medium should back this directory. The default is \"\" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir")
    @JsonSetter(nulls=Nulls.SKIP)
    private String medium;
    @JsonProperty(value="sizeLimit")
    @Pattern(value="^(\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))))?$")
    @JsonPropertyDescription(value="sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir")
    @JsonSetter(nulls=Nulls.SKIP)
    private IntOrString sizeLimit;

    public EmptyDirBuilder edit() {
        return new EmptyDirBuilder(this);
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public IntOrString getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(IntOrString sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public String toString() {
        return "EmptyDir(medium=" + this.getMedium() + ", sizeLimit=" + this.getSizeLimit() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmptyDir)) {
            return false;
        }
        EmptyDir other = (EmptyDir)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$medium = this.getMedium();
        String other$medium = other.getMedium();
        if (this$medium == null ? other$medium != null : !this$medium.equals(other$medium)) {
            return false;
        }
        IntOrString this$sizeLimit = this.getSizeLimit();
        IntOrString other$sizeLimit = other.getSizeLimit();
        return !(this$sizeLimit == null ? other$sizeLimit != null : !this$sizeLimit.equals(other$sizeLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmptyDir;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $medium = this.getMedium();
        result = result * 59 + ($medium == null ? 43 : $medium.hashCode());
        IntOrString $sizeLimit = this.getSizeLimit();
        result = result * 59 + ($sizeLimit == null ? 43 : $sizeLimit.hashCode());
        return result;
    }
}

